
/*
* This file is part of sso-autologin
*
* Copyright (C) 2009 Nokia Corporation. All rights reserved.
*
* Contact: Lucian Horga <ext-lucian.horga@nokia.com>
* Contact: Andrei Laperie <Andrei.Laperie@nokia.com>
*
* This software, including documentation, is protected by copyright
* controlled by Nokia Corporation. All rights are reserved.  Copying,
* including reproducing, storing, adapting or translating, any or all
* of this material requires the prior written consent of Nokia
* Corporation.  This material also contains confidential information
* which may not be disclosed to others without the prior written
* consent of Nokia.
*/

var thisURL = null;
var prevURL = null;
var thisWindowPtr = null;
var prevWindowPtr = null;
var boolSwap = true;

var globalEvent = null;
var currentPageURL = null;
var hookedUsername = null;
var hookedPassword = null;

var m_siteId = null;
var m_username = null; 
var m_password = null;
var m_interval = 0;

var globalSelf = null;
var secondShotConsumed = false;
var thirdShotConsumed  = false;

//retry event
var event = { 
  notify: function(timer) { 
      try {
        var XPCOMController = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
                              .getService(Components.interfaces.microbISsoautologinComponent);
      } 
      catch(err) {
        return;
      }
      //if we have the form we autologin
      if(globalEvent.target.forms.length > 0)
          globalSelf.doAutoLogin(m_siteId, m_username, m_password, globalEvent.target, globalEvent.target.defaultView);
      else  {//else, we just one more time
          if(secondShotConsumed == false) {
              m_interval = Components.classes["@mozilla.org/timer;1"]
                    .createInstance(Components.interfaces.nsITimer);
              //re-fire Auto-login after 1 second so page JS is fully loaded - this is the second attempt
              m_interval.initWithCallback(event,
                                          2000,
                                          Components.interfaces.nsITimer.TYPE_ONE_SHOT);
              secondShotConsumed = true;
          } else
              if(thirdShotConsumed == false) {
                  m_interval = Components.classes["@mozilla.org/timer;1"]
                        .createInstance(Components.interfaces.nsITimer);
                  //re-fire Auto-login after 5 seconds so page JS is fully loaded - this is the last attempt
                  m_interval.initWithCallback(event,
                                              5000,
                                              Components.interfaces.nsITimer.TYPE_ONE_SHOT);
                  thirdShotConsumed = true;
              }
      }
  } 
}

var SSOAutologinScript = {

    getCustomCharPref: function (prefType) {
        try {
          var obj = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
                              .getService(Components.interfaces.microbISsoautologinComponent);
        } 
        catch(err) {
          this.customAlert(err);
          return;
        }
        var prf = obj.GetPref(prefType, "char");
        return prf;
    },

    customAlert : function (text) {
        var winWat = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                    .getService(Components.interfaces.nsIWindowWatcher);
            winWat.activeWindow.alert(text); 
    },

    selectAccountDialogReturned: function(selectAccountDialogStr) {
      try {
        var XPCOMController = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
                              .getService(Components.interfaces.microbISsoautologinComponent);
      } 
      catch(err) {
        this.customAlert(err);
        return;
      }

      var selectedAccountData = selectAccountDialogStr.split(' | ');  
      if(selectedAccountData[0] == "RESULT_LOG_IN") 
      {
	  var username       = selectedAccountData[1];
	  var password       = selectedAccountData[2];

	  var siteId = XPCOMController.GetSiteIdForURLInXMLPrefFile(currentPageURL);

	  this.doAutoLogin(siteId, username, password, globalEvent.target, globalEvent.target.defaultView);
	  XPCOMController.SetDefaultUserForThisURLInXMLPrefFile(username, currentPageURL);
          siteId = null;
	  return;
      }

      if(selectedAccountData[0] == "RESULT_NEVER_STORE_CREDENTIALS_FOR_THIS_PAGE") 
      {
	  var extmgr = Components.classes["@mozilla.org/extensions/manager;1"].getService(Components.interfaces.nsIExtensionManager);
	  extmgr.disableItem("{ce402fde-cb5f-4d5f-a645-8b16b86d6004}");
	  return;
      }
    },	

    observe: function(aSubject, aTopic, aData) {
	try {
	  var XPCOMController = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
				.getService(Components.interfaces.microbISsoautologinComponent);
	} 
	catch(err) {
	  this.customAlert(err);
	  return;
	}

	if (aTopic == "ACCOUNT_SELECTION_DIALOG_LOGIN_CLICKED_TOPIC") 
	{
	    this.selectAccountDialogReturned(aData);
	    try {
		var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
		observerService.removeObserver(this, "ACCOUNT_SELECTION_DIALOG_LOGIN_CLICKED_TOPIC");
	    }
	    catch(err) {
	      XPCOMController.Xlog(err);
	    }
	}
    },

    onSubmit : function (evt) {
      try {
	var XPCOMController = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
			      .getService(Components.interfaces.microbISsoautologinComponent);
      } 
      catch(err) {
	this.customAlert(err);
	return;
      }

      var siteId = XPCOMController.GetSiteIdForURLInXMLPrefFile(currentPageURL);
      if( siteId != null ) {
          this.hookCredentials(siteId, globalEvent.target, globalEvent.target.defaultView);
          if( hookedUsername != null && 
              hookedPassword != null &&
              hookedUsername.length != 0 && 
              hookedPassword.length != 0)
          {
              var haveUsernameInMC = XPCOMController.HaveUsernameInMCForURL(currentPageURL, hookedUsername);
              if(haveUsernameInMC == 'true')
              {
                  haveUsernameInMC = null;
                  siteId = null;
                  hookedUsername = null;
                  hookedPassword = null;
                  return;
              }

              //check credentials validity and upon valid credentials it creates an account and tries to get it online
              XPCOMController.AsyncCheckCredentialsValidity(currentPageURL, hookedUsername, hookedPassword);
              haveUsernameInMC = null;
              siteId = null;
              hookedUsername = null;
              hookedPassword = null;
          }
      }
    },

    onLoad : function (evt) {
          globalSelf = this;
	  try {
	    var XPCOMController = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
				.getService(Components.interfaces.microbISsoautologinComponent);
	  } 
	  catch(err) {
	    this.customAlert(err);
	    return;
	  }

          globalEvent = evt;

	  currentPageURL = evt.target.location.href;   
	  var isaLoginURL = XPCOMController.FoundLoginURLInXMLPrefFile(currentPageURL);

	  if(isaLoginURL == "true")
	  {
              //disables the password manager for this page 
	      try {
		var loginManager = Components.classes["@mozilla.org/login-manager;1"].getService(Components.interfaces.nsILoginManager);
                var loc = evt.target.location;
		loginManager.setLoginSavingEnabled(loc.protocol + "//" + loc.hostname, false);
	      } 
	      catch(err) 
	      {
		XPCOMController.Xlog(err);
	      }

	      var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
	      observerService.addObserver(this, "ACCOUNT_SELECTION_DIALOG_LOGIN_CLICKED_TOPIC", false);

	      var numberOfAccounts = XPCOMController.GetMCAccountsCountForURL(currentPageURL);
	      if(numberOfAccounts >= 1) {
		    var defaultUserName = XPCOMController.GetDefaultUserForThisURLInXMLPrefFile(currentPageURL);
		    var win = evt.target.defaultView;
		    if(defaultUserName != null) {
			if( boolSwap == true ) {
			    boolSwap = false;
			    thisURL = currentPageURL;
			    prevURL = null;
			    thisWindowPtr = win;
			    prevWindowPtr = null;
			}
			else {
			    prevURL = thisURL;
			    thisURL = currentPageURL;
			    prevWindowPtr = thisWindowPtr;
			    thisWindowPtr = win;
			}
			if( prevURL != null && prevWindowPtr != null && prevWindowPtr == thisWindowPtr ) {
			    var prevURLIsaLoginURL = XPCOMController.FoundLoginURLInXMLPrefFile(prevURL);
			    var thisURLIsaFailedLoginURL = XPCOMController.FoundFailedLoginURLInXMLPrefFile(thisURL);
			    if( prevURLIsaLoginURL == 'true' && thisURLIsaFailedLoginURL == 'true' ) {
				XPCOMController.ClearDefaultUserForThisURLInXMLPrefFile(currentPageURL);
				XPCOMController.DisplayHildonSelectAccountDialog(currentPageURL, win); //from here control passes to the callback

                                prevURLIsaLoginURL = null;
                                thisURLIsaFailedLoginURL = null;
                                defaultUserName = null;
				return;
			    }
			}
		      var defaultPassword = XPCOMController.GetDefaultPasswordForThisURLInXMLPrefFile(currentPageURL);
		      if(defaultPassword != null) {
			  var siteId = XPCOMController.GetSiteIdForURLInXMLPrefFile(currentPageURL);
			  if(siteId != null) {
                              //if the form is there we automatically log in
                              if(globalEvent.target.forms.length > 0)
                                  this.doAutoLogin(siteId, defaultUserName, defaultPassword, globalEvent.target, globalEvent.target.defaultView);
                              else { //if not, we wait for one sec and then try again
                                  secondShotConsumed = false;

                                  m_siteId = siteId;
                                  m_username = defaultUserName;
                                  m_password = defaultPassword;

                                  m_interval = Components.classes["@mozilla.org/timer;1"]
                                        .createInstance(Components.interfaces.nsITimer);
                                  //fire Auto-login after 1 second so page JS is fully loaded
                                  secondShotConsumed = false;
                                  thirdShotConsumed  = false;
                                  m_interval.initWithCallback(event,
                                                              1000,
                                                              Components.interfaces.nsITimer.TYPE_ONE_SHOT);       
                              }
                              siteId = null;
			  }
			  else {
			      XPCOMController.ClearDefaultUserForThisURLInXMLPrefFile(currentPageURL);
			      XPCOMController.DisplayHildonSelectAccountDialog(currentPageURL, win); //from here control passes to the callback
			  }
                          defaultPassword = null;
		      }
		      else {
			  XPCOMController.ClearDefaultUserForThisURLInXMLPrefFile(currentPageURL);
			  XPCOMController.DisplayHildonSelectAccountDialog(currentPageURL, win); //from here control passes to the callback
		      }
		    }
		    else  {
			XPCOMController.DisplayHildonSelectAccountDialog(currentPageURL, win); //from here control passes to the callback
		    }
	      }
              numberOfAccounts = null;
	      return;
	  }
	  else {
	      var isaLogoutURL = XPCOMController.FoundLogoutURLInXMLPrefFile(currentPageURL);
	      if( isaLogoutURL == "true" ) {
		  XPCOMController.ClearDefaultUserForThisURLInXMLPrefFile(currentPageURL);
	      }
              isaLogoutURL = null;
	      return;
	  }
          isaLoginURL = null;
    },

    doAutoLogin: function(siteId, siteUsername, sitePassword, doc, eWindow){
	  var siteData = this.getCustomCharPref('siteData' + siteId).split(' ** ');

	  var error = 0;  
	  for (var i = 0; i < siteData.length; i++) {
	      var fieldData = siteData[i].split(' | ');
	      if (fieldData[0] == 1) {
		  var form = globalEvent.target.forms[fieldData[1]];
		  var field = form ? form.elements[fieldData[3]] : 0;
		  if (form && field && (form.getAttribute('method') == fieldData[2] || (!form.getAttribute('method') && !fieldData[2]))) {
		      if ((field.getAttribute('name') != fieldData[4] && !(!field.getAttribute('name') && !fieldData[4])) ||
		      (field.getAttribute('type') != fieldData[6] && !(!field.getAttribute('type') && !fieldData[6]))) {
			  for (var j = 0; j < form.elements.length; j++) {
			      var el = form.elements[j];
			      if (el != null && (el.getAttribute('name') == fieldData[4] || (!el.getAttribute('name') && !fieldData[4])) &&
			      (el.getAttribute('type') == fieldData[6] || (!el.getAttribute('type') && !fieldData[6]))) {
				  if (field.getAttribute('id') != fieldData[5] && !(!field.getAttribute('id') && !fieldData[5])) 
				      error = 1;
				  field = el;
				  break;
			      }
			  }
			  if (j == form.elements.length) {
			      error = 2;
			  }
		      }
		      else 
			  if (field.getAttribute('id') != fieldData[5] && !(!field.getAttribute('id') && !fieldData[5])) {
			      error = 3;
			  }
		  }
		  else {
		      error = 4;
		  }
		  
	      }
	      else {
		  var field = doc.getElementsByTagName(fieldData[1])[fieldData[2]];
		  if (!field ||
		  (field.getAttribute('name') != fieldData[3] && !(!field.getAttribute('name') && !fieldData[3])) ||
		  (field.getAttribute('id') != fieldData[4] && !(!field.getAttribute('id') && !fieldData[4])) ||
		  (field.getAttribute('type') != fieldData[5] && !(!field.getAttribute('type') && !fieldData[5])) ||
		  (field.getAttribute('onclick') != fieldData[6] && !(!field.getAttribute('onclick') && !fieldData[6])) ||
		  (field.getAttribute('src') != fieldData[7] && !(!field.getAttribute('src') && !fieldData[7])) ||
		  (field.getAttribute('href') != fieldData[8] && !(!field.getAttribute('href') && !fieldData[8]))) {
		      var fields = doc.getElementsByTagName(fieldData[1]);
		      var maxNeighbors = 8;
		      if (fields.length > maxNeighbors) {
			  var startIndex = fieldData[2] - maxNeighbors / 2;
			  var lastIndex = fieldData[2] + maxNeighbors / 2;
			  startIndex = startIndex < 0 ? 0 : startIndex;
			  lastIndex = lastIndex >= fields.length ? (fields.length - 1) : lastIndex;
		      }
		      else {
			  var startIndex = 0;
			  var lastIndex = fields.length - 1;
		      }
		      
		      for (; startIndex <= lastIndex; startIndex++) {
			  var fl = fields[startIndex];
			  if ((fl.getAttribute('name') == fieldData[3] || (!fl.getAttribute('name') && !fieldData[3])) &&
			  (fl.getAttribute('id') == fieldData[4] || (!fl.getAttribute('id') && !fieldData[4])) &&
			  (fl.getAttribute('type') == fieldData[5] || (!fl.getAttribute('type') && !fieldData[5])) &&
			  (fl.getAttribute('onclick') == fieldData[6] || (!fl.getAttribute('onclick') && !fieldData[6])) &&
			  (fl.getAttribute('src') == fieldData[7] || (!fl.getAttribute('src') && !fieldData[7])) &&
			  (fl.getAttribute('href') == fieldData[8] || (!fl.getAttribute('href') && !fieldData[8]))) {
			      field = fl;
			      break;
			  }
		      }
		      
		      if (startIndex > lastIndex) {
			  error = 5;
		      }
		      
		  }
	      }
	      if (!error) {	
		  if (i == (siteData.length - 1)) {				
		      var evt = doc.createEvent('MouseEvents');
		      evt.initMouseEvent('click', true, true, eWindow, 0, 0, 0, 0, 0, false, false, false, false, 0, undefined);
		      field.dispatchEvent(evt);
		  }
		  else 
		      if (siteData.length == 2) {
			  field.value = sitePassword;
		      }
		      else {
			  if(i == 0)
			      var ssoVal = siteUsername;
			  else
			      var ssoVal = sitePassword;

			  field.value = ssoVal;
		      }
		  
	      }
	      else {
		  break;
	      }
	  } 
      },

    hookCredentials: function(siteId, doc, eWindow){
	  var siteData = this.getCustomCharPref('siteData' + siteId).split(' ** ');
	  var error;
	  for (var i = 0; i < siteData.length; i++) {
	      var fieldData = siteData[i].split(' | ');
	      if (fieldData[0] == 1) {
		  var form = doc.forms[fieldData[1]];
		  var field = form ? form.elements[fieldData[3]] : 0;
		  if (form && field && (form.getAttribute('method') == fieldData[2] || (!form.getAttribute('method') && !fieldData[2]))) {
		      if ((field.getAttribute('name') != fieldData[4] && !(!field.getAttribute('name') && !fieldData[4])) ||
		      (field.getAttribute('type') != fieldData[6] && !(!field.getAttribute('type') && !fieldData[6]))) {
			  for (var j = 0; j < form.elements.length; j++) {
			      var el = form.elements[j];
			      if ((el.getAttribute('name') == fieldData[4] || (!el.getAttribute('name') && !fieldData[4])) &&
			      (el.getAttribute('type') == fieldData[6] || (!el.getAttribute('type') && !fieldData[6]))) {
				  if (field.getAttribute('id') != fieldData[5] && !(!field.getAttribute('id') && !fieldData[5])) 
				      error = 1;
				  field = el;
				  break;
			      }
			  }
			  if (j == form.elements.length) {
			      error = 2;
			  }
		      }
		      else 
			  if (field.getAttribute('id') != fieldData[5] && !(!field.getAttribute('id') && !fieldData[5])) {
			      error = 3;
			  }
		  }
		  else {
		      error = 4;
		  }  
	      }
	      else {
		  var field = doc.getElementsByTagName(fieldData[1])[fieldData[2]];
		  if (!field ||
		  (field.getAttribute('name') != fieldData[3] && !(!field.getAttribute('name') && !fieldData[3])) ||
		  (field.getAttribute('id') != fieldData[4] && !(!field.getAttribute('id') && !fieldData[4])) ||
		  (field.getAttribute('type') != fieldData[5] && !(!field.getAttribute('type') && !fieldData[5])) ||
		  (field.getAttribute('onclick') != fieldData[6] && !(!field.getAttribute('onclick') && !fieldData[6])) ||
		  (field.getAttribute('src') != fieldData[7] && !(!field.getAttribute('src') && !fieldData[7])) ||
		  (field.getAttribute('href') != fieldData[8] && !(!field.getAttribute('href') && !fieldData[8]))) {
		      var fields = doc.getElementsByTagName(fieldData[1]);
		      var maxNeighbors = 8;
		      if (fields.length > maxNeighbors) {
			  var startIndex = fieldData[2] - maxNeighbors / 2;
			  var lastIndex = fieldData[2] + maxNeighbors / 2;
			  startIndex = startIndex < 0 ? 0 : startIndex;
			  lastIndex = lastIndex >= fields.length ? (fields.length - 1) : lastIndex;
		      }
		      else {
			  var startIndex = 0;
			  var lastIndex = fields.length - 1;
		      }
		      
		      for (; startIndex <= lastIndex; startIndex++) {
			  var fl = fields[startIndex];
			  if ((fl.getAttribute('name') == fieldData[3] || (!fl.getAttribute('name') && !fieldData[3])) &&
			  (fl.getAttribute('id') == fieldData[4] || (!fl.getAttribute('id') && !fieldData[4])) &&
			  (fl.getAttribute('type') == fieldData[5] || (!fl.getAttribute('type') && !fieldData[5])) &&
			  (fl.getAttribute('onclick') == fieldData[6] || (!fl.getAttribute('onclick') && !fieldData[6])) &&
			  (fl.getAttribute('src') == fieldData[7] || (!fl.getAttribute('src') && !fieldData[7])) &&
			  (fl.getAttribute('href') == fieldData[8] || (!fl.getAttribute('href') && !fieldData[8]))) {
			      field = fl;
			      break;
			  }
		      }
		      
		      if (startIndex > lastIndex) {
			  error = 5;
		      }
		  }
	      }
	      if (!error) {
		  // field was confirmed. proceed to hook credentials from it	
		  if (i != (siteData.length - 1)) {
		      if (siteData.length == 2) {
			  hookedPassword = field.value;
		      }
		      else {
			 if(i == 0) {
			      //trimming spaces for username
			      hookedUsername = field.value.replace(/^\s+|\s+$/g,"");

			      //checking for illegal characters
			      var illegalChars = /[#&"']/;
			      if( illegalChars.test(hookedUsername) ) { 
				    hookedUsername = null;
				    hookedPassword = null;
			      }
			 }
			 else {
			     hookedPassword = field.value;
			 }
		      }
		 }
	      }
	      else {
		  break;
	      }
	  }          
      }
}
