#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Libraries
######################################################
import gconf

#Classes
######################################################
class Config:
	def __init__(self, Parent):
		self.Parent = Parent
		self.version = '0.3.0'
		self.trustedWlans = []
		self.trustedMobileNetworks = []
		self.client = gconf.client_get_default()

	def startNotifier(self):
		self.getTrustedNetworks()
		self.timeout = self.getTimeout()
		self.instantLockOnDisconnect = self.getInstantLockOnDisconnect()
		self.instantLockOnDetach = self.getInstantLockOnDetach()
		self.notifications = self.getNotifications()
		self.client.add_dir('/system/osso/connectivity/IAP', gconf.CLIENT_PRELOAD_NONE)
		self.client.notify_add('/system/osso/connectivity/IAP', self.updateTrustedNetworks)
		self.client.add_dir('/apps/connlock', gconf.CLIENT_PRELOAD_NONE)
		self.client.notify_add('/apps/connlock', self.updateSettings)

	def getTrustedNetworks(self):
		for network in self.client.all_dirs('/system/osso/connectivity/IAP'):
			try: #TODO: Smarter way?
				self.client.get_value(network+'/wlan_security')
				wlan = True
			except:
				wlan = False
			try:
				trusted = self.client.get_value(network+'/trusted')
			except:
				trusted = False
			if wlan and trusted:
				self.trustedWlans.append(network.split('/')[5])
			elif trusted:
				try:
					self.trustedMobileNetworks.append(self.client.get_value(network+'/name'))
				except:
					pass

	def updateTrustedNetworks(self, client, cnxn_id, entry, *extra):
		key = entry.get_key()
		#Correct key?
		if key[-8:] == '/trusted':
			#Get some values..
			type = self.client.get_value(key.replace('/trusted', '/type'))
			id = key.split('/')[5]
			if type != 'WLAN_INFRA':
				try:
					name = self.client.get_value(key.replace('/trusted', '/name'))
				except:
					pass
			#Add networks
			if entry.value.to_string() == 'true': #TODO: better way?
				if type == 'WLAN_INFRA' and id not in self.trustedWlans:
					self.trustedWlans.append(id)
				elif type != 'WLAN_INFRA':
					if name not in self.trustedMobileNetworks:
						self.trustedMobileNetworks.append(name)
			#Remove networks?
			else:
				temp=[]
				if type == 'WLAN_INFRA':
					for network in self.trustedWlans:
						if id != network:
							temp.append(network)
					self.trustedWlans = temp
				else:
					try:
						name = self.client.get_value(key.replace('/trusted', '/name'))
					except:
						pass
					for network in self.trustedMobileNetworks:
						if name != network:
							temp.append(name)
					self.trustedMobileNetworks = temp
		self.Parent.refreshSecurity()

	def updateSettings(self, client, cnxn_id, entry, *extra):
		if entry.value.to_string() == 'true':
			status = True
		else:
			status = False
		key = entry.get_key().split('/')[3]
		if key == 'instant_lock_on_disconnect':
			self.instantLockOnDisconnect = status
		elif key == 'instant_lock_on_detach':
			self.instantLockOnDetach = status
		elif key == 'notifications':
			self.notifications = status

	def setTrustedNetworks(self, networks):
		for network in networks:
			self.client.set_bool('/system/osso/connectivity/IAP/'+network[0]+'/trusted', network[2])

	def getAllNetworks(self):
		networks = []
		for network in self.client.all_dirs('/system/osso/connectivity/IAP'):
			try:
				trusted = self.client.get_value(network+'/trusted')
			except:
				trusted = False
			try:
				networks.append([network.split('/')[5], self.client.get_value(network+'/name'), trusted])
			except:
				pass
		return networks

	def setTimeout(self, timeout):
		return self.client.set_int('/system/osso/dsm/locks/devicelock_autolock_timeout', timeout)

	def getTimeout(self):
		return self.client.get_value('/system/osso/dsm/locks/devicelock_autolock_timeout')

	def setInstantLockOnDisconnect(self, lock):
		return self.client.set_bool('/apps/connlock/instant_lock_on_disconnect', lock)

	def getInstantLockOnDisconnect(self):
		try:
			output = self.client.get_value('/apps/connlock/instant_lock_on_disconnect')
		except:
			output = False
		return output

	def setInstantLockOnDetach(self, lock):
		return self.client.set_bool('/apps/connlock/instant_lock_on_detach', lock)

	def getInstantLockOnDetach(self):
		try:
			output = self.client.get_value('/apps/connlock/instant_lock_on_detach')
		except:
			output = False
		return output

	def setNotifications(self, notify):
		return self.client.set_bool('/apps/connlock/notifications', notify)

	def getNotifications(self):
		try:
			output = self.client.get_value('/apps/connlock/notifications')
		except:
			output = False
		return output
