#ifndef COMPAREDIALOG_H
#define COMPAREDIALOG_H

#include <QDialog>
#include <QDir>
#include <QFile>
#include <QDateTime>
#include <QFileDialog>
#include <QFileInfo>
#include <QTextStream>

class configReader;
class writeWindow;

namespace Ui {
    class compareDialog;
}

class compareDialog : public QDialog
{
    Q_OBJECT

public:
    explicit compareDialog(QWidget *parent = 0);
    ~compareDialog();

public slots:
    void openFile1();
    void openFile2();
    void swapFiles();
    void readFiles();

private:
    Ui::compareDialog *ui;
    configReader* compareParent;
    writeWindow* writeWin;

    QDir defaultDir;
    QFile swapFile1;
    QFile swapFile2;
    QDateTime fileDateTime1;
    QDateTime fileDateTime2;
    QTextStream fileContStrm;

    void checkFiles();
    void readFile1();
    void readFile2();
    void openWriteWin();
};

#endif // COMPAREDIALOG_H
