#ifndef COMPASSSLIDE_H
#define COMPASSSLIDE_H

#include <QWidget>
#include <QPainter>

#include "AbstractCompass.h"

class CompassSlidePrivate;

class CompassSlide : public AbstractCompass
{
    Q_OBJECT

    Q_ENUMS(DisplayMode)

    Q_PROPERTY(DisplayMode displayMode READ displayMode WRITE setDisplayMode)

public:
    enum DisplayMode {Top, Bottom, TopAndBottom};

    explicit         CompassSlide   (QWidget *parent = 0);
                     CompassSlide   (DisplayMode mode, QWidget *parent = 0);

    int              heightForWidth (int width) const;

    DisplayMode      displayMode    () const;

public slots:
    void             setDisplayMode (DisplayMode mode);

protected:
    void             paintEvent     (QPaintEvent *event);

    virtual void     draw           (QPainter *painter);

private:
    CompassSlidePrivate *d;
};

#endif // COMPASSSLIDE_H
