#include "ColumbusDialogWaypointsItemMenu.h"

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogWaypointsItemMenuPrivate
{
public:
    ColumbusWaypoint *waypoint;

    QLabel *latitude;
    QLabel *longitude;
    QLabel *altitude;

    QPushButton *navbtn;
    QPushButton *updbtn;
    QPushButton *delbtn;
};

ColumbusDialogWaypointsItemMenu::ColumbusDialogWaypointsItemMenu(QWidget *parent)
    : ColumbusDialog(parent)
{
    this->d = new ColumbusDialogWaypointsItemMenuPrivate;
    d->waypoint = NULL;
    this->setupUi();
}

ColumbusDialogWaypointsItemMenu::~ColumbusDialogWaypointsItemMenu()
{
    if(d->waypoint != NULL) delete d->waypoint;
    delete this->d;
}

ColumbusWaypoint ColumbusDialogWaypointsItemMenu::waypoint() const
{
    return ColumbusWaypoint(*d->waypoint);
}

void ColumbusDialogWaypointsItemMenu::setWaypoint(const ColumbusWaypoint &waypoint)
{
    if(d->waypoint != NULL) delete d->waypoint;

    d->waypoint = new ColumbusWaypoint(waypoint);
    this->updateUi();
}

void ColumbusDialogWaypointsItemMenu::setupUi()
{
    QFormLayout *form = new QFormLayout();
    QVBoxLayout *vbox = new QVBoxLayout(this);
    QHBoxLayout *hbox = new QHBoxLayout();

    form->setLabelAlignment(Qt::AlignRight | Qt::AlignVCenter);

    d->latitude  = new QLabel(this);
    d->longitude = new QLabel(this);
    //d->altitude  = new QLabel(this);

    d->navbtn = new QPushButton(tr("Navigate To"), this);
    d->updbtn = new QPushButton(tr("Update"), this);
    d->delbtn = new QPushButton(tr("Delete"), this);

    form->addRow(tr("Latitude"), d->latitude);
    form->addRow(tr("Longitude"), d->longitude);
    //form->addRow(tr("Altitude"), d->altitude);

    hbox->addWidget(d->updbtn);
    hbox->addWidget(d->delbtn);

    vbox->addLayout(form);
    vbox->addWidget(d->navbtn);
    vbox->addLayout(hbox);

    QObject::connect(d->navbtn, SIGNAL(clicked()), this, SLOT(onButtonPressed()));
    QObject::connect(d->updbtn, SIGNAL(clicked()), this, SLOT(onButtonPressed()));
    QObject::connect(d->delbtn, SIGNAL(clicked()), this, SLOT(onButtonPressed()));
}

void ColumbusDialogWaypointsItemMenu::updateUi()
{
    this->setWindowTitle(d->waypoint->name());

    d->latitude->setText(QString::number(d->waypoint->coordinate().latitude()));
    d->longitude->setText(QString::number(d->waypoint->coordinate().longitude()));

    /*
    if(qIsNaN(d->waypoint->coordinate().altitude()))
    {
        d->altitude->setText("-");
    }
    else
    {
        d->altitude->setText(QString::number(d->waypoint->coordinate().altitude()));
    }
    */
}

void ColumbusDialogWaypointsItemMenu::onButtonPressed()
{
    QObject *sender = QObject::sender();

    if(sender == d->navbtn)
    {
        emit this->navigateTo(this->waypoint());
    }
    else if(sender == d->updbtn)
    {
        emit this->updateWaypoint(this->waypoint());
    }
    else if(sender == d->delbtn)
    {
        emit this->deleteWaypoint(this->waypoint());
    }
}
