#ifndef TCPNETWORKCONNECTOR_H
#define TCPNETWORKCONNECTOR_H

#include <QObject>
#include <QAbstractSocket>

#include "NetworkServiceProvider.h"
#include <rx/columbus/logging/LoggingServicePerformerFactory.h>

class TCPNetworkConnectorPrivate;

class TCPNetworkConnector : public NetworkServiceProvider
{
    Q_OBJECT

public:
    explicit TCPNetworkConnector(const QString &address, quint16 port, LoggingServicePerformerFactory *factory, QObject *parent = 0);
            ~TCPNetworkConnector();

    bool initialize();

protected slots:
    void onSocketStateChanged(QAbstractSocket::SocketState state);

    void onConnect();
    void onDisconnect();

protected:
    void timerEvent(QTimerEvent *event);

private:
    TCPNetworkConnectorPrivate *d;
};

#endif // TCPNETWORKCONNECTOR_H
