#ifndef BLUETOOTHSERVERCONFIG_H
#define BLUETOOTHSERVERCONFIG_H

#include <QObject>

class BluetoothServerConfigPrivate;

class BluetoothServerConfig : public QObject
{
    Q_OBJECT

public:
    typedef enum {
        MasterMode,
        SlaveMode
    } OperatingMode;

    explicit BluetoothServerConfig(QObject *parent = 0);
            ~BluetoothServerConfig();

    bool operator == (const BluetoothServerConfig &other);
    bool operator != (const BluetoothServerConfig &other);

    bool isEnabled() const;
    bool isRunOnStartup() const;
    OperatingMode mode() const;
    int channel() const;
    QString peerAddress() const;
    QString formatId() const;

public slots:
    void load();
    void save();

    void setEnabled(bool on = true);
    void setRunOnStartup(bool on = true);
    void setMode(OperatingMode mode);
    void setChannel(int channel);
    void setPeerAddress(const QString &address);
    void setFormatId(const QString &formatId);

private:
    BluetoothServerConfigPrivate *d;
};

#endif // BLUETOOTHSERVERCONFIG_H
