#include "BluetoothServerConfig.h"

#include <QSettings>

#define CONFIG_KEY_BLUETOOTH_SERVICE_IS_ENABLED         "/plugins/bluetooth-server/enable"
#define CONFIG_KEY_BLUETOOTH_SERVICE_IS_RUN_ON_STARTUP  "/plugins/bluetooth-server/startup"
#define CONFIG_KEY_BLUETOOTH_SERVICE_OPERATING_MODE     "/plugins/bluetooth-server/mode"
#define CONFIG_KEY_BLUETOOTH_SERVICE_OPERATING_CHANNEL  "/plugins/bluetooth-server/channel"
#define CONFIG_KEY_BLUETOOTH_SERVICE_PEER_ADDRESS       "/plugins/bluetooth-server/peer-address"
#define CONFIG_KEY_BLUETOOTH_SERVICE_FORMAT             "/plugins/bluetooth-server/format"

class BluetoothServerConfigPrivate
{
public:
    bool isEnabled;
    bool isRunOnStartup;
    BluetoothServerConfig::OperatingMode mode;
    int channel;
    QString peerAddress;
    QString formatId;
};

BluetoothServerConfig::BluetoothServerConfig(QObject *parent)
    : QObject(parent)
{
    this->d = new BluetoothServerConfigPrivate;
}

BluetoothServerConfig::~BluetoothServerConfig()
{
    delete this->d;
}

bool BluetoothServerConfig::operator == (const BluetoothServerConfig &other)
{
    return this->isEnabled() == other.isEnabled() &&
           //this->isRunOnStartup() == other.isRunOnStartup() && // We don't need to know about this ...
           this->mode() == other.mode() &&
           this->channel() == other.channel() &&
           this->peerAddress() == other.peerAddress() &&
           this->formatId() == other.formatId();
}

bool BluetoothServerConfig::operator != (const BluetoothServerConfig &other)
{
    return !(*this == other);
}

void BluetoothServerConfig::load()
{
    d->isEnabled = QSettings().value(CONFIG_KEY_BLUETOOTH_SERVICE_IS_ENABLED, false).toBool();
    d->isRunOnStartup = QSettings().value(CONFIG_KEY_BLUETOOTH_SERVICE_IS_RUN_ON_STARTUP, false).toBool();
    d->mode = (BluetoothServerConfig::OperatingMode)QSettings().value(CONFIG_KEY_BLUETOOTH_SERVICE_OPERATING_MODE, "master").toInt();
    d->channel = QSettings().value(CONFIG_KEY_BLUETOOTH_SERVICE_OPERATING_CHANNEL, 0).toInt();
    d->peerAddress = QSettings().value(CONFIG_KEY_BLUETOOTH_SERVICE_PEER_ADDRESS, "").toString();
    d->formatId = QSettings().value(CONFIG_KEY_BLUETOOTH_SERVICE_FORMAT, "nmea").toString();
}

void BluetoothServerConfig::save()
{
    QSettings().setValue(CONFIG_KEY_BLUETOOTH_SERVICE_IS_ENABLED, d->isEnabled);
    QSettings().setValue(CONFIG_KEY_BLUETOOTH_SERVICE_IS_RUN_ON_STARTUP, d->isRunOnStartup);
    QSettings().setValue(CONFIG_KEY_BLUETOOTH_SERVICE_OPERATING_MODE, (int)d->mode);
    QSettings().setValue(CONFIG_KEY_BLUETOOTH_SERVICE_OPERATING_CHANNEL, d->channel);
    QSettings().setValue(CONFIG_KEY_BLUETOOTH_SERVICE_PEER_ADDRESS, d->peerAddress);
    QSettings().setValue(CONFIG_KEY_BLUETOOTH_SERVICE_FORMAT, d->formatId);
}

bool BluetoothServerConfig::isEnabled() const
{
    return d->isEnabled;
}

bool BluetoothServerConfig::isRunOnStartup() const
{
    return d->isRunOnStartup;
}

BluetoothServerConfig::OperatingMode BluetoothServerConfig::mode() const
{
    return d->mode;
}

int BluetoothServerConfig::channel() const
{
    return d->channel;
}

QString BluetoothServerConfig::peerAddress() const
{
    return d->peerAddress;
}

QString BluetoothServerConfig::formatId() const
{
    return d->formatId;
}

void BluetoothServerConfig::setEnabled(bool isEnabled)
{
    d->isEnabled = isEnabled;
}

void BluetoothServerConfig::setRunOnStartup(bool isRunOnStartup)
{
    d->isRunOnStartup = isRunOnStartup;
}

void BluetoothServerConfig::setMode(BluetoothServerConfig::OperatingMode mode)
{
    d->mode = mode;
}

void BluetoothServerConfig::setChannel(int channel)
{
    d->channel = channel;
}

void BluetoothServerConfig::setPeerAddress(const QString &address)
{
    d->peerAddress = address;
}

void BluetoothServerConfig::setFormatId(const QString &formatId)
{
    d->formatId = formatId;
}
