#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

class UseForm;
class SearchForm;
class OnOffForm;
class AboutForm;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void on_actionUseful_Commands_triggered();

    void on_actionSearch_File_triggered();

    void on_actionON_OFF_triggered();

    void on_pushButton_clicked();

    void on_autoclean_clicked();

    void on_autoremove_clicked();

    void on_purge_clicked();

    void on_update_clicked();

    void on_upgrade_clicked();

    void on_reboot_clicked();

    void on_purgedpkg_clicked();

    void on_backup_clicked();

    void on_rebackup_clicked();

    void on_deb_clicked();

    void on_removepack_clicked();

    void on_reboot_2_clicked();

    void on_actionXTerm_with_root_triggered();

    void on_actionHardware_Details_triggered();

    void on_actionAbout_triggered();

    void on_actionDonate_triggered();

private:
    Ui::MainWindow *ui;
    UseForm *useForm;
    SearchForm *searchForm;
    OnOffForm *onoffForm;
    AboutForm *aboutForm;
};

#endif // MAINWINDOW_H
