#!/bin/ash
#Clean900
#version 1.1.2
#by incrys for www.maemomeego.net

if [ `id -u` != 0 ] ; then
    exec root <<EOF
exec sh $0 $*
EOF
	exit $?
fi 


gest=`ps ux |grep -c hildon-application-manager`

if [ $gest = 3 ]
	then
		quest=$(zenity --warning --title CleaN900 --text "Do you have application manager open! Press Ok to close, otherwise press out";echo $?)

	else
		quest=0
fi



if [ $quest -eq 0 ]
		then
			killall hildon-application-manager > \/tmp\/output.txt 2> \/dev\/null
			killall apt-worker > \/tmp\/output.txt 2> \/dev\/null
			killall apt-worker.real > \/tmp\/output.txt 2> \/dev\/null
	inputline=$(zenity --title=CleanN900 --height 350 --list  --text "Select the operations you are interested" --column "Options" \
		"clean" "autoclean" "autoremove" "purge" "Update" "Upgrade" "Install a package .deb" "Remove specific package" "Reboot" \
	--separator=":")

IFS=":"
for prova in $inputline; do
case $prova in

	"clean")apt-get clean | zenity --progress --pulsate --title="Clean" --text="Wait for the loading bar"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Clean executed";;

	"autoclean")apt-get autoclean | zenity --progress --pulsate --title="Autoclean" --text="Wait for the loading bar"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoclean executed";;

	"autoremove")apt-get autoremove | zenity --progress --pulsate --title="Autoremove" --text="Wait for the loading bar"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoremove executed";;

	"purge")apt-get purge | zenity --title="Output Purge" --text-info
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Purge executed";;

	"Update")conn=`ping -c 1 209.236.120.65 |grep 'received' | awk -F',' '{ print $2 }' | awk '{ print $1 }'`
		if [ "$conn" != "1" ]
			then
				ric=`zenity --warning --title CleaN900 --text "You must have the active connection, preferably wifi. If you want to connect click OK, otherwise press out";echo $?`
					if [ "$ric" = 0 ]
						then
							dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connection in progress... Please wait..." 
							sleep 9
							apt-get update | zenity --title="Output Update" --text-info
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Completed" 
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
					fi
	 
			else
				apt-get update | zenity --title="Output Update" --text-info
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Completed"
		fi
;;

	"Upgrade")
		res=$(echo "n" | apt-get upgrade )
		if [ $? -eq 1 ]; then
			if zenity --title=Clean900 --question --text "$res"; then
					res=$(apt-get upgrade -f -y --force-yes)
					dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Updates executed"
				else
					dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
			fi
		fi
			zenity --title=Clean900 --info --text "$res"
			;;

	"Install a package .deb")
				pacchetto=`zenity --title CleaN900 --file-selection --text='Select .deb' --filename=/home/user/MyDocs/ --file-filter "*.deb"`
					if [ $? -eq 0 ]; then
							dpkg -i $pacchetto | zenity --progress --pulsate --title="Install" --text="Wait for the loading bar"
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Package installed"
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
					fi
				;;				

	"Remove specific package")conn=`ping -c 1 209.236.120.65 |grep 'received' | awk -F',' '{ print $2 }' | awk '{ print $1 }'`
		if [ "$conn" != "1" ]
			then
				ric=`zenity --warning --title CleaN900 --text "You must have the active connection, preferably wifi. If you want to connect click OK, otherwise press out";echo $?`
					if [ "$ric" = 0 ]
						then
							dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
							sleep 9
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connection in progress... Please wait..."
							pacchetto=`zenity --entry --title='Uninstall' --text='Enter the name of the package'`
							dpkg -r $pacchetto | zenity --progress --pulsate --title="Uninstall" --text="Wait for the loading bar"
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Package uninstalled" #;;
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
					fi
			else
				pacchetto=`zenity --entry --title='Uninstall' --text='Enter the name of the package'`

					if [ $? -eq 0 ]; then
							dpkg -r $pacchetto | zenity --progress --pulsate --title="Uninstall" --text="Wait for the loading bar"
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Package uninstalled"
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
					fi
		fi
;;
	"Reboot")dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
			org.freedesktop.Notifications.SystemNoteInfoprint string:"Restarting... Please wait..."
				reboot;;

esac
done
	else
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
fi
