#include "lensconfiguration.h"
#include "ui_lensconfiguration.h"
#include "ClassicPrintLens.h"
#include "enternamedialog.h"
#include "ClassicPrintSettings.h"

LensConfiguration::LensConfiguration(ClassicPrint* cp, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LensConfiguration)
{
    ui->setupUi(this);

	// Copy the current lens to work on
	m_lens = new ClassicPrintLens();
	if (cp->getCurrentLens()) {
		*m_lens = *cp->getCurrentLens();
	}

    // Put the icons on the buttons
    QIcon icon_delete(QIcon(ClassicPrintSettings::config_dir() + "/icons/camera_delete.png"));
    icon_delete.addFile(ClassicPrintSettings::config_dir() + "/icons/camera_delete_dimmed.png", QSize(), QIcon::Disabled);
    ui->btn_delete->setIcon(icon_delete);
    QIcon icon_save(QIcon(ClassicPrintSettings::config_dir() + "/icons/notes_save.png"));
    icon_save.addFile(ClassicPrintSettings::config_dir() + "/icons/notes_save_dimmed.png", QSize(), QIcon::Disabled);
    ui->btn_save->setIcon(icon_save);

    m_cp = cp;

    m_updating = true;

    // Setup the controls to reflect the current settings
	ui->slider_radius->setValue(m_lens->radius());
	ui->slider_darkness->setValue(m_lens->darkness());
	ui->slider_dodge->setValue(m_lens->dodge());
	ui->check_defocus->setCheckState(m_lens->defocus() ? Qt::Checked : Qt::Unchecked);

    ui->btn_save->setEnabled(false);
    // Populate the combobox with the available lens list
    int index = 0;
    ClassicPrintLens* lens;
    QString name;
    ui->combo_name->clear();
    while (m_cp->getLens(index++, name, &lens)) {
        ui->combo_name->addItem(name);
    }
    // If there is more than one left then enable the delete button
    if (ui->combo_name->count() > 1) {
        ui->btn_delete->setEnabled(true);
    }
    else {
        ui->btn_delete->setEnabled(false);
    }
	// If the current item has been modified then ensure it has an entry
	int item = ui->combo_name->findText(m_lens->name());
	if (item >= 0) {
		ui->combo_name->setCurrentIndex(item);
	}
	else {
		ui->combo_name->addItem(m_lens->name());
		item = ui->combo_name->findText(m_lens->name());
		if (item >= 0) {
			ui->combo_name->setCurrentIndex(item);
			ui->btn_save->setEnabled(true);
		}
	}
    m_updating = false;
}

LensConfiguration::~LensConfiguration()
{
    delete ui;
	delete m_lens;
}

void LensConfiguration::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void LensConfiguration::on_slider_radius_valueChanged(int value)
{
    if (!m_updating) {
		m_lens->setRadius(value);
        setCustom();
    }
}

void LensConfiguration::on_slider_darkness_valueChanged(int value)
{
    if (!m_updating) {
		m_lens->setDarkness(value);
        setCustom();
    }
}

void LensConfiguration::on_slider_dodge_valueChanged(int value)
{
    if (!m_updating) {
		m_lens->setDodge(value);
        setCustom();
    }
}

void LensConfiguration::on_check_defocus_clicked(bool checked)
{
    if (!m_updating) {
		m_lens->setDefocus(checked);
        setCustom();
    }
}

void LensConfiguration::setCustom() {
    // See if the custom value is already in the combobox
    if (ui->combo_name->findText("[Custom]") < 0) {
        // No. Add it in
        ui->combo_name->addItem("[Custom]");
        // Make sure it is selected
        ui->combo_name->setCurrentIndex(ui->combo_name->findText("[Custom]"));
        // Make sure the current item has the custom name
		m_lens->setName("[Custom]");
        ui->btn_delete->setEnabled(false);
        ui->btn_save->setEnabled(true);
    }
}

void LensConfiguration::on_combo_name_activated(QString name)
{
	int index = 0;
	ClassicPrintLens* lens = NULL;
	QString lens_name;

    m_updating = true;
    ui->btn_save->setEnabled(false);

	// Find the lens with the given name
	while (m_cp->getLens(index++, lens_name, &lens)) {
		if (lens_name == name) {
			*m_lens = *lens;
			break;
		}
	}

    // Reset the controls
	ui->slider_radius->setValue(m_lens->radius());
	ui->slider_darkness->setValue(m_lens->darkness());
	ui->slider_dodge->setValue(m_lens->dodge());
	ui->check_defocus->setCheckState(m_lens->defocus() ? Qt::Checked : Qt::Unchecked);
    // Remove the custom field from the combobox
    int item = ui->combo_name->findText("[Custom]");
    if (item >= 0) {
        ui->combo_name->removeItem(item);
    }
    // If there is more than one item left then enable the delete button
    if (ui->combo_name->count() > 1) {
        ui->btn_delete->setEnabled(true);
    }
    else {
        ui->btn_delete->setEnabled(false);
    }
    m_updating = false;
}

void LensConfiguration::on_btn_delete_clicked()
{
    int item = ui->combo_name->currentIndex();
    if (item >= 0) {
        QString name;
        ClassicPrintLens* lens;

        m_cp->deleteLens(ui->combo_name->currentText());
        ui->combo_name->removeItem(item);
        // This should always work because the button would only be
        // enabled if there was more than one item
        m_cp->getLens(0, name, &lens);
        item = ui->combo_name->findText(name);
        if (item != -1) {
            ui->combo_name->setCurrentIndex(item);
        }
    }
}

void LensConfiguration::on_btn_save_clicked()
{
    EnterNameDialog enter_name(this);
    enter_name.setName("");
	if (enter_name.exec() != QDialog::Accepted) {
		return;
	}
    if (enter_name.name().length() > 0) {
        // Add the new lens
		m_lens->setName(enter_name.name());
        ClassicPrintLens* lens = new ClassicPrintLens();
		*lens = *m_lens;
        m_cp->addLens(lens);
        // Repopulate the combobox
        m_updating = true;
        int index = 0;
        QString name;
        ui->combo_name->clear();
        while (m_cp->getLens(index++, name, &lens)) {
            ui->combo_name->addItem(name);
        }
        // If there is more than one left then enable the delete button
        if (ui->combo_name->count() > 1) {
            ui->btn_delete->setEnabled(true);
        }
        else {
            ui->btn_delete->setEnabled(false);
        }
        // If the current item has been modified then ensure it has an entry
		int item = ui->combo_name->findText(m_lens->name());
        if (item >= 0) {
            ui->combo_name->setCurrentIndex(item);
        }
        ui->btn_save->setEnabled(false);
        m_updating = false;
    }
}

void LensConfiguration::on_buttonBox_accepted()
{
	// Apply our local lens settings to the current settings
	if (m_cp->getCurrentLens()) {
		*m_cp->getCurrentLens() = *m_lens;
	}
	accept();
}
