#ifndef DAEMON_H
#define DAEMON_H

#include <QObject>
#include <QDBusConnection>
#include <QDBusInterface>
#include <QDBusMessage>
#include <QFile>
#include <QFileSystemWatcher>
#include <QSettings>
#include <QList>
#include <QString>
#include <QTextStream>
#include <QTimer>

#define BUS_NAME "com.nokia.csd.Call"
#define BUS_PATH "/com/nokia/csd/call"
#define INSTANCE_INTERFACE "com.nokia.csd.Call.Instance"
#define DEFAULT_WHITELIST "/home/user/MyDocs/whitelist.txt"
#define DEFAULT_BLACKLIST "/home/user/MyDocs/blacklist.txt"

class CallerXDaemon : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.callerx.ifdbus")

public:

    explicit CallerXDaemon(QObject *parent = 0);
    ~CallerXDaemon();

    void Start();

signals:
    void quit();

public slots:
    Q_SCRIPTABLE void reload();
    Q_SCRIPTABLE void stop();
    Q_SCRIPTABLE void loadwhitelist();
    Q_SCRIPTABLE void loadblacklist();
    Q_SCRIPTABLE void addrecentnumber();

private slots:
    void initialize();
    void callScreen(const QDBusObjectPath&, const QString&);
    void callRelease(const QString&);
    void loadlist();
    void updatelist();
    void setloadlist(const QString&, bool m);
    void addtolist(const QString&);
    bool isBlocked(const QString&);

private:
    QFileSystemWatcher* fileWatcher;
    QList<QString> nlist;
    QString listPath, whitelistpath, blacklistpath, n, callPath;
    bool whitelistmode, activetimer;
    QSettings settings;
};
#endif // DAEMON_H
