#ifndef GC_PARSER_H
#define GC_PARSER_H

#include <QList>

#include "json.h"
#include "cacheprovider.h"
#include "gcbrowser.h"

class GcParser : public QObject {
  Q_OBJECT;
  
 public:
  GcParser();
  ~GcParser();

  bool decodeOverview(const QString &data, QMap<QString, GcBrowser::OverviewEntry> &, int, int);
  bool decodeInfo(const QString&, Cache &);
  QString error() const;

 private:
  QString m_error;

  QString subString(QString &, const QString &, const QString &);

  // json decoder
  bool decodeJson(const QString&, QMap<QString, QVariant> &);

  // info specific content decoders
  bool parseStatus(const QMap<QString, QVariant> &);
  bool parseInfoEntry(const QMap<QString, QVariant> &, Cache &);

  // generic content decoders
  bool parseFloat(const QMap<QString, QVariant> &, const QString &, qreal &);
  bool parseString(const QMap<QString, QVariant> &, const QString &, QString &);
  bool parseInt(const QMap<QString, QVariant> &, const QString &, int &);
  bool parseBool(const QMap<QString, QVariant> &, const QString &, bool &);
  bool parseType(const QMap<QString, QVariant> &, const QString &, Cache::Type &);
  bool parseList(const QMap<QString, QVariant> &, const QString &, QList<QVariant> &);
  bool parseMap(const QMap<QString, QVariant> &, const QString &, QMap<QString, QVariant> &);
  bool parseRating(const QMap<QString, QVariant> &, const QString &, Rating &);
  bool parseContainer(const QMap<QString, QVariant> &, const QString &, Container &);
  bool parseOwner(const QMap<QString, QVariant> &, const QString &, QString &);
  bool parseDate(const QMap<QString, QVariant> &, const QString &, QDate &);
};

#endif // GC_PARSER_H
