#ifndef GCBROWSER_H
#define GCBROWSER_H

#include <QObject>
#include <QNetworkReply>

#include "cachelist.h"
#include "cacheproviderplugin.h"

class GcBrowser : public QObject, public CacheProviderPlugin {
 Q_OBJECT
 Q_INTERFACES(CacheProviderPlugin)
    
 enum CurrentRequest { None, Overview, Info, Detail };

public:
  class OverviewEntry {
  public:
    float x, y;
    int c;
    QString n;
  };

  GcBrowser();
  ~GcBrowser();

  QString name();
  QString license();
  bool canBeDefault();
  QObject *object();

  void init(QWidget * = 0);
  void createConfig(QDialog *, QVBoxLayout*);

  bool busy();
  void processRequestOverview(const QGeoBoundingBox &, const int, const int);
  void processRequestInfo(const QString &);
  void processRequestDetail(const QString &);

 private slots:
  void replyFinished(QNetworkReply*);
  void applyChanges();

 signals:
  void replyOverview(const CacheList &);
  void replyInfo(const Cache &);
  void replyDetail(const Cache &);
  void replyError(const QString &);    // any request can emit a error
  void reload();
  void notifyBusy(bool);
  void done();
  void next();

 private:
  QMap<QString, OverviewEntry> m_overviewMap;

  void login(const QString &, const QString &);
  void requestNextTile();
  bool overviewDone();

  enum State { SentLoginGET, SentLoginPOST, RequestedUserToken, Idle, ProcessingOverview };

  void requestUserToken();
  QString subString(const QString &, const QString &, const QString &);
  bool decodeUserToken(const QString&);
  void prepareLogin();
  void doLogin();
  void handleViewStateField(const QString&);
  bool loginIsValid();
  void error(const QString &);
  QString getCacheGuid(const QString &);

  QNetworkAccessManager *m_manager;
  QString m_userToken;
  bool m_initialized;
  CacheList m_cacheList;
  Cache m_cache;
  QString m_lastViewState;
  State m_state;
  int m_flags;

  QString m_name, m_password;
  CurrentRequest m_currentRequest;
  QString m_posted;

  int m_tile_x_min, m_tile_x_max, m_tile_x_cur;
  int m_tile_y_min, m_tile_y_max, m_tile_y_cur;
  int m_tile_zoom;
  bool m_tile_is_image;

  // we save the list of waypoints for last detail request since the
  // overview request may not return them
  QString m_lastWaypointsName;
  QList<Waypoint> m_lastWaypoints;
  bool m_pendingReload;

  // keep internal list to reduce number of net requests
  QGeoBoundingBox m_cacheBox;
};

#endif // GCBROWSER_H
