/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 1.0
import "content"

Rectangle {
    id: window
    width: 800; height: 480

    property string currentFeed: "intranet.blundells.org/feeds/Default.aspx"
    property bool loading: feedModel.status == XmlListModel.Loading

    RssFeeds { id: rssFeeds }

    XmlListModel {
        id: feedModel
        source: "http://" + window.currentFeed
        query: "/rss/channel/item"

        XmlRole { name: "title"; query: "title/string()" }
        XmlRole { name: "link"; query: "link/string()" }
        XmlRole { name: "description"; query: "description/string()"}
        XmlRole { name: "category"; query: "category/string()"}
    }

    Row {
        Rectangle {
            width: 180; height: window.height
            color: "#4a4a4a"

            ListView {
                focus: true
                id: categories
                anchors.fill: parent
                model: rssFeeds
                header: shieldsDelegate
                delegate: CategoryDelegate {}
                highlight: Rectangle {
                    gradient{
                        Gradient {
                            GradientStop { position: 0; color: "#aaaaaa" }
                            GradientStop { position: 0.5; color: "#4a4a4a" }
                            GradientStop { position: 1; color: "#aaaaaa" }
                        }
                    }
                }
                highlightMoveSpeed: 300
            }
            ScrollBar {
                scrollArea: categories; height: categories.height; width: 8
                anchors.right: categories.right
            }
        }
        Rectangle {
            width: window.width - 180; height: window.height
            color: "black"

            ListView {
                id: list
                width: window.width - 180; height: window.height
                model: feedModel
                header: nodataDelegate
                delegate: NewsDelegate {}

            }
        }
    }

    Component {
        id: nodataDelegate

        Item {

            width: list.width; height: 0
            visible: {
                if (list.count < 1)
                    return true
                else
                    return false
            }

            Text {
                id: nodataText
                width: parent.width; height: parent.height;

                text: "No data at this time."
                color: "white"
                wrapMode: Text.WordWrap
                anchors{
                    top: parent.top; topMargin: 200; left:parent.left; leftMargin:list.width*0.3; right:parent.right; rightMargin:list.width*0.1
                }
                font { bold: true; family: "Helvetica";
                    pointSize: 24
                }
            }
        }
    }


    Component {
        id: shieldsDelegate
        Item {
            width: categories.width; height: 60
            Image {
                id: prepshieldcontainer
                property bool on: true

                source: "content/images/prep-shield.png"; visible: prepshieldcontainer.on
                anchors {
                    left: parent.left; leftMargin: 15
                    verticalCenter: parent.verticalCenter
                }
                MouseArea {
                    anchors.fill: parent
                    onClicked: Qt.openUrlExternally ("http://www.blundells.org/prep/default.htm");
                }
            }
            Image {
                id: seniorshieldcontainer
                property bool on: true

                source: "content/images/senior-shield.png"; visible: seniorshieldcontainer.on
                anchors {
                    right: parent.right; rightMargin: 15
                    verticalCenter: parent.verticalCenter
                }
                MouseArea {
                    anchors.fill: parent
                    onClicked: Qt.openUrlExternally ("http://www.blundells.org/admin/blundells.htm");
                }
            }
            Rectangle {
                width: parent.width; height: 1; color: "#aaaaaa"
                anchors.bottom: parent.bottom
                visible: true
            }
        }
    }

    ScrollBar { scrollArea: list; height: list.height; width: 8; anchors.right: window.right }
    Rectangle { x: 180; height: window.height; width: 1; color: "#cccccc" }
}
