/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UNIXTIMEWIDGET_H
#define UNIXTIMEWIDGET_H

#include <QSize>
#include <QVBoxLayout>

#include "clockwidget.h"
#include "horizontalbinarydisplaywidget.h"

class UnixTimeWidget : public ClockWidget
{
    Q_OBJECT

public:
    explicit UnixTimeWidget(QWidget *parent = 0);
    ~UnixTimeWidget();

    QSize sizeHint();

protected slots:
    void updateTime();

private:
    QVBoxLayout *layout;

    HorizontalBinaryDisplayWidget *firstByte;
    HorizontalBinaryDisplayWidget *secondByte;
    HorizontalBinaryDisplayWidget *thirdByte;
    HorizontalBinaryDisplayWidget *fourthByte;
};

#endif // UNIXTIMEWIDGET_H
