/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CALLMONITOR_H
#define CALLMONITOR_H

#include <QObject>
#include <QTimer>
#include "settings.h"


// forward class declaration
class QDBusMessage;


/*!
  CallMonitor handles incoming phone calls and the current call status.

  CallMonitor takes or rejects incoming calls, depending on settings. It emits
  start and stop signals as the call status changes, also for outgoing calls.

  It uses the DBus interface with specific messages as needed by Maemo 5. Since
  this DBus interface is only unofficially documented it may be subject to
  change in future releases.
*/
class CallMonitor : public QObject
{
    Q_OBJECT
public:
    explicit CallMonitor(Settings *settings, QObject *parent = 0);

private:
    bool dropCall() const;
    bool takeIncomingCall();

signals:
    void callReceived(const QString droppedPhoneNumber);
    void callStatusChanged(bool newStatus);

private slots:
    void receiveCall(const QDBusMessage&);
    void callStatusUpdate(const QDBusMessage&);
    void callEstablished(const QDBusMessage&);
    void callTimer();


public:
    //! indicates whether any phone call is currently active
    bool itsCallPending;
    //! indication whether a self taken call is pending or shortly before pending
    bool itsTakenCallPending;

private:
    //! reference to global application settings
    Settings* const itsSettings;
    //! timeout to abort outgoing voice calls
    QTimer *itsCallTimer;
    //! indication whether the next call shall be taken
    bool itsTakeNextCall;
};

#endif // CALLMONITOR_H
