/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "settings.h"
#include "ui_settings.h"

#include <QDialog>


// settings
#define COMPANY                         "morawek.at"
#define PRODUCT                         "babyphone"
#define PHONE_NUMBER_KEY                "phoneNumber"
#define PHONE_NUMBER_DEFAULT            ""
#define AUDIO_AMPLIFY_KEY               "audio/volume"
#define AUDIO_AMPLIFY_DEFAULT           27
#define AUDIO_TIMER_KEY                 "audio/timer"
#define AUDIO_TIMER_DEFAULT             4
#define RECALL_TIMER_KEY                "call/recallTimer"
#define RECALL_TIMER_DEFAULT            30
#define REJECT_INCOMING_CALLS_KEY       "call/rejectIncoming"
#define REJECT_INCOMING_CALLS_DEFAULT   true



Settings::Settings(QObject *parent) :
    QSettings(COMPANY, PRODUCT, parent),
    CALL_SETUP_TIMER(30000),    // 30s maximum call setup time
    CALL_HOLD_TIMER(300000),    // 300s maximum call time
    MSG_BOX_TIMEOUT(10000),     // 10s until auto-close of message boxes
    THRESHOLD_VALUE(100),
    VOLUME_COUNTER_MAX(120),    // clipping occurs at this value
    VOLUME_COUNTER_DEC(1),
    GRAPH_MIN_VALUE(0),         // minimum value that is shown
    GRAPH_MAX_VALUE(130),       // maximum value that is shown
    GRAPH_WIDTH(579),           // static value determined by UI design
    GRAPH_HEIGHT(115),          // static value determined by UI design
    AUDIO_SAMPLE_INTERVAL(800),
    AUDIO_SAMPLE_SUBINTERVAL(16),
    AUDIO_ON_TIMER(5000),
    AUDIO_OFF_TIMER(300)
{
    itsAudioAmplify = value(AUDIO_AMPLIFY_KEY, AUDIO_AMPLIFY_DEFAULT).toInt();
    itsAudioTimer = value(AUDIO_TIMER_KEY, AUDIO_TIMER_DEFAULT).toInt();
    itsPhonenumber = value(PHONE_NUMBER_KEY, PHONE_NUMBER_DEFAULT).toString();
    itsRecallTimer = value(RECALL_TIMER_KEY, RECALL_TIMER_DEFAULT).toInt();
    itsRejectIncomingCalls = value(REJECT_INCOMING_CALLS_KEY, REJECT_INCOMING_CALLS_DEFAULT).toBool();
}


void Settings::Save()
{
    setValue(AUDIO_AMPLIFY_KEY, itsAudioAmplify);
    setValue(AUDIO_TIMER_KEY, itsAudioTimer);
    setValue(PHONE_NUMBER_KEY, itsPhonenumber);
    setValue(RECALL_TIMER_KEY, itsRecallTimer);
    setValue(REJECT_INCOMING_CALLS_KEY, itsRejectIncomingCalls);
}


void Settings::ShowDialog()
{
    // setup settings dialog
    Ui::Dialog *ui = new Ui::Dialog();
    QDialog *dialog = new QDialog();
    ui->setupUi(dialog);
    ui->spinBox_volume->setValue(itsAudioAmplify);
    ui->spinBox_timeWeight->setValue(itsAudioTimer);
    ui->spinBox_recallTimer->setValue(itsRecallTimer);
    ui->checkBox_rejectIncomingCalls->setChecked(itsRejectIncomingCalls);

    // show dialog
    if (dialog->exec() == QDialog::Accepted)
    {
        // store new settings
        itsAudioAmplify = ui->spinBox_volume->value();
        itsAudioTimer = ui->spinBox_timeWeight->value();
        itsRecallTimer = ui->spinBox_recallTimer->value();
        itsRejectIncomingCalls = ui->checkBox_rejectIncomingCalls->checkState();
    }

    // clean up
    delete ui;
    delete dialog;
}

