#ifndef CONTROL_H
#define CONTROL_H

#include <QMainWindow>
#include <QMainWindow>
#include <QStandardItemModel>
#include "booklistwidget.h"
#include "readwidget.h"

class QModelIndex;
class QStandardItem;
class AudioBook;

class Control : public QMainWindow
{
    Q_OBJECT

public:

    Control( QWidget* aParent = 0);

    ~Control();

public slots:

    void addBooks();

    void createNewBook();

    void readBook(int aIndex);

    void removeBook(int aIndex);

private slots:

    void loadBookList();

    void storeBookList();

    bool isBookAdded( const QString& aBookName );

    void bookClosed( AudioBook* book);

    void bookPaused(AudioBook* book);

private:

    QStandardItemModel *mBookListModel;
    BookListWidget *mBookListWidget;
    ReadWidget *mReadWidget;
};

#endif // CONTROL_H
