#include "commentitemwidget.h"

CommentItemWidget::CommentItemWidget(MaemoComment *c, QWidget *parent):QWidget (parent)
{
    setStyleSheet("background-color: black;border: none");

    //name
    name = new QLabel (c->getAuthor(),this);
    name->setStyleSheet("color: #F48802;font: 18px;font-family: \"NokiaSans\";");
    name->setFixedSize (name->fontMetrics().width(c->getAuthor()),30);
    name->setGeometry(5,5,name->width(),30);

    //karma
    karma = new QLabel ("| Karma:",this);
    karma->setStyleSheet("color:#858689;font: 18px;font-family: \"NokiaSans\";");
    karma->setFixedSize (200,30);
    karma->setGeometry(name->width()+10,5,200,30);


    //rating
    rating = new RatingLabel (c->getRating().toInt(),this);
    rating->setGeometry(430,0,130,40);
    rating->show();

    //content
    content = new QLabel (c->getContent(),this);
    content->setMaximumWidth(560);
    content->setWordWrap(true);
    content->setStyleSheet("color:white;font: 17px;font-family: \"NokiaSans\";");
    content->setGeometry (5,40,550,content->sizeHint().height());

    QLabel *separator = new QLabel (this);
    separator->setStyleSheet ("background-image: url(:/images/background/separator.png);");
    separator->setFixedSize(550,3);
    separator->setGeometry(5,content->sizeHint().height()+45,550,3);
    setFixedSize (600,content->sizeHint().height()+50);


}
