#ifndef COMMENTINGWIDGET_H
#define COMMENTINGWIDGET_H

#include <QWidget>
#include "RatingLabel.h"
#include "appdownloader-comm/MaemoApplicationHandler.h"
#include "appdownloader-comm/MaemoApplicationDetails.h"

namespace Ui {
    class CommentingWidget;
}

class CommentingWidget : public QWidget {
    Q_OBJECT
public:
    explicit CommentingWidget(MaemoApplicationHandler *handler, QString appName,int w, QWidget *parent = 0);
    ~CommentingWidget();

signals:
    void deleteWidget (int);

public slots:
    void commentResponse (int);


protected:
    void changeEvent(QEvent *e);

private slots:
    void sendComment ();
    void closeWidget();


private:
    Ui::CommentingWidget *ui;
    MaemoApplicationHandler *applicationHandler;
    QString applicationName;
    RatingLabel *ratingLabel;
    int id;
};

#endif // COMMENTINGWIDGET_H
