#include "categorylistwidget.h"
#include <QListWidgetItem>
#include <QSize>

CategoryListWidget::CategoryListWidget(QWidget *parent) : QListWidget (parent)  {

    items = new QList <CategoryItemWidget*>();
    //configure list of categories
    QListWidgetItem *topTen = new QListWidgetItem (this);
    CategoryItemWidget *topTenWidget = new CategoryItemWidget ("Top 10", "Top 10 downloaded applications");
    items->append (topTenWidget);
    setItemWidget (topTen,topTenWidget);
    topTen->setData(MAEMOVERSION,"Maemo5");
    topTen->setData(CATEGORY,"");
    topTen->setData(PAGE,"1");
    topTen->setData(PAGESIZE,"10");
    topTen->setData(SORTING,"down");
    topTen->setData(TITLE,"Top 10 Downloads");
    topTen->setSizeHint (QSize (800,100));

    QListWidgetItem *freshestTen = new QListWidgetItem (this);
    CategoryItemWidget *freshestTenWidget = new CategoryItemWidget ("Freshest 10", "Top 10 latest applications");
    items->append (freshestTenWidget);
    setItemWidget (freshestTen,freshestTenWidget);
    freshestTen->setData(MAEMOVERSION,"Maemo5");
    freshestTen->setData(CATEGORY,"");
    freshestTen->setData(PAGE,"1");
    freshestTen->setData(PAGESIZE,"10");
    freshestTen->setData(SORTING,"new");
    freshestTen->setData(TITLE,"Freshest");
    freshestTen->setSizeHint (QSize (800,100));

    QListWidgetItem *bestTen = new QListWidgetItem (this);
    CategoryItemWidget *bestTenWidget = new CategoryItemWidget ("Best 10", "Top 10 best rated applications");
    items->append (bestTenWidget);
    setItemWidget (bestTen,bestTenWidget);
    bestTen->setData(MAEMOVERSION,"Maemo5");
    bestTen->setData(CATEGORY,"");
    bestTen->setData(PAGE,"1");
    bestTen->setData(PAGESIZE,"10");
    bestTen->setData(SORTING,"high");
    bestTen->setData(TITLE,"Top 10 Rating");
    bestTen->setSizeHint (QSize (800,100));

    QListWidgetItem *desktop = new QListWidgetItem (this);
    CategoryItemWidget *desktopWidget = new CategoryItemWidget ("Desktop", "");
    items->append (desktopWidget);
    setItemWidget (desktop,desktopWidget);
    desktop->setSizeHint (QSize (800,100));
    desktop->setData(MAEMOVERSION,"Maemo5");
    desktop->setData(CATEGORY,"fe94a4d2a75411de9faf73d7e4c5d995d995");
    desktop->setData(PAGE,"1");
    desktop->setData(PAGESIZE,"15");
    desktop->setData(SORTING,"down");
    desktop->setData(TITLE,"Desktop");


    QListWidgetItem *games = new QListWidgetItem (this);
    CategoryItemWidget *gamesWidget = new CategoryItemWidget ("Games", "");
    items->append (gamesWidget);
    setItemWidget (games,gamesWidget);
    games->setSizeHint (QSize (800,100));
    games->setData(MAEMOVERSION,"Maemo5");
    games->setData(CATEGORY,"cbd3f29aa75511dea50b6b332998fac1fac1");
    games->setData(PAGE,"1");
    games->setData(PAGESIZE,"15");
    games->setData(SORTING,"down");
    games->setData(TITLE,"Games");

    QListWidgetItem *multimedia = new QListWidgetItem (this);
    CategoryItemWidget *multimediaWidget = new CategoryItemWidget ("Multimedia", "");
    items->append (multimediaWidget);
    setItemWidget (multimedia,multimediaWidget);
    multimedia->setSizeHint (QSize (800,100));
    multimedia->setData(MAEMOVERSION,"Maemo5");
    multimedia->setData(CATEGORY,"e1266ab0a75511de9a80b5f5ad0d70857085");
    multimedia->setData(PAGE,"1");
    multimedia->setData(PAGESIZE,"15");
    multimedia->setData(SORTING,"down");
    multimedia->setData(TITLE,"Multimedia");

    QListWidgetItem *nav = new QListWidgetItem (this);
    CategoryItemWidget *navWidget = new CategoryItemWidget ("Location & Navigation", "");
    items->append (navWidget);
    setItemWidget (nav,navWidget);
    nav->setSizeHint (QSize (800,100));
    nav->setData(MAEMOVERSION,"Maemo5");
    nav->setData(CATEGORY,"f64736d6a75511deb661fd6d059b6cfa6cfa");
    nav->setData(PAGE,"1");
    nav->setData(PAGESIZE,"15");
    nav->setData(SORTING,"down");
    nav->setData(TITLE,"Location & Navigation");

    QListWidgetItem *graphics = new QListWidgetItem (this);
    CategoryItemWidget *graphicsWidget = new CategoryItemWidget ("Graphics", "");
    items->append (graphicsWidget);
    setItemWidget (graphics,graphicsWidget);
    graphics->setSizeHint (QSize (800,100));
    graphics->setData(MAEMOVERSION,"Maemo5");
    graphics->setData(CATEGORY,"95263bdea74811de8b78fb138dec3c333c33");
    graphics->setData(PAGE,"1");
    graphics->setData(PAGESIZE,"15");
    graphics->setData(SORTING,"down");
    graphics->setData(TITLE,"Graphics");

    QListWidgetItem *internet = new QListWidgetItem (this);
    CategoryItemWidget *internetWidget = new CategoryItemWidget ("Internet & Networking", "");
    items->append (internetWidget);
    setItemWidget (internet,internetWidget);
    internet->setSizeHint (QSize (800,100));
    internet->setData(MAEMOVERSION,"Maemo5");
    internet->setData(CATEGORY,"aed5066ea74811dea4f6b11b7fd004f204f2");
    internet->setData(PAGE,"1");
    internet->setData(PAGESIZE,"15");
    internet->setData(SORTING,"down");
    internet->setData(TITLE,"Internet & Networking");

    QListWidgetItem *system = new QListWidgetItem (this);
    CategoryItemWidget *systemWidget = new CategoryItemWidget ("System", "");
    items->append (systemWidget);
    setItemWidget (system,systemWidget);
    system->setSizeHint (QSize (800,100));
    system->setData(MAEMOVERSION,"Maemo5");
    system->setData(CATEGORY,"71cdfb32a75611de8369a9e58d3f0c370c37");
    system->setData(PAGE,"1");
    system->setData(PAGESIZE,"15");
    system->setData(SORTING,"down");
    system->setData(TITLE,"System");

    QListWidgetItem *util = new QListWidgetItem (this);
    CategoryItemWidget *utilWidget = new CategoryItemWidget ("Utilities", "");
    items->append (utilWidget);
    setItemWidget (util,utilWidget);
    util->setSizeHint (QSize (800,100));
    util->setData(MAEMOVERSION,"Maemo5");
    util->setData(CATEGORY,"2e9375b6a74911de8298bfef9cd654ca54ca");
    util->setData(PAGE,"1");
    util->setData(PAGESIZE,"15");
    util->setData(SORTING,"down");
    util->setData(TITLE,"Utilities");

    QListWidgetItem *office = new QListWidgetItem (this);
    CategoryItemWidget *officeWidget = new CategoryItemWidget ("Office", "");
    items->append (officeWidget);
    setItemWidget (office,officeWidget);
    office->setSizeHint (QSize (800,100));
    office->setData(MAEMOVERSION,"Maemo5");
    office->setData(CATEGORY,"c1dd9ce4a74811de94606d394a0a9bc69bc6");
    office->setData(PAGE,"1");
    office->setData(PAGESIZE,"15");
    office->setData(SORTING,"down");
    office->setData(TITLE,"Office");

    QListWidgetItem *programming = new QListWidgetItem (this);
    CategoryItemWidget *programmingWidget = new CategoryItemWidget ("Programming", "");
    items->append (programmingWidget);
    setItemWidget (programming,programmingWidget);
    programming->setSizeHint (QSize (800,100));
    programming->setData(MAEMOVERSION,"Maemo5");
    programming->setData(CATEGORY,"2086ed3ca74811dea27603f75ad7dbc5dbc5");
    programming->setData(PAGE,"1");
    programming->setData(PAGESIZE,"15");
    programming->setData(SORTING,"down");
    programming->setData(TITLE,"Programming");

    QListWidgetItem *science = new QListWidgetItem (this);
    CategoryItemWidget *scienceWidget = new CategoryItemWidget ("Science", "");
    items->append (scienceWidget);
    setItemWidget (science,scienceWidget);
    science->setSizeHint (QSize (800,100));
    science->setData(MAEMOVERSION,"Maemo5");
    science->setData(CATEGORY,"5b3c45a4a75611de8cd3817b883c9d649d64");
    science->setData(PAGE,"1");
    science->setData(PAGESIZE,"15");
    science->setData(SORTING,"down");
    science->setData(TITLE,"Science");

    QListWidgetItem *education = new QListWidgetItem (this);
    CategoryItemWidget *educationWidget = new CategoryItemWidget ("Education", "");
    items->append (educationWidget);
    setItemWidget (education,educationWidget);
    education->setSizeHint (QSize (800,100));
    education->setData(MAEMOVERSION,"Maemo5");
    education->setData(CATEGORY,"b77d2e74a75511deb90073cfaf5347154715");
    education->setData(PAGE,"1");
    education->setData(PAGESIZE,"15");
    education->setData(SORTING,"down");
    education->setData(TITLE,"Education");

    QListWidgetItem *other = new QListWidgetItem (this);
    CategoryItemWidget *otherWidget = new CategoryItemWidget ("Other", "");
    items->append (otherWidget);
    setItemWidget (other,otherWidget);
    other->setSizeHint (QSize (800,100));
    other->setData(MAEMOVERSION,"Maemo5");
    other->setData(CATEGORY,"47b9b53ca74911de8f7f2940d8a6574a574a");
    other->setData(PAGE,"1");
    other->setData(PAGESIZE,"15");
    other->setData(SORTING,"down");
    other->setData(TITLE,"Other");


    this->setFixedSize (800,372);
    setHorizontalScrollBarPolicy (Qt::ScrollBarAlwaysOff);

}

CategoryListWidget::~CategoryListWidget() {}
