#include "categoryitemwidget.h"

CategoryItemWidget::CategoryItemWidget(QString title,QString subtitle, QWidget *parent) : QWidget (parent) {

    backgroundFrame = new QFrame (this);
    backgroundFrame->setStyleSheet ("background-image: url(:/images/background/init_list.png); border:none;");
    backgroundFrame->setFixedSize (800,100);


    titleLabel = new QLabel (this);
    titleLabel->setStyleSheet ("color: #F48802; font-size:22px;font-family: \"NokiaSans\";");
    titleLabel->setText(title);
    titleLabel->setGeometry (205,0,300,50);

    subtitleLabel = new QLabel (this);
    subtitleLabel->setStyleSheet ("color: #858689; font-family: \"NokiaSans\";font-size: 18px;");
    subtitleLabel->setText(subtitle);
    subtitleLabel->setGeometry (205,50,300,40);

    iconLabel = new QLabel (this);
    iconLabel->setGeometry (0,0,200,100);

    setFixedSize (800,100);
}

CategoryItemWidget::~CategoryItemWidget() {
    delete titleLabel;
    delete subtitleLabel;
    delete iconLabel;
}

void CategoryItemWidget::setIcon(QPixmap i) {
    iconLabel->setPixmap(i);
}
