#include "applicationdetailswidget.h"
#include "ui_applicationdetailswidget.h"
#include "RatingLabel.h"
#include <QListWidgetItem>
#include <QSize>
#include <QUrl>
#include <QDebug>
#include <QDesktopServices>

ApplicationDetailsWidget::ApplicationDetailsWidget(MaemoApplicationDetails *app, MaemoApplicationHandler* handler,QWidget *parent) :
    QWidget(parent),
    m_ui(new Ui::ApplicationDetailsWidget)
{
    qDebug() << "comments-widget";
    QFrame *background = new QFrame (this);
    background->setStyleSheet ("background-color:black;");
    background->setGeometry (0,0,800,372);
    m_ui->setupUi(this);

    screenshotPosition = 0;
    application = app;
    applicationHandler = handler;
    //statusBarFrame
    m_ui->statusBarFrame->setStyleSheet ("background-image: url(:/images/background/bar.png);");
    m_ui->bugButton->setStyleSheet (":flat{color: white; background-image: url(); background-color: none; border: none;font-family: \"NokiaSans\";}");
    m_ui->commentsButton->setStyleSheet (":flat{color: white; background-image: url(); background-color: none; border: none;font-family: \"NokiaSans\";}");
    m_ui->installButton->setText ("Install");
    m_ui->installButton->setStyleSheet (":flat{color: white; font: 20px; background-image: url(:/images/background/install_bar.png); border: none;font-family: \"NokiaSans\";}");

    //detailsWidget
    m_ui->scrollArea->setProperty("FingerScrollBars", true);
    m_ui->scrollArea->setProperty("FingerScrollable", true);
    m_ui->scrollArea->setHorizontalScrollBarPolicy (Qt::ScrollBarAlwaysOff);

    QLabel *descriptionTitle = new QLabel(" Description:",m_ui->detailsWidget);
    descriptionTitle->setStyleSheet("color:#858689; font: 18px;font-family: \"NokiaSans\";");
    descriptionTitle->setGeometry(205,-1,200,30);
    QLabel *description = new QLabel (m_ui->detailsWidget);
    description->setMaximumWidth(560);
    description->setText (" "+application->getDescription());
    description->setAlignment (Qt::AlignJustify);
    description->setStyleSheet( "color:white; font: 18px;font-family: \"NokiaSans\";");
    description->setWordWrap(true);
    int height = description->sizeHint().height();
    description->setGeometry(205,40,590,height);
    QLabel *changesTitle = new QLabel ("Changes",m_ui->detailsWidget);
    changesTitle->setStyleSheet("color:#858689; font: 18px;font-family: \"NokiaSans\";");
    changesTitle->setGeometry(210,height+90,100,20);
    QLabel *changes = new QLabel (" Placeholder for changes - not implemented yet",m_ui->detailsWidget);
    changes->setMaximumWidth(590);
    changes->setAlignment (Qt::AlignJustify);
    changes->setStyleSheet( "color:white; font: 18px;font-family: \"NokiaSans\";");
    changes->setWordWrap(true);
    int heightC = changes->sizeHint().height();
    changes->setGeometry(205,height+110,590,heightC);
    int totalHeight = height+heightC+110;

    qDebug () << "labels in place";

    QLabel *downloadsTitle = new QLabel (" Downloads:",m_ui->detailsWidget);
    downloadsTitle->setStyleSheet("color:#858689; font: 18px;");
    QLabel *downloads = new QLabel (application->getDownloads(),m_ui->detailsWidget);
    downloads->setStyleSheet("color:white; font: 18px;");

    // qlist for screenshots
    int p;
    int screenshotsHeight = 0;
    QList <QString> *screenshots = application->getScreenShots ();
    connect (applicationHandler, SIGNAL(imageReady (QPixmap*,QString,QString)),this,SLOT(addScreenshot(QPixmap*,QString,QString)));
    for (p = 0; p < screenshots->length(); p++) {
        if (screenshots->at(p).contains("thumbnail") && !screenshots->at(p).contains("frontpage")) {
            applicationHandler->requestImage(screenshots->at(p),"","DETAILS",true);
            screenshotsHeight +=120;
        }
    }
    qDebug () << "screenshots loaded";
    if (totalHeight+50 < screenshotsHeight) {
        totalHeight = screenshotsHeight-50;
    }
    if (totalHeight<340) {
        downloadsTitle->setGeometry(205,340,110,20);
        downloads->setGeometry(320,340,115,20);
        RatingLabel *rating = new RatingLabel (application->getRating().left(1).toInt(),m_ui->detailsWidget);
        rating->setGeometry (640,320,130,40);
        m_ui->detailsWidget->setFixedSize (770,365);
    }
    else {
        downloadsTitle->setGeometry(205,totalHeight+20,110,20);
        downloads->setGeometry(320,totalHeight+20,100,20);
        RatingLabel *rating = new RatingLabel (application->getRating().left(1).toInt(),m_ui->detailsWidget);
        rating->setGeometry (640,totalHeight,130,40);
        m_ui->detailsWidget->setFixedSize (770,totalHeight+50);
        //m_ui->backgroundFrame->setFixedSize (790,totalHeight+50);
    }
    qDebug()<<"UI set";
    if(!application->getUnparsedComments().isEmpty()) {
        qDebug ()<<"unparsedComments";
        connect (applicationHandler, SIGNAL (commentsParsed(QList<MaemoComment*>*)), application, SLOT(setCommentsList(QList<MaemoComment*>*)));
        applicationHandler->parseCommentsOnly (application->getUnparsedComments());
    }
    qDebug()<<"finished";
}



ApplicationDetailsWidget::~ApplicationDetailsWidget()
{
    delete m_ui;
}

void ApplicationDetailsWidget::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void ApplicationDetailsWidget::reportBug() {
    qDebug()<<application->getBugUrl();
    qDebug()<<"applicationDetailsWidget::reportBug()";
    if (!application->getBugUrl().isEmpty()) {
        qDebug()<<QDesktopServices::openUrl(QUrl(application->getBugUrl()));
    }
}


void ApplicationDetailsWidget::installApplication () {
    applicationHandler->proceedInstallFileResponse(application->getInstallFileContent().toAscii(),0);
}

void ApplicationDetailsWidget::openComments() {
    ApplicationCommentsWidget *appComments = new ApplicationCommentsWidget (this->application,this->applicationHandler,this->parentWidget());
    appComments->setGeometry (0,54,800,426);
    emit layerAdded(appComments,this->application->getTitle(),"Comments");
    appComments->show();
    connect (appComments, SIGNAL (layerAdded(QWidget*,QString,QString)),this,SLOT(widgetLayerAdded(QWidget*,QString,QString)));
    appComments->loadAllComments();
}


void ApplicationDetailsWidget::addScreenshot (QPixmap *screenshot,QString id,QString type) {
    QTextStream out (stdout);
    out << "screenshot received" << endl;
    if (!screenshot->isNull()&&type=="DETAILS") {
        QLabel *item = new QLabel (m_ui->detailsWidget);
        item->setFixedSize(QSize(190,114));
        item->setPixmap(screenshot->scaled(190,114));
        item->setGeometry (0,screenshotPosition,190,114);
        screenshotPosition += 120;
        item->show();
    }
}

void ApplicationDetailsWidget::widgetLayerAdded(QWidget*w,QString bc_1,QString bc_2) {
    emit layerAdded (w,bc_1,bc_2);
}
