# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import imports.EXIF


def GetExifRotation(self,  fileLoc):
        try:
            if not self.core.EXIFLoaded:
                p = open(fileLoc, "rb")
                tags = imports.EXIF.process_file(p)
                
                for key in tags.keys():
                    try:
                        newItem = str("%s: %s" %(key, tags[key]))
                        
                        if key == "Image Orientation":
                            if newItem == 'Image Orientation: Horizontal (normal)':
                                return 0
                            elif newItem == 'Image Orientation: Rotated 90 CW':
                                return  90
                            elif newItem == 'Image Orientation: Rotated 90 CCW':    
                                return  270
                            else:
                                return  180
                    except:
                        continue
        except:
            print "GetExifRotation"
            return


def ImageExifLoad(self):
    if not self.core.EXIFLoaded:
        self.core.EXIFLoaded = True
        self.listEXIFData.clear()
        p = open(self.core.curImageLoc, "rb")
        tags = imports.EXIF.process_file(p)
        self.core.GPSLat = 0
        self.core.GPSLonRef = 1
        self.core.GPSLatRef = 1
        self.core.GPSLon = 0
        
        for key in tags.keys():
            try:
                newItem = str("%s: %s" %(key, tags[key]))
                
                if key == "Image Orientation":
                    if newItem == 'Image Orientation: Horizontal (normal)':
                        self.core.valOrient = 0
                    elif newItem == 'Image Orientation: Rotated 90 CW':
                        self.core.valOrient = 1
                    elif newItem == 'Image Orientation: Rotated 90 CCW':    
                        self.core.valOrient = -1
                    else:
                        self.core.valOrient = 1
                
                ##Decimal Degrees = Degrees + minutes/60 + seconds/3600
                if key == "GPS GPSLatitude":
                    ##GPS GPSLatitude: [44, 19, 26]
                    la= newItem.replace("GPS GPSLatitude: ", "")
                    self.core.GPSLat =int(la.strip('[]').split(',')[0].strip()) +int(la.strip('[]').split(',')[1].strip())/60.0 +int(la.strip('[]').split(',')[2].strip())/3600.0

                if key == "GPS GPSLatitudeRef":
                    ##GPS GPSLatitudeRef: N
                    if newItem =="GPS GPSLatitudeRef: N":
                        self.core.GPSLonRef =1
                    else:
                        self.core.GPSLonRef =-1
                        
                if key == "GPS GPSLongitude":
                    lo=newItem.replace("GPS GPSLongitude: ", "")
                    ##GPS GPSLongitude: [73, 0, 58]
                    self.core.GPSLon=int(lo.strip('[]').split(',')[0].strip()) +int(lo.strip('[]').split(',')[1].strip())/60.0 +int(lo.strip('[]').split(',')[2].strip())/3600.0

                if key == "GPS GPSLongitudeRef":
                    ##GPS GPSLongitudeRef: W
                    if newItem =="GPS GPSLongitudeRef: E":
                        self.core.GPSLonRef =1
                    else:
                        self.core.GPSLonRef =-1                    

                if (newItem !="" and  newItem.startswith("Maker Note") == False  and  newItem.startswith("MakerNote") == False  and  newItem.startswith("EXIF") == False):
                    self.listEXIFData.addItem(newItem)
                    #self.listView
            except Exception, e:
                continue


