# -*- coding: utf-8 -*-
'''
Advanced Power
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import os.path, gtk

class Theme():

  __themes_path = '/usr/share/advanced-power/themes'
  __icons_system_themes_path = '/usr/share/icons'
  __sounds_system_themes_path = '/usr/share/sounds'

  def __init__(self, use_gtk_theme=False, c_theme=None):

    self.__sounds = {}
    self.__images = {}
    self.__c_images = ''
    self.__c_images_index = 'verylow'
    self.__button_state = '0%'
    self.__theme = ''
    self.__gtk_settings = gtk.settings_get_default()
    self.__gtk_icon_theme = str(self.__gtk_settings.get_property('gtk-icon-theme-name'))
    self.__use_gtk_theme = use_gtk_theme
    self.load(theme=c_theme)

  def load(self, param=None, theme=None):
    if self.__use_gtk_theme:
      return self.__set_gtk_icon_theme(str(self.__gtk_icon_theme))
    else:
      return self.__set_custom_icon_theme(theme)

  def set_use_gtk_theme(self, use_gtk_theme):
    self.__use_gtk_theme = use_gtk_theme

  def get_button_image(self, state, verylow_level=5):
    if state == 'full':
      self.__c_images_index = '100'
    elif state == 'charging':
      self.__c_images_index = 'charging'
    elif state == 'charger_disconn':
      pass
    else:
      self.__c_images_index = '100'
      percent = float(state.rsplit('%')[0])
      if percent <= verylow_level:
        self.__c_images_index = 'verylow'
      elif percent < 12.5:
        self.__c_images_index = 'low'
      elif percent < 37.5:
        self.__c_images_index = '25'
      elif percent < 62.5:
        self.__c_images_index = '50'
      elif percent < 87.5:
        self.__c_images_index = '75'
    self.__button_state = state
    return self.update_button_image()

  def get_image_object(self, image):
    return gtk.image_new_from_file(image)

  def get_current_image_object(self):
    return self.update_button_image()

  def gtk_theme_changed(self):
    if not self.__gtk_icon_theme == str(self.__gtk_settings.get_property('gtk-icon-theme-name')):
      self.__gtk_icon_theme = str(self.__gtk_settings.get_property('gtk-icon-theme-name'))
      if self.__use_gtk_theme:
        return self.__set_gtk_icon_theme(self.__gtk_icon_theme)

  def __set_gtk_icon_theme(self, path='hicolor'):
    images_path = '%s/%s/40x40/hildon/' % (self.__icons_system_themes_path, path)
    if not os.path.isdir(images_path):
      images_path = '%s/hicolor/40x40/hildon/' % self.__icons_system_themes_path
    self.__images = {'verylow': '%sqgn_stat_battery_verylow.png' % images_path,
                     'low': '%sqgn_stat_battery_low.png' % images_path,
                     '25': '%sqgn_stat_battery_full25.png' % images_path,
                     '50': '%sqgn_stat_battery_full50.png' % images_path,
                     '75': '%sqgn_stat_battery_full75.png' % images_path,
                     '100': '%sqgn_stat_battery_full100.png' % images_path,
                     'charging': '%sqgn_indi_batterycharging_a.ani' % images_path}
    self.__sounds = {'verylow': '%s/ui-recharge_battery.wav' % self.__sounds_system_themes_path,
                     'low': '%s/ui-battery_low.wav' % self.__sounds_system_themes_path,
                     'charging': '%s/ui-charging_started.wav' % self.__sounds_system_themes_path}
    return self.update_button_image()

  def __set_custom_icon_theme(self, path='Default'):
    themes_path = '%s/%s/' % (self.__themes_path, path)
    if not os.path.isdir(themes_path):
      return self.__set_custom_icon_theme(self.__theme)
    else:
      self.__theme = path
    images_path = '%simages/' % themes_path
    sounds_path = '%ssounds/' % themes_path
    self.__images = {'verylow': '%sbattery_verylow.png' % images_path,
                   'low': '%sbattery_low.png' % images_path,
                   '25': '%sbattery_25.png' % images_path,
                   '50': '%sbattery_50.png' % images_path,
                   '75': '%sbattery_75.png' % images_path,
                   '100': '%sbattery_100.png' % images_path,
                   'charging': '%sbattery_charging.png' % images_path}
    self.__sounds = {'verylow': '%sbattery_verylow.wav' % sounds_path,
                   'low': '%sbattery_low.wav' % sounds_path,
                   'charging': '%sbattery_charging.wav' % sounds_path}
    return self.update_button_image()

  def update_button_image(self):
    self.__c_images = self.__images[self.__c_images_index]
    return self.get_image_object(self.__c_images)

  def get_image(self, key):
    try:
      return self.__images[key]
    except:
      return ''

  def get_sound(self, key):
    try:
      return self.__sounds[key]
    except:
      return ''

  def get_themes_path(self):
    return self.__themes_path