# -*- coding: utf-8 -*-
'''
Advanced Power UI Util
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk, hildon
from apcommon.util.locale import Locale

class ComboBox():

  @staticmethod
  def create_key_based(iterable=None, current_item=None):
    liststore = gtk.ListStore(str, str)
    combobox = gtk.ComboBox(liststore)
    cell = gtk.CellRendererText()
    combobox.pack_start(cell, True)
    combobox.add_attribute(cell, 'text', 1)
    if iterable:
      selected_index = 0
      selected = False
      for current_source in iterable:
        if current_item and not selected and str(current_source) == current_item:
          selected_index = len(liststore)
          selected = True
        ComboBox.add_value_key_based(liststore, current_source)
      combobox.set_active(selected_index)
    return combobox, liststore

  @staticmethod
  def set_value_key_based(liststore, c_iter, c_value):
    c_value = str(c_value)
    liststore.set(c_iter, 0, c_value, 1, Locale.get_item(c_value))

  @staticmethod
  def add_value_key_based(liststore, c_value):
    c_value = str(c_value)
    liststore.append([c_value, Locale.get_item(c_value)])

class ListView():

  @staticmethod
  def listview_with_buttons_add_buttons(view, additional_buttons=[]):
    button_up = gtk.Button()
    button_up.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_up.png'))
    button_down = gtk.Button()
    button_down.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_down.png'))
    buttons_to_switch = []
    sensitive = len(view.get_model()) != 0
    for button_text in additional_buttons:
      button = gtk.Button(stock=button_text, use_underline=False)
      buttons_to_switch.append(button)
      button.set_sensitive(sensitive)
    button_up.set_sensitive(sensitive)
    button_down.set_sensitive(sensitive)

    view.connect('cursor-changed', ListView.listview_with_buttons_cursor_changed_cb, button_up, button_down)
    view.connect('drag-data-received', ListView.listview_with_buttons_drag_data_received_cb, button_up, button_down)
    liststore = view.get_model()
    liststore.connect('row-deleted', ListView.listview_with_buttons_row_deleted_cb, view, button_up, button_down, buttons_to_switch)
    liststore.connect('row-inserted', ListView.listview_with_buttons_row_inserted_cb, view, button_up, button_down, buttons_to_switch)
    liststore.connect('rows-reordered', ListView.listview_with_buttons_rows_reordered_cb, view, button_up, button_down)
    button_up.connect('clicked', ListView.listview_with_buttons_move_item_up, button_down, view)
    button_down.connect('clicked', ListView.listview_with_buttons_move_item_down, button_up, view)
    return button_up, button_down, buttons_to_switch

  @staticmethod
  def listview_with_buttons_cursor_changed_cb(view, button_up, button_down):
    model, iter = view.get_selection().get_selected()
    if not iter:
      button_up.set_sensitive(False)
      button_down.set_sensitive(False)
      return
    path = model.get_path(iter)
    if path[0] == 0:
      button_up.set_sensitive(False)
      button_down.set_sensitive((path[0]+1) != len(model))
    elif (path[0] + 1) == len(model):
      button_up.set_sensitive(True)
      button_down.set_sensitive(False)
    else:
      button_up.set_sensitive(True)
      button_down.set_sensitive(True)

  @staticmethod
  def listview_with_buttons_move_item_up(button_up, button_down, view):
    ListView.listview_with_buttons_move_item(view, False, button_up, button_down)

  @staticmethod
  def listview_with_buttons_move_item_down(button_down, button_up, view):
    ListView.listview_with_buttons_move_item(view, True, button_up, button_down)

  @staticmethod
  def listview_with_buttons_move_item(view, down, button_up, button_down):
    model, iter = view.get_selection().get_selected()
    if not iter:
      return
    path = model.get_path(iter)
    n_iter = None
    try:
      if down and (path[0] + 1) < len(model):
        n_iter = model.get_iter(path[0] + 1)
      elif not down and path[0] > 0:
        n_iter = model.get_iter(path[0] - 1)
    except:
      pass
    if n_iter:
      model.swap(iter, n_iter)
      view.scroll_to_cell(model.get_path(iter))

  @staticmethod
  def listview_with_buttons_delete_item(view):
    model, iter = view.get_selection().get_selected()
    if not iter:
      return
    path = model.get_path(iter)
    if path[0] > 0 and (path[0] + 1) == len(model):
      path = (path[0] - 1,)
    model.remove(iter)
    view.set_cursor(path)

  @staticmethod
  def listview_with_buttons_drag_data_received_cb(view, drag_context, x, y, selection_data, info, timestamp, button_up, button_down):
    drop_info = view.get_dest_row_at_pos(x, y)
    button_up.set_sensitive(False)
    button_down.set_sensitive(False)

  @staticmethod
  def listview_with_buttons_row_deleted_cb(model, path, view, button_up, button_down, buttons_to_switch = []):
    sensitive = len(model) != 0
    for button in buttons_to_switch:
      button.set_sensitive(sensitive)
    ListView.listview_with_buttons_cursor_changed_cb(view, button_up, button_down)

  @staticmethod
  def listview_with_buttons_row_inserted_cb(model, path, iter, view, button_up, button_down, buttons_to_switch = []):
    view.set_cursor(path)
    sensitive = len(model) != 0
    for button in buttons_to_switch:
      button.set_sensitive(sensitive)
    ListView.listview_with_buttons_cursor_changed_cb(view, button_up, button_down)

  @staticmethod
  def listview_with_buttons_rows_reordered_cb(treemodel, path, iter, new_order, view, button_up, button_down):
    ListView.listview_with_buttons_cursor_changed_cb(view, button_up, button_down)

class TreeView():

  @staticmethod
  def treeview_with_buttons_add_buttons(view, additional_buttons=[]):
    button_up = gtk.Button()
    button_up.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_up.png'))
    button_down = gtk.Button()
    button_down.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_down.png'))
    buttons_to_switch = []
    model, iter = view.get_selection().get_selected()
    sensitive = bool(iter) and model.iter_n_children(model.iter_parent(iter)) != 0
    for button_text in additional_buttons:
      button = gtk.Button(stock=button_text, use_underline=False)
      buttons_to_switch.append(button)
      button.set_sensitive(sensitive)
    button_up.set_sensitive(sensitive)
    button_down.set_sensitive(sensitive)

    view.connect('cursor-changed', TreeView.treeview_with_buttons_cursor_changed_cb, button_up, button_down, buttons_to_switch)
    view.connect('drag-data-received', TreeView.treeview_with_buttons_drag_data_received_cb, button_up, button_down)
    liststore = view.get_model()
    liststore.connect('row-deleted', TreeView.treeview_with_buttons_row_deleted_cb, view, button_up, button_down, buttons_to_switch)
    liststore.connect('row-inserted', TreeView.treeview_with_buttons_row_inserted_cb, view, button_up, button_down, buttons_to_switch)
    liststore.connect('rows-reordered', TreeView.treeview_with_buttons_rows_reordered_cb, view, button_up, button_down, buttons_to_switch)
    button_up.connect('clicked', TreeView.treeview_with_buttons_move_item_up, button_down, view)
    button_down.connect('clicked', TreeView.treeview_with_buttons_move_item_down, button_up, view)
    return button_up, button_down, buttons_to_switch

  @staticmethod
  def treeview_with_buttons_cursor_changed_cb(view, button_up, button_down, buttons_to_switch):
    model, iter = view.get_selection().get_selected()
    if not iter:
      button_up.set_sensitive(False)
      button_down.set_sensitive(False)
      return
    path = model.get_path(iter)
    sensitive = len(path) != 1
    for button in buttons_to_switch:
      button.set_sensitive(sensitive)
    level_len = model.iter_n_children(model.iter_parent(iter))
    if path[-1] == 0:
      button_up.set_sensitive(False)
      button_down.set_sensitive((path[-1]+1) != level_len)
    elif (path[-1] + 1) == level_len:
      button_up.set_sensitive(True)
      button_down.set_sensitive(False)
    else:
      button_up.set_sensitive(True)
      button_down.set_sensitive(True)

  @staticmethod
  def treeview_with_buttons_move_item_up(button_up, button_down, view):
    TreeView.treeview_with_buttons_move_item(view, False, button_up, button_down)

  @staticmethod
  def treeview_with_buttons_move_item_down(button_down, button_up, view):
    TreeView.treeview_with_buttons_move_item(view, True, button_up, button_down)

  @staticmethod
  def treeview_with_buttons_move_item(view, down, button_up, button_down):
    model, iter = view.get_selection().get_selected()
    if not iter:
      return
    path = model.get_path(iter)
    n_iter = None
    try:
      if down and (path[-1] + 1) < model.iter_n_children(model.iter_parent(iter)):
        n_path = list(path[:-1])
        n_path.append(path[-1] + 1)
        n_iter = model.get_iter(tuple(n_path))
      elif not down and path[-1] > 0:
        n_path = list(path[:-1])
        n_path.append(path[-1] - 1)
        n_iter = model.get_iter(tuple(n_path))
    except Exception, e:
      pass
    if n_iter:
      model.swap(iter, n_iter)
      view.scroll_to_cell(model.get_path(iter))

  @staticmethod
  def treeview_with_buttons_delete_item(view):
    model, iter = view.get_selection().get_selected()
    if not iter:
      return
    path = model.get_path(iter)
    if path[-1] > 0 and (path[-1] + 1) == model.iter_n_children(model.iter_parent(iter)):
      n_path = list(path[:-1])
      n_path.append(path[-1] - 1)
      path = tuple(n_path)
    view.set_cursor(model.get_path(model.iter_parent(iter)))
    model.remove(iter)
#    view.set_cursor(path)

  @staticmethod
  def treeview_with_buttons_drag_data_received_cb(view, drag_context, x, y, selection_data, info, timestamp, button_up, button_down):
    drop_info = view.get_dest_row_at_pos(x, y)
    button_up.set_sensitive(False)
    button_down.set_sensitive(False)

  @staticmethod
  def treeview_with_buttons_row_deleted_cb(model, path, view, button_up, button_down, buttons_to_switch = []):
    try:
      iter = model.get_iter(path)
      sensitive =  bool(iter) and model.iter_n_children(model.iter_parent(iter)) != 0
      for button in buttons_to_switch:
        button.set_sensitive(sensitive)
    except:
      pass
    TreeView.treeview_with_buttons_cursor_changed_cb(view, button_up, button_down, buttons_to_switch)

  @staticmethod
  def treeview_with_buttons_row_inserted_cb(model, path, iter, view, button_up, button_down, buttons_to_switch = []):
    view.scroll_to_cell(path)
    view.expand_to_path(path)
    view.set_cursor(path)
    sensitive = model.iter_n_children(model.iter_parent(iter)) != 0
    for button in buttons_to_switch:
      button.set_sensitive(sensitive)
    TreeView.treeview_with_buttons_cursor_changed_cb(view, button_up, button_down, buttons_to_switch)

  @staticmethod
  def treeview_with_buttons_rows_reordered_cb(treemodel, path, iter, new_order, view, button_up, button_down, buttons_to_switch):
    TreeView.treeview_with_buttons_cursor_changed_cb(view, button_up, button_down, buttons_to_switch)
