# -*- coding: utf-8 -*-
from re import sub
import dbus
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.phonon import Phonon
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from youtubeservice import YouTubeDataService
from youtubeconfig import VideoPlaybackSettings, VideoDownloadSettings
from Ui_videoplaybackwindow import Ui_VideoPlaybackWindow

class VideoPlaybackWindow(QMainWindow, Ui_VideoPlaybackWindow):
    def __init__(self, parent, video=None, playlist=None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, True)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.player = Phonon.VideoPlayer(self)
        self.player.setVisible(False)
        self.layout.addWidget(self.player)
        self.layout.addWidget(self.titleLabel)
        self.layout.addWidget(self.toolBar)
        self.video = video
        self.playlist = playlist
        self.seekBar = Phonon.SeekSlider(self.player.mediaObject(), self.toolBar)
        self.toolBar.addWidget(self.seekBar)
        self.toolBar.addAction(self.muteButton)
        self.mousePressEvent = self.toggleControls
        self.timer = QTimer(self)
        self.connect(self.muteButton, SIGNAL("triggered()"), self.toggleMute)
        self.connect(self.stopButton, SIGNAL("triggered()"), self.stopAndClose)
        self.connect(self.playPauseButton, SIGNAL("triggered()"), self.playPause)
        self.connect(self.previousButton, SIGNAL("triggered()"), self.playPrevious)
        self.connect(self.nextButton, SIGNAL("triggered()"), self.playNext)
        self.player.mediaObject().setPrefinishMark(5000)
        self.player.mediaObject().setTickInterval(1000)
        self.connect(self.timer, SIGNAL("timeout()"), self.toggleSwitch)
        self.connect(self.player.mediaObject(), SIGNAL("prefinishMarkReached(qint32)"), self.queueNextVideo)
        self.connect(self.player.mediaObject(), SIGNAL("currentSourceChanged(const Phonon::MediaSource&)"), self.displayCurrentVideoInfo)
        self.connect(self.player.mediaObject(), SIGNAL("finished()"), self.stopAndClose)
        self.connect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.tick)
        self.currentVideo = 0
        self.showFullScreen()
        if self.video != None:
            mediasource = self.getMediaSource(self.video)
        else:
            mediasource = self.getMediaSource(self.playlist[0])
            self.previousButton.setVisible(True)
            self.nextButton.setVisible(True)
        self.player.play(mediasource)
        self.keepDisplayOn()
        
    def tick(self, a):
        if a >= 500:
            self.player.setVisible(True)
            self.loadingLabel.setVisible(False)            
            self.disconnect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.tick)
        
    def keepDisplayOn(self):
        bus = dbus.SystemBus()
        mce = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
        mce.req_display_blanking_pause()
        QTimer.singleShot(9000, self.keepDisplayOn)
        
    def displayCurrentVideoInfo(self):
        try:
            videoTitle = unicode(self.video.media.title.text, "utf-8")
        except:
            videoTitle = unicode(self.playlist[self.currentVideo].media.title.text, "utf-8")
        self.titleLabel.setText("%s" % videoTitle)
        self.setWindowTitle("%s" % videoTitle)
        QMaemo5InformationBox.information(self, "Playing \'%s\'" % videoTitle)

    def toggleSwitch(self, a=False):
            self.titleLabel.setVisible(a)
            self.toolBar.setVisible(a)        
        
    def toggleControls(self, event=None):
        if self.toolBar.isVisible():
            self.toggleSwitch()
        else:
            self.toggleSwitch(a=True)
            self.timer.start(4000)

    def toggleMute(self):
        if self.player.volume() > 0.0:
            self.player.setVolume(0.0)
            self.muteButton.setIcon(QIcon(":/images/ui-images/volmuted.png"))
        else:
            self.player.setVolume(1.0)
            self.muteButton.setIcon(QIcon(":/images/ui-images/vol.png"))
            
    def getMediaSource(self, video):
        filename = "%s/%s.mp4" % (VideoDownloadSettings.downloadFolder, sub('[\"<>:"/|?*\\\\]', "-", video.media.title.text).decode("utf-8"))
        if QFile.exists(filename):
            self.loadingLabel.setText("Please wait!\nStart loading video from device")
            mediasource = Phonon.MediaSource(filename)
        else:
            self.loadingLabel.setText("Please wait!\nStart loading video from youtube")
            videoUrl = YouTubeDataService.getVideoUrl(video, VideoPlaybackSettings.playbackFormat)
            mediasource = Phonon.MediaSource(videoUrl)
        return mediasource
            
    def queueNextVideo(self):
        if self.playlist != None:
            try:
                video = self.playlist[self.currentVideo + 1]
                mediasource = self.getMediaSource(video)
                self.player.mediaObject().enqueue(mediasource)
                self.currentVideo += 1
            except:
                pass

    def playPause(self):
        if self.player.isPlaying():
            self.player.pause()
            self.playPauseButton.setIcon(QIcon(":/images/ui-images/play.png"))
        else:
            self.player.play()
            self.playPauseButton.setIcon(QIcon(":/images/ui-images/pause.png"))
            
    def playPrevious(self):
        if self.playlist != None and self.player.currentTime() <= 5000:
            video = self.playlist[self.currentVideo - 1]
            mediasource = self.getMediaSource(video)
            if self.currentVideo > 0:
                self.currentVideo -= 1
            else:
                self.currentVideo = len(self.playlist) - 1
            self.player.play(mediasource)
        else:
            self.player.seek(0)
            
    def playNext(self):
        if self.playlist != None:
            try:
                video = self.playlist[self.currentVideo + 1]
                self.currentVideo += 1
            except:
                video = self.playlist[0]
                self.currentVideo = 0
            mediasource = self.getMediaSource(video)
            self.player.play(mediasource)
            
    def stopAndClose(self):
        self.player.stop()
        if self.video != None:
            self.emit(SIGNAL("destroyed"))       
        self.deleteLater()
        self.close()
