# -*- coding: utf-8 -*-
from PyQt4 import QtCore, QtGui

class Ui_VideoPlaybackWindow(object):
    def setupUi(self, VideoPlaybackWindow):
        VideoPlaybackWindow.setObjectName("VideoPlaybackWindow")
        VideoPlaybackWindow.resize(800, 480)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(VideoPlaybackWindow.sizePolicy().hasHeightForWidth())
        VideoPlaybackWindow.setSizePolicy(sizePolicy)
        self.centralWidget = QtGui.QWidget(VideoPlaybackWindow)
        self.centralWidget.setObjectName("centralWidget")
        VideoPlaybackWindow.setCentralWidget(self.centralWidget)
        self.layout = QtGui.QVBoxLayout(self.centralWidget)
        self.layout.setMargin(0)
        self.toolBar = QtGui.QToolBar(VideoPlaybackWindow)        
        self.toolBar.setVisible(False)
        self.muteButton = QtGui.QAction(self.toolBar)
        self.muteButton.setIcon(QtGui.QIcon(":/images/ui-images/vol.png"))
        self.playPauseButton = QtGui.QAction(self.toolBar)
        self.playPauseButton.setIcon(QtGui.QIcon(":/images/ui-images/pause.png"))
        self.stopButton = QtGui.QAction(self.toolBar)
        self.stopButton.setIcon(QtGui.QIcon(":/images/ui-images/stop.png"))
        self.previousButton = QtGui.QAction(self.toolBar)
        self.previousButton.setIcon(QtGui.QIcon(":/images/ui-images/rew.png"))
        self.previousButton.setVisible(False)
        self.nextButton = QtGui.QAction(self.toolBar)
        self.nextButton.setIcon(QtGui.QIcon(":/images/ui-images/ff.png"))
        self.nextButton.setVisible(False)
        self.toolBar.addAction(self.previousButton)
        self.toolBar.addAction(self.stopButton)
        self.toolBar.addAction(self.playPauseButton)
        self.toolBar.addAction(self.nextButton)
        self.titleLabel = QtGui.QLabel(VideoPlaybackWindow)
        self.titleLabel.setStyleSheet("margin-left: 15px; font-size: 22px;")
        self.titleLabel.setVisible(False)
        self.titleLabel.setFixedHeight(25)
        self.loadingLabel = QtGui.QLabel(VideoPlaybackWindow)
        self.loadingLabel.setAlignment(QtCore.Qt.AlignCenter)
        self.loadingLabel.setStyleSheet("font-size: 36px; background-color: qlineargradient(x1: 0, y1: 0.2, x2: 0.5, y2: 0.8, stop: 0 #4ABEFF, stop: 0.6 #000000);")
        self.loadingLabel.setGeometry(QtCore.QRect(0, 0, 800, 480))
        self.loadingLabel.setVisible(True)

        self.retranslateUi(VideoPlaybackWindow)

    def retranslateUi(self, VideoPlaybackWindow):
        VideoPlaybackWindow.setWindowTitle(QtGui.QApplication.translate("VideoPlaybackWindow", "YTube Player", None, QtGui.QApplication.UnicodeUTF8))
        self.loadingLabel.setText(QtGui.QApplication.translate("VideoPlaybackWindow", "Loading....", None, QtGui.QApplication.UnicodeUTF8))
