# -*- coding: utf-8 -*-
from os import path
from re import sub
import dbus
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.phonon import Phonon
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from youtubeservice import YouTubeDataService
from youtubeconfig import VideoPlaybackSettings, VideoDownloadSettings
import resources_rc

class VideoPlaybackWindow(Phonon.VideoPlayer):
    def __init__(self, parent, video=None, playlist=None):
        Phonon.VideoPlayer.__init__(self, parent)
        self.setWindowFlags(Qt.Window)
        self.resize(800, 480)
        self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, True)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.video = video
        self.playlist = playlist
        self.toolBar = QToolBar(self)        
        self.toolBar.setVisible(False)
        self.muteButton = QAction(self.toolBar)
        self.muteButton.setIcon(QIcon(":/images/ui-images/vol.png"))
        self.playPauseButton = QAction(self.toolBar)
        self.playPauseButton.setIcon(QIcon(":/images/ui-images/pause.png"))
        self.stopButton = QAction(self.toolBar)
        self.stopButton.setIcon(QIcon(":/images/ui-images/stop.png"))
        self.previousButton = QAction(self.toolBar)
        self.previousButton.setIcon(QIcon(":/images/ui-images/rew.png"))
        self.previousButton.setVisible(False)
        self.nextButton = QAction(self.toolBar)
        self.nextButton.setIcon(QIcon(":/images/ui-images/ff.png"))
        self.nextButton.setVisible(False)
        self.seekBar = Phonon.SeekSlider(self.mediaObject(), self.toolBar)
        self.toolBar.addAction(self.previousButton)
        self.toolBar.addAction(self.stopButton)
        self.toolBar.addAction(self.playPauseButton)
        self.toolBar.addAction(self.nextButton)
        self.toolBar.addWidget(self.seekBar)
        self.toolBar.addAction(self.muteButton)
        self.titleLabel = QLabel(self)
        self.titleLabel.setStyleSheet("margin-left: 70px; font-size: 22px")
        self.titleLabel.setVisible(False)
        self.titleLabel.setFixedHeight(25)
        self.layout().addWidget(self.titleLabel)
        self.layout().addWidget(self.toolBar)
        self.mousePressEvent = self.toggleControls
        self.connect(self.muteButton, SIGNAL("triggered()"), self.toggleMute)
        self.connect(self.stopButton, SIGNAL("triggered()"), self.stopAndClose)
        self.connect(self.playPauseButton, SIGNAL("triggered()"), self.playPause)
        self.connect(self.previousButton, SIGNAL("triggered()"), self.playPrevious)
        self.connect(self.nextButton, SIGNAL("triggered()"), self.playNext)
        self.mediaObject().setPrefinishMark(5000)
        self.timer = QTimer(self)
        self.connect(self.timer, SIGNAL("timeout()"), self.toggleSwitch)
        self.connect(self.mediaObject(), SIGNAL("prefinishMarkReached(qint32)"), self.queueNextVideo)
        self.connect(self.mediaObject(), SIGNAL("currentSourceChanged(const Phonon::MediaSource&)"), self.displayCurrentVideoInfo)
        self.connect(self.mediaObject(), SIGNAL("finished()"), self.stopAndClose)
        self.currentVideo = 0
        if self.video != None:
            mediasource = self.getMediaSource(self.video)
        else:
            mediasource = self.getMediaSource(self.playlist[0])
            self.previousButton.setVisible(True)
            self.nextButton.setVisible(True)
        self.play(mediasource)
        self.keepDisplayOn()
        self.showFullScreen()

    def keepDisplayOn(self):
        bus = dbus.SystemBus()
        mce = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
        mce.req_display_blanking_pause()
        QTimer.singleShot(9000, self.keepDisplayOn)
        
    def displayCurrentVideoInfo(self):
        try:
            videoTitle = unicode(self.video.media.title.text, "utf-8")
        except:
            videoTitle = unicode(self.playlist[self.currentVideo].media.title.text, "utf-8")
        self.titleLabel.setText("%s" % videoTitle)
        self.setWindowTitle("%s" % videoTitle)
        QMaemo5InformationBox.information(self, "Playing \'%s\'" % videoTitle)

    def toggleSwitch(self, a=False):
            self.titleLabel.setVisible(a)
            self.toolBar.setVisible(a)        
        
    def toggleControls(self, event=None):
        if self.toolBar.isVisible():
            self.toggleSwitch()
        else:
            self.toggleSwitch(a=True)
            self.timer.start(4000)

    def toggleMute(self):
        if self.volume() > 0.0:
            self.setVolume(0.0)
            self.muteButton.setIcon(QIcon(":/images/ui-images/volmuted.png"))
        else:
            self.setVolume(1.0)
            self.muteButton.setIcon(QIcon(":/images/ui-images/vol.png"))
            
    def getMediaSource(self, video):
        filename = "%s/%s.mp4" % (VideoDownloadSettings.downloadFolder, sub('[\"<>:"/|?*\\\\]', "-", video.media.title.text).decode("utf-8"))
        if path.exists(filename):
            mediasource = Phonon.MediaSource(filename)
        else:
            videoUrl = YouTubeDataService.getVideoUrl(video, VideoPlaybackSettings.playbackFormat)
            mediasource = Phonon.MediaSource(videoUrl)
        return mediasource
            
    def queueNextVideo(self):
        if self.playlist != None:
            try:
                video = self.playlist[self.currentVideo + 1]
                mediasource = self.getMediaSource(video)
                self.mediaObject().enqueue(mediasource)
                self.currentVideo += 1
            except:
                pass

    def playPause(self):
        if self.isPlaying():
            self.pause()
            self.playPauseButton.setIcon(QIcon(":/images/ui-images/play.png"))
        else:
            self.play()
            self.playPauseButton.setIcon(QIcon(":/images/ui-images/pause.png"))
            
    def playPrevious(self):
        if self.playlist != None and self.currentTime() <= 5000:
            video = self.playlist[self.currentVideo - 1]
            mediasource = self.getMediaSource(video)
            if self.currentVideo > 0:
                self.currentVideo -= 1
            else:
                self.currentVideo = len(self.playlist) - 1
            self.play(mediasource)
        else:
            self.seek(0)
            
    def playNext(self):
        if self.playlist != None:
            try:
                video = self.playlist[self.currentVideo + 1]
                self.currentVideo += 1
            except:
                video = self.playlist[0]
                self.currentVideo = 0
            mediasource = self.getMediaSource(video)
            self.play(mediasource)
            
    def stopAndClose(self):
        self.stop()
        if self.video != None:
            self.emit(SIGNAL("destroyed"))       
        self.deleteLater()
        self.close()
