# -*- coding: utf-8 -*-
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from Ui_videoinfowindow import Ui_VideoInfoWindow
from youtubeconfig import VideoSharingSettings, GeneralSettings
import youtubedialogs
import youtubewindows
import youtubeservice
import time

class VideoInfoWindow(QMainWindow, Ui_VideoInfoWindow):    
    def __init__(self, parent, video, playlistId = None, position = None, count = None, subscribed=False):
        QMainWindow.__init__(self, parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, GeneralSettings.autoOrientation)
        self.setupUi(self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.descriptionTextBox.viewport().setAutoFillBackground(False)
        self.titleLabel.viewport().setAutoFillBackground(False)
        self.video = video
        self.subscribed = subscribed
        
        if playlistId != None:
            self.playlistId = playlistId
            self.playlistPosition = position
            self.playlistLength = count
            self.actionEditVideo.setVisible(True)
            self.actionEditVideo.setText("Edit custom metadata")
        if self.video.media.credit.text == youtubeservice.YouTubeDataService.currentUser:
            self.actionRateVideo.setVisible(False)
            self.actionUserVideos.setVisible(False)
            self.actionEditVideo.setVisible(True)
        if youtubeservice.YouTubeDataService.currentUser == "":
            self.actionRateVideo.setVisible(False)
            self.actionAddComment.setVisible(False)
            self.actionAddToFavourites.setVisible(False)
            self.actionAddToPlaylist.setVisible(False)
        self.show()
        self.loadData()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.likeLabel.setGeometry(QRect(300, 25, 45, 45))
            self.likeCountLabel.setGeometry(QRect(355, 30, 150, 45))
            self.dislikeLabel.setGeometry(QRect(300, 75, 45, 45))
            self.dislikeCountLabel.setGeometry(QRect(355, 75, 150, 45))
            self.viewsLabel.setGeometry(QRect(300, 125, 50, 30))
            self.viewsNumberLabel.setGeometry(QRect(355, 130, 180, 25))
            self.commentsLabel.setGeometry(QRect(300, 165, 50, 40))
            self.commentNumberLabel.setGeometry(QRect(355, 175, 180, 25))
            self.titleLabel.setGeometry(QRect(10, 235, 460, 70))
            self.descriptionTextBox.setGeometry(QRect(10, 295, 460, 265))
            self.clipboardButton.setGeometry(QRect(10, 580, 70, 70))
            self.facebookButton.setGeometry(QRect(95, 580, 70, 70))
            self.twitterButton.setGeometry(QRect(180, 580, 70, 70))
            self.downloadButton.setGeometry(QRect(10, 660, 225, 70))
            self.playButton.setGeometry(QRect(245, 660, 225, 70))
        else:
            self.titleLabel.setGeometry(QRect(300, 20, 490, 70))
            self.likeLabel.setGeometry(QRect(5, 235, 45, 45))
            self.likeCountLabel.setGeometry(QRect(65, 240, 150, 45))
            self.dislikeLabel.setGeometry(QRect(160, 235, 45, 45))
            self.dislikeCountLabel.setGeometry(QRect(215, 240, 70, 45))            
            self.viewsLabel.setGeometry(QRect(5, 280, 50, 30))
            self.viewsNumberLabel.setGeometry(QRect(65, 283, 180, 25))
            self.commentsLabel.setGeometry(QRect(5, 305, 50, 40))
            self.commentNumberLabel.setGeometry(QRect(65, 310, 180, 25))
            self.descriptionTextBox.setGeometry(QRect(300, 90, 490, 227))
            self.clipboardButton.setGeometry(QRect(5, 340, 70, 70))
            self.facebookButton.setGeometry(QRect(95, 340, 70, 70))
            self.twitterButton.setGeometry(QRect(180, 340, 70, 70))
            self.downloadButton.setGeometry(QRect(260, 340, 260, 70))
            self.playButton.setGeometry(QRect(530, 340, 260, 70))

    def loadData(self):
        self.loadTitleAndDescription()
        self.loadViewsCommentsRating()
        self.loadThumbnail()

    def loadTitleAndDescription(self):
        self.actionUserVideos.setText("%s\'s Videos" % unicode(self.video.media.credit.text, "utf-8"))
        self.titleLabel.setText(unicode(self.video.media.title.text, "utf-8"))
        for link in self.video.link:
            if link.rel == "self":
                video_uri = link.href
        try:
            if ("playlist" in video_uri and self.video.summary):
                self.descriptionTextBox.setText(unicode(self.video.summary.text, "utf-8"))
            else:
                self.descriptionTextBox.setText(unicode(self.video.media.description.text, "utf-8"))
        except:
            self.descriptionTextBox.setText("No description")

    def loadViewsCommentsRating(self):
        try:
            self.viewsNumberLabel.setText(self.video.statistics.view_count)
        except:
            self.viewsNumberLabel.setText("--")
        try: 
            self.commentNumberLabel.setText(self.video.comments.feed_link[0].count_hint)
            if self.video.comments.feed_link[0].count_hint == "0":
                self.actionViewComments.setVisible(False)
        except:
            self.commentNumberLabel.setText("0")
            self.actionViewComments.setVisible(False)
        try:
            self.likeCountLabel.setText(self.video.likes_and_dislikes.num_likes)
            self.dislikeCountLabel.setText(self.video.likes_and_dislikes.num_dislikes)
        except:
            pass
        
                
    def loadThumbnail(self):
        self.durationLabel.setText(unicode(time.strftime('%M:%S', time.gmtime(float(self.video.media.duration.seconds)))))        
        thumbUrl = self.video.media.thumbnail[1].url
        thumbnail = youtubeservice.YouTubeDataService.getVideoThumbnail(thumbUrl)
        try:
            self.thumbLabel.setPixmap(thumbnail)
            self.thumbLabel.mouseReleaseEvent = self.playVideo
        except:
            self.thumbLabel.setPixmap(QPixmap(":/images/ui-images/thumbnail.png"))
    
    def playVideo(self, event = None):
        self.toggleBusy(True)
        self.emit(SIGNAL("playingVideo"))
        self.deleteLater()
        self.close()

    def downloadVideo(self):
        videoTitle = self.video.media.title.text
        try:
            youtubeservice.YouTubeVideoDownloader.addTask(self.video)
            QMaemo5InformationBox.information(self, "\'%s\' has been added to your download queue" % unicode(videoTitle, "utf-8"))
            self.emit(SIGNAL("downloadsChanged(int)"), len(youtubeservice.YouTubeVideoDownloader.taskQueue))
        except:
            QMaemo5InformationBox.information(self, "Unable to add video to your download queue")
    
    def toggleBusy(self, isBusy = False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
        
    @pyqtSignature("")
    def on_clipboardButton_clicked(self):
        videoUrl = self.video.media.player.url.split("&")[0]
        clipboard = QApplication.clipboard()
        clipboard.setText(self.goo_gl(videoUrl))
        QMaemo5InformationBox.information(self, "Video URL copied")
        
    @pyqtSignature("")
    def on_facebookButton_clicked(self):
        self.toggleBusy(True)
        videoUrl = self.video.media.player.url.split("&")[0]
        if not VideoSharingSettings.raiseFacebookAuthorisationDialog:
            shareViaFacebookDialog = youtubedialogs.ShareViaFacebookDialog(self, self.goo_gl(videoUrl))
        else:
            facebookAuthorisationDialog = youtubedialogs.FacebookAuthorisationDialog(self)
            self.connect(facebookAuthorisationDialog, SIGNAL("accepted()"), self.on_facebookButton_clicked)
        self.toggleBusy()
        
    @pyqtSignature("")
    def on_twitterButton_clicked(self):
        self.toggleBusy(True)
        videoUrl = self.video.media.player.url.split("&")[0]
        if not VideoSharingSettings.raiseTwitterAuthorisationDialog:
            shareViaTwitterDialog = youtubedialogs.ShareViaTwitterDialog(self, self.goo_gl(videoUrl))
        else:
            twitterAuthorisationDialog = youtubedialogs.TwitterAuthorisationDialog(self)
            self.connect(twitterAuthorisationDialog, SIGNAL("accepted()"), self.on_twitterButton_clicked)
        self.toggleBusy()
    
    @pyqtSignature("")
    def on_playButton_clicked(self):
        self.playVideo()
    
    @pyqtSignature("")
    def on_downloadButton_clicked(self):
        self.downloadVideo()

    @pyqtSignature("")
    def on_actionAddToQueue_triggered(self):
        videoTitle = self.video.media.title.text
        try:
            youtubeservice.YouTubeQueueFeed.playlist.append(self.video)
            self.emit(SIGNAL("queueChanged(int)"), len(youtubeservice.YouTubeQueueFeed.playlist))
            QMaemo5InformationBox.information(self, "\'%s\' added to playback queue" % unicode(videoTitle, "utf-8"))            
        except:
            QMaemo5InformationBox.information(self, "Unable to add video to playback queue")
       
    
    @pyqtSignature("")
    def on_actionRateVideo_triggered(self):
        videoId = self.video.media.video_id.text
        rateVideoDialog = youtubedialogs.RateVideoDialog(self, videoId)

    @pyqtSignature("")
    def on_actionAddComment_triggered(self):
        addCommentDialog = youtubedialogs.AddCommentDialog(self, self.video)
        self.connect(addCommentDialog, SIGNAL("accepted()"), self.on_actionViewComments_triggered)

    @pyqtSignature("")
    def on_actionViewComments_triggered(self):
        commentsWindow = youtubewindows.CommentsWindow(self, self.video)
    
    @pyqtSignature("")
    def on_actionUserVideos_triggered(self):
        userName = self.video.media.credit.text
        userWindow = youtubewindows.YoutubeWindow(self, username=userName, windowId="usersvideos", subscribed=self.subscribed)
        self.connect(userWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.connect(userWindow, SIGNAL("queueChanged(int)"), self.queueChanged)

    @pyqtSignature("")
    def on_actionRelatedVideos_triggered(self):
        relatedVideosWindow = youtubewindows.YoutubeWindow(self, video=self.video, windowId="relatedvideos")
        self.connect(relatedVideosWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.connect(relatedVideosWindow, SIGNAL("queueChanged(int)"), self.queueChanged)

    @pyqtSignature("")
    def on_actionResponsesVideos_triggered(self):
        responsesVideosWindow = youtubewindows.YoutubeWindow(self, video=self.video, windowId="relatedvideos", related="video.responses")
        self.connect(responsesVideosWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.connect(responsesVideosWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
    
    @pyqtSignature("")
    def on_actionAddToFavourites_triggered(self):
        try:
            videoId = self.video.media.video_id.text
            addedToFavourites = youtubeservice.YouTubeDataService.addVideoToFavourites(videoId)
            if addedToFavourites == True:
                QMaemo5InformationBox.information(self, "\'%s\' has been added to your favourites" % unicode(self.video.media.title.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self,  addedToFavourites)
        except:
            QMaemo5InformationBox.information(self,  "Unable to add video to your favourites")

    @pyqtSignature("")
    def on_actionAddToPlaylist_triggered(self):
        playlistDialog = youtubedialogs.AddToPlaylistDialog(self, [self.video])

    @pyqtSignature("")
    def on_actionEditVideo_triggered(self):
        for link in self.video.link:
            if link.rel == "self":
                video_uri = link.href
                
        if "playlist" in video_uri:
            editVideoDialog = youtubedialogs.EditPlaylistVideoDialog(self, video_uri, self.video, self.playlistPosition, self.playlistLength)
        else:
            editVideoDialog = youtubedialogs.EditVideoDialog(self, self.video)
        self.connect(editVideoDialog, SIGNAL("accepted()"), self.loadData)
        
    @pyqtSignature("")
    def on_ratingButton_clicked(self):
        rateVideoDialog = youtubedialogs.RateVideoDialog(self, self.video.media.video_id.text)
        
    def queueChanged(self, queueLength):
        self.emit(SIGNAL("queueChanged(int)"), queueLength)
        
    def downloadsChanged(self,  taskQueueLength):
        self.emit(SIGNAL("downloadsChanged(int)"), taskQueueLength)

    def goo_gl(self, url):
        from simplejson import loads, dumps
        import httplib2
        conn = httplib2.Http()
        try:
            goo_url = loads(conn.request("https://www.googleapis.com/urlshortener/v1/url?key=AIzaSyAIc05cJj2His3YirD545jlFDg7FNWaet0", "POST",
                                         dumps({'longUrl' : url}), {'Content-Type' : 'application/json'})[1])['id']
        except:
            goo_url = url
        return goo_url
