# -*- coding: utf-8 -*-
from PyQt4.QtGui import *
from PyQt4.QtCore import *
import time

from Ui_delegatewidgets import Ui_VideoItemWidget,  Ui_VideoDownloadWidget

class VideoItemWidget(QWidget, Ui_VideoItemWidget):
    def __init__(self, parent, video):
        QWidget.__init__(self, parent)
        self.setupUi(self)
        self.checkBox.mousePressEvent = self.ignoreClick
        self.titleLabel.setText("%s" % unicode(video.media.title.text,  "utf-8"))
        try:
            self.durationLabel.setText(unicode(time.strftime(' %M:%S ', time.gmtime(float(video.media.duration.seconds)))))
        except:
            self.durationLabel.setText("--")

        try:
            viewscount = "\n%s views" % video.statistics.view_count
        except:
            viewscount = ""

        try:
            raTe = video.rating.average[:1]
        except:
            raTe = 0
            
        stars = "*" * int(raTe)            
        self.authorLabel.setText("%s\n%s%s" % (unicode(video.media.credit.text, "utf-8"), video.media.uploaded.text.split("T")[0], viewscount))
        self.ratingstars.setText("%s" % stars)
        
    def ignoreClick(self, event):
        event.ignore()

    def hideCheckBox(self):      
        self.thumbLabel.move(0, 2)
        self.durationLabel.move(130, 113)
        self.ratingstars.move(2, 113)
        self.widget.setGeometry(QRect(182, 0, 670, 140))
        self.checkBox.setVisible(False)
        self.checkBox.setCheckState(Qt.Unchecked)

    def showCheckBox(self):
        self.thumbLabel.move(70, 2)
        self.durationLabel.move(200, 113)
        self.ratingstars.move(72, 113)
        self.widget.setGeometry(QRect(245, 0, 590, 140))
        self.checkBox.setVisible(True)

    def toggleCheckBox(self):
        if not self.checkBox.isVisible():
            self.showCheckBox()
        else:
            self.hideCheckBox()

class VideoDownloadItemWidget(QWidget, Ui_VideoDownloadWidget):
    def __init__(self, parent, video):
        QWidget.__init__(self, parent)
        self.setupUi(self)
        self.titleLabel.setText(unicode(video.media.title.text,  "utf-8"))
        self.durationLabel.setText(unicode(time.strftime('%M:%S', time.gmtime(float(video.media.duration.seconds)))))
        self.orientationChanged()
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.widget.setGeometry(QRect(182, 2, 180, 140))
            self.progressBar.setGeometry(QRect(330, 2, 120, 140))
        else:
            self.widget.setGeometry(QRect(182, 2, 470, 140))
            self.progressBar.setGeometry(QRect(620, 2, 150, 140))

class CommentWidget(QWidget):
    def __init__(self, parent, author, comment):
        QWidget.__init__(self, parent)
        self.textEdit = QTextEdit()
        self.textEdit.setReadOnly(True)
        self.textEdit.viewport().setAutoFillBackground(False)
        self.textEdit.setFrameStyle(QFrame.NoFrame)
        self.textEdit.setStyleSheet("color: rgb(255, 255, 255); font-size: 18px")
        self.document = QTextDocument(unicode(comment, "utf-8"))
        self.textEdit.setDocument(self.document)
        self.textEdit.setFixedHeight(self.document.documentLayout().documentSize().toSize().height())
        self.authorLabel = QLabel(unicode(author, "utf-8"))
        self.authorLabel.setStyleSheet("color: rgb(120, 120, 120) ")
        self.vbox = QVBoxLayout(self)
        self.vbox.addWidget(self.authorLabel)
        self.vbox.addWidget(self.textEdit)
        self.setLayout(self.vbox)
