#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from Ui_ytube import Ui_MainWindow
import youtubedialogs
import youtubewindows
import myaccountwindow
import osso
from youtubeservice import YouTubeDataService, YouTubeVideoDownloader
from youtubeconfig import *

class MainWindow(QMainWindow, Ui_MainWindow):
    def __init__(self, parent = None):
        self.dbus_service_name = "com.nokia.ytube"
        self.osso_c = osso.Context(self.dbus_service_name, "1.1", False)
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.restoreSettings()
        self.setAttribute(Qt.WA_Maemo5StackedWindow) 
        self.setAutoDisplayOrientation()
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.keyPressEvent = self.showSearchDialog
        for button in (self.myAccountButton, self.mostViewedButton, self.latestsubscribButton, self.searchButton):            
            button.setStyleSheet("border-radius: 10px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4ABEFF, stop: 0.6 #000000);")
            self.connect(button,  SIGNAL("pressed()"), self.changeButtonStyleSheet)
            self.connect(button,  SIGNAL("released()"), self.changeButtonStyleSheet)        
        self.searchDialogRaised = False
        taskQueueLength = len(YouTubeVideoDownloader.taskQueue)
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%d videos)" % taskQueueLength)
        self.login = False
        
    def changeButtonStyleSheet(self):
        button = self.sender()
        if button.isDown():
            button.setStyleSheet("border-radius: 10px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #000000, stop: 0.6 #4ABEFF);")            
        else:
            button.setStyleSheet("border-radius: 10px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4ABEFF, stop: 0.6 #000000);")           
        
    def youtubeLogin(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
        try:
            if YouTubeAPISettings.userDict == {}:
                if YouTubeAPISettings.raiseNoAccountFoundDialog:
                    noAccountFoundDialog = youtubedialogs.NoAccountFoundDialog(self)
            else:
                username = YouTubeAPISettings.defaultUser
                if YouTubeDataService.youtubeLogin(username) == True:
                    self.login = True
                    QMaemo5InformationBox.information(self, "You are signed in to YouTube as \'%s\'" % username)
                else:
                    QMaemo5InformationBox.information(self, "Unable to sign in to your YouTube account")
        except:
            try:
                username = YouTubeAPISettings.userDict.keys()[0]
                if YouTubeDataService.youtubeLogin(username) == True:
                    self.login = True
                    QMaemo5InformationBox.information(self, "You are signed in to YouTube as \'%s\'" % username)
                else:
                    QMaemo5InformationBox.information(self, "Unable to sign in to your YouTube account")
            except:
                QMaemo5InformationBox.information(self, "Unable to sign in to your YouTube account")
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
                
    def showSearchDialog(self,  event):
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control, Qt.Key_Shift, Qt.Key_Space) and not self.searchDialogRaised:
            self.setSearchDialogRaised(True)
            searchDialog = youtubedialogs.SearchDialog(self)
            searchDialog.lineEdit.insert(event.text())
            QTimer.singleShot(1000,  lambda isRaised = False: self.setSearchDialogRaised(isRaised))
        else:
            pass
            
    def setSearchDialogRaised(self,  isRaised):
        self.searchDialogRaised = isRaised
                
    def restoreSettings(self):
        try:
            settings = QSettings("ytube", "ytube")
            GeneralSettings.autoOrientation = settings.value("autoOrientation", True).toBool()
            YouTubeAPISettings.userDict = settings.value("userDict",  {}).toPyObject()
            YouTubeAPISettings.defaultUser = settings.value("defaultUser",  "").toString()
            YouTubeAPISettings.raiseNoAccountFoundDialog = settings.value("noAccountDialog",  True).toBool()
            YouTubeAPISettings.categoryFilter = settings.value("categoryFilter", "").toString()
            YouTubeAPISettings.locationFilter = settings.value("locationFilter", "").toString()
            if VideoPlaybackSettings.playbackFormat in (17, 18):
                VideoPlaybackSettings.playbackFormat = settings.value("playbackFormat",  18).toInt()[0]
            VideoDownloadSettings.downloadFolder = settings.value("downloadFolder",  "/home/user/MyDocs/.video").toString()
            VideoDownloadSettings.defaultTaskStatus = settings.value("downloadStatus",  "paused").toString()
            if VideoDownloadSettings.downloadFormat in (17, 18, 34, 35, 22):
                VideoDownloadSettings.downloadFormat = settings.value("downloadFormat",  18).toInt()[0]
            YouTubeVideoDownloader.restoreTasks(settings.value("downloadTaskQueue", QStringList()).toStringList())
            VideoSharingSettings.raiseTwitterAuthorisationDialog = settings.value("twitterAuthDialog", True).toBool()
            VideoSharingSettings.twitterAccessTokenKey = settings.value("twitterKey", "").toString()
            VideoSharingSettings.twitterAccessTokenSecret = settings.value("twitterSecret", "").toString()
            VideoSharingSettings.raiseFacebookAuthorisationDialog = settings.value("facebookAuthDialog", True).toBool()
            VideoSharingSettings.facebookAccessToken = settings.value("facebookToken", "").toString()
            SearchSettings.searchOrder = settings.value("searchOrder",  0).toInt()[0]
            SearchSettings.recentSearches = settings.value("recentSearches", QStringList()).toStringList()
        except:
            pass
                    
    def closeEvent(self,  event):
        try:
            settings = QSettings("ytube", "ytube")
            autoOrientation = QVariant(GeneralSettings.autoOrientation)
            userDict = QVariant(YouTubeAPISettings.userDict)
            defaultUser = QVariant(YouTubeAPISettings.defaultUser)
            noAccountDialog = QVariant(YouTubeAPISettings.raiseNoAccountFoundDialog)
            categoryFilter = QVariant(YouTubeAPISettings.categoryFilter)
            locationFilter = QVariant(YouTubeAPISettings.locationFilter)
            playbackFormat = QVariant(VideoPlaybackSettings.playbackFormat)        
            downloadFolder = QVariant(VideoDownloadSettings.downloadFolder)
            downloadStatus = QVariant(VideoDownloadSettings.defaultTaskStatus)
            downloadFormat = QVariant(VideoDownloadSettings.downloadFormat)
            downloadTaskQueue = QVariant (YouTubeVideoDownloader.saveTasks())
            twitterAuthDialog = QVariant(VideoSharingSettings.raiseTwitterAuthorisationDialog)
            twitterKey = QVariant(VideoSharingSettings.twitterAccessTokenKey)
            twitterSecret = QVariant(VideoSharingSettings.twitterAccessTokenSecret)
            facebookAuthDialog = QVariant(VideoSharingSettings.raiseFacebookAuthorisationDialog)
            facebookToken = QVariant(VideoSharingSettings.facebookAccessToken)
            searchOrder = QVariant(SearchSettings.searchOrder)
            recentSearches = QVariant(SearchSettings.recentSearches)
            settings.setValue("autoOrientation", autoOrientation)
            settings.setValue("userDict", userDict)
            settings.setValue("defaultUser", defaultUser)
            settings.setValue("noAccountDialog", noAccountDialog)
            settings.setValue("categoryFilter", categoryFilter)
            settings.setValue("locationFilter", locationFilter)
            settings.setValue("downloadFolder", downloadFolder)
            settings.setValue("downloadStatus", downloadStatus)
            settings.setValue("playbackFormat", playbackFormat)
            settings.setValue("downloadFormat", downloadFormat)
            settings.setValue("downloadTaskQueue", downloadTaskQueue)
            settings.setValue("twitterAuthDialog", twitterAuthDialog)
            settings.setValue("twitterKey", twitterKey)
            settings.setValue("twitterSecret", twitterSecret)
            settings.setValue("facebookAuthDialog", facebookAuthDialog)
            settings.setValue("facebookToken", facebookToken)
            settings.setValue("searchOrder", searchOrder)
            settings.setValue("recentSearches", recentSearches)
        except:
            pass
        
    def setAutoDisplayOrientation(self):
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, GeneralSettings.autoOrientation)
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 800)
            self.myAccountButton.setGeometry(QRect(80, 150, 120, 120))
            self.mostViewedButton.setGeometry(QRect(280, 150, 120, 120))
            self.latestsubscribButton.setGeometry(QRect(80, 400, 120, 120))
            self.searchButton.setGeometry(QRect(280, 400, 120, 120))
            self.myAccountLabel.setGeometry(QRect(76, 278, 127, 26))
            self.mostViewedLabel.setGeometry(QRect(274, 278, 132, 26))
            self.latestsubscribLabel.setGeometry(QRect(72, 527, 135, 26))
            self.searchLabel.setGeometry(QRect(301, 527, 75, 26))
        else:
            self.resize(800, 480)
            self.myAccountButton.setGeometry(QRect(57, 123, 120, 120))
            self.mostViewedButton.setGeometry(QRect(243, 123, 120, 120))
            self.latestsubscribButton.setGeometry(QRect(434, 123, 120, 120))
            self.searchButton.setGeometry(QRect(628, 123, 120, 120))
            self.myAccountLabel.setGeometry(QRect(53, 250, 127, 26))
            self.mostViewedLabel.setGeometry(QRect(239, 250, 132, 26))
            self.latestsubscribLabel.setGeometry(QRect(426, 250, 135, 26))
            self.searchLabel.setGeometry(QRect(651, 250, 75, 26))

    def queueChanged(self, queueLength):
        if queueLength > 0:
            self.actionGoToQueue.setVisible(True)
            self.actionGoToQueue.setText("Queue (%d videos)" % queueLength)
        else:
            self.actionGoToQueue.setVisible(False)
            
    def downloadsChanged(self,  taskQueueLength):
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%d videos)" % taskQueueLength)
        else:
            self.actionDownloads.setVisible(False)

    @pyqtSignature("")
    def on_actionGoToQueue_triggered(self):
        playbackQueueWindow = youtubewindows.PlaybackQueueWindow(self)
        self.connect(playbackQueueWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(playbackQueueWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_myAccountButton_clicked(self):
        if YouTubeDataService.currentUser == "" or not self.login:
            self.youtubeLogin()
            if YouTubeDataService.currentUser == "" or not self.login:
                QMaemo5InformationBox.information(self, "You are not signed in to YouTube")
            else:
                myAccountWindow = myaccountwindow.MyAccountWindow(self)
                self.connect(myAccountWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
                self.connect(myAccountWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        else:
            myAccountWindow = myaccountwindow.MyAccountWindow(self)
            self.connect(myAccountWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
            self.connect(myAccountWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_mostViewedButton_clicked(self):
        ytWindow = youtubewindows.YoutubeWindow(self)
        self.connect(ytWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(ytWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_latestsubscribButton_clicked(self):
        if YouTubeDataService.currentUser == "" or not self.login:
            self.youtubeLogin()
            if YouTubeDataService.currentUser == "" or not self.login:
                QMaemo5InformationBox.information(self, "You are not signed in to YouTube")
            else:
                ytWindow = youtubewindows.YoutubeWindow(self, subscribed=True)
                self.connect(ytWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
                self.connect(ytWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        else:
            ytWindow = youtubewindows.YoutubeWindow(self, subscribed=True)
            self.connect(ytWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
            self.connect(ytWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_searchButton_clicked(self):
        searchDialog = youtubedialogs.SearchDialog(self)
        self.connect(searchDialog, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(searchDialog, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_actionSettings_triggered(self):
        settingsDialog = youtubedialogs.SettingsDialog(self)
        self.connect(settingsDialog, SIGNAL("autoOrientationChanged()"), self.setAutoDisplayOrientation)
    
    @pyqtSignature("")
    def on_actionDownloads_triggered(self):        
        downloadsWindow = youtubewindows.DownloadsWindow(self)
        self.connect(downloadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(downloadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)

    @pyqtSignature("")
    def on_actionManageAccounts_triggered(self):
        manageAccountsDialog = youtubedialogs.ManageAccountsDialog(self)
        
    def takeScreenShot(self):
        pvr = "/home/user/.cache/launch/%s.pvr" % self.dbus_service_name
        if not QFile.exists(pvr):
            QPixmap.grabWidget(self.centralwidget).save(pvr, 'png')
        
if __name__ == '__main__':
    from sys import argv, exit
    app = QApplication(argv)
    app.setApplicationName("YTube")
    YTube = MainWindow()
    YTube.show()
    YTube.takeScreenShot()
    exit(app.exec_())

