# -*- coding: utf-8 -*-
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from Ui_youtubewindows import Ui_YoutubeWindows
from videoinfowindow import VideoInfoWindow
import delegatewidgets
import youtubeservice
import youtubedialogs
from youtubeconfig import GeneralSettings, YouTubeAPISettings
from videoplaybackwindow import VideoPlaybackWindow

class YoutubeWindows(QMainWindow, Ui_YoutubeWindows):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, GeneralSettings.autoOrientation)
        self.lineFilter = QLineEdit(self.toolBar)
        self.toolBar.addWidget(self.lineFilter)
        closeFilter = QAction(self.toolBar)
        closeIcon = QIcon(":/images/ui-images/downloadicon.png")
        closeIcon.actualSize(QSize(64, 64))
        closeFilter.setIcon(closeIcon)
        self.toolBar.addAction(closeFilter)
        self.toolBar.setVisible(False)
        self.listWidget.keyPressEvent = self.filterList
        self.listWidget.setContextMenuPolicy(Qt.ActionsContextMenu)
        queueLength = len(youtubeservice.YouTubeQueueFeed.playlist)
        if queueLength > 0:
            self.actionGoToQueue.setVisible(True)
            self.actionGoToQueue.setText("Queue (%d videos)" % queueLength)
        taskQueueLength = len(youtubeservice.YouTubeVideoDownloader.taskQueue)
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%d videos)" % taskQueueLength)
        self.connect(closeFilter, SIGNAL("triggered()"), self.closeFilter)
        self.connect(self.actionAddToQueue, SIGNAL("triggered()"), self.addToQueue)
        self.connect(self.actionPlaying, SIGNAL("triggered()"), self.playingVideo)
        self.connect(self.actionAddToPlaylist, SIGNAL("triggered()"), self.addToPlaylist)
        self.connect(self.actionAddToFavourites, SIGNAL("triggered()"), self.addToFavourites)
        self.connect(self.actionDeleteVideo, SIGNAL("triggered()"), self.confirmVideoDelete)
        self.connect(self.moreButton, SIGNAL("pressed()"), self.changeButtonStyleSheet)
        self.connect(self.moreButton, SIGNAL("released()"), self.changeButtonStyleSheet)
        self.orientationChanged()
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.videoinfo = None
        self.item_index = 0
        self.clearwidgets = False
        self.info = False
    """
    def takeScreenShot(self):
        file = "/home/user/MyDocs/.images/Screenshots/youtetube.png"
        QPixmap.grabWindow(QApplication.desktop().winId()).save(file, 'png')
    """
       
    def changeButtonStyleSheet(self):
        button = self.sender()
        if button.isDown():
            self.moreButton.setStyleSheet("font-size: 18px; border-radius: 4px; background-color: rgb(120, 120, 120, 150)")
        else:
            self.moreButton.setStyleSheet("font-size: 18px; border-radius: 4px; background-color: rgb(0, 0, 0, 100)")
            
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.moreButton.setGeometry(QRect(402, 670, 85, 80))
        else:
            self.moreButton.setGeometry(QRect(722, 352, 85, 80))

    def filterList(self, event):
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control):
            self.toolBar.setVisible(True)
            self.lineFilter.insert(event.text())
        if event.key() == Qt.Key_Backspace:
            self.lineFilter.backspace()
        for row in range(self.listWidget.count()):
            item = self.listWidget.item(row)
            itemWidget = self.listWidget.itemWidget(item)
            title = itemWidget.titleLabel.text()
            author = itemWidget.authorLabel.text()
            if not title.contains(self.lineFilter.text(), Qt.CaseInsensitive) and not author.contains(self.lineFilter.text(), Qt.CaseInsensitive):
                self.listWidget.setRowHidden(row, True)
            else:
                self.listWidget.setRowHidden(row, False)
            if self.lineFilter.text() == "":
                self.toolBar.setVisible(False)
        if event.key() == Qt.Key_Enter and self.lineFilter.text() != "":
            self.searchQuery(self.lineFilter.text(), "relevance")
            self.closeFilter()
            
    def closeFilter(self):
        self.lineFilter.setText("")
        for row in range(self.listWidget.count()):
            self.listWidget.setRowHidden(row, False)
        self.toolBar.setVisible(False)

    def toggleBusy(self, isBusy=False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
        self.loadingLabel.setVisible(isBusy)
        if not (self.info or isBusy):
            if self.yt.results == 0:
                QMaemo5InformationBox.information(self,  "No video found")
            self.info = True

    def addToQueue(self):
        row = self.listWidget.currentRow()
        video = self.yt.videoList[row]
        videoTitle = video.media.title.text
        try:
            youtubeservice.YouTubeQueueFeed.playlist.append(video)
            QMaemo5InformationBox.information(self, "\'%s\' added to your playback queue" % unicode(videoTitle, "utf-8"))
            queueLength = len(youtubeservice.YouTubeQueueFeed.playlist)
            self.queueChanged(queueLength)
        except:
            QMaemo5InformationBox.information(self, "Unable to add video to your playback queue")
        self.listWidget.setCurrentRow(-1)

    def playingVideo(self, event=None):
        row = self.listWidget.currentRow()
        self.videoinfo = self.yt.videoList[row]
        try:
            if self.videoPlaybackWindow.isPlaying():
                self.videoPlaybackWindow.close()
        except:
            pass
        
        try:
            self.toggleBusy(True)
            self.videoPlaybackWindow = VideoPlaybackWindow(self, video=self.videoinfo)
            self.connect(self.videoPlaybackWindow, SIGNAL("destroyed"), self.videoinfWindow)
        except:
            QMaemo5InformationBox.information(self, "Unable to play video")
        self.toggleBusy()

    def playingVideo1(self):
        try:
            if self.videoPlaybackWindow.isPlaying():
                self.videoPlaybackWindow.close()              
        except:
            pass
        
        try:
            self.videoPlaybackWindow = VideoPlaybackWindow(self, video=self.videoinfo)
            self.connect(self.videoPlaybackWindow, SIGNAL("destroyed"), self.videoinfWindow)
        except:
            QMaemo5InformationBox.information(self, "Unable to play video")

    def videoinfWindow(self):
        videoInfoWindow = VideoInfoWindow(self, self.videoinfo)
        self.connect(videoInfoWindow, SIGNAL("playingVideo"), self.playingVideo1)
        self.connect(videoInfoWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(videoInfoWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.listWidget.setCurrentRow(-1)
        self.actionPencil.setChecked(False)
        self.on_actionPencil_toggled(False)
        self.closeFilter()
        self.pencilList = []        
        
    def addToPlaylist(self):
        row = self.listWidget.currentRow()
        video = self.yt.videoList[row]
        addToPlaylistDialog = youtubedialogs.AddToPlaylistDialog(self, [video])
        self.listWidget.setCurrentRow(-1)

    def addToFavourites(self):
        row = self.listWidget.currentRow()
        video = self.yt.videoList[row]
        videoId = video.media.video_id.text
        try:
            addedToFavourites = youtubeservice.YouTubeDataService.addVideoToFavourites(videoId)
            if addedToFavourites:
                QMaemo5InformationBox.information(self, "\'%s\' has been added to your favourites" % unicode(video.title.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, addedToFavourites)
        except:
            QMaemo5InformationBox.information(self, "Unable to add video to your favourites")
        self.listWidget.setCurrentRow(-1)

    def confirmVideoDelete(self):
        self.row = self.listWidget.currentRow()
        self.video = self.yt.videoList[self.row]
        confirmDeleteDialog = youtubedialogs.ConfirmDeleteDialog(self, "%s" % self.video.media.title.text)
        self.connect(confirmDeleteDialog, SIGNAL("deleteConfirmed()"), self.deleteVideo)
        self.listWidget.setCurrentRow(-1)

    def deleteVideo(self):
        for link in self.video.link:
            if link.rel == "self":
                video_uri = link.href
        try:
            youtubeservice.YouTubeDataService.deleteVideo(video_uri)
            self.reloadData()
        except:
            QMaemo5InformationBox.information(self, "Unable to delete video from your channel")
        self.listWidget.setCurrentRow(-1)

    def loadData(self):
        self.listWidget.setFocus()
        try:
            self.yt.start()
        except:
            try:
                QMaemo5InformationBox.information(self, "Unable to connect to YouTube, please try again")
            except:
                pass
        
    def getMoreResults(self, scrollBarPos):
        if self.yt.isFinished() and self.yt.moreResults and scrollBarPos > (self.yt.results - 10) * 150:
            self.moreButton.setVisible(True)
        else:
            self.moreButton.setVisible(False)
            
    @pyqtSignature("")
    def on_moreButton_clicked(self):
        self.loadData()
        self.moreButton.setVisible(False)

    def reloadData(self):
        self.clearwidgets = True
        self.closeFilter()
        self.yt.resetResultCount()
        self.loadData()

    def addVideo(self, videoData):
        if self.clearwidgets:
            self.listWidget.clear()
            self.clearwidgets = False
        size = QSize()
        size.setHeight(140)
        item = QListWidgetItem(self.listWidget)
        item.setSizeHint(size)
        itemWidget = delegatewidgets.VideoItemWidget(self.listWidget, videoData)
        self.item_index += 1
        if self.item_index % 2 == 0:
            itemWidget.setStyleSheet("background-color: rgb(64, 64, 64, 100);")
        if self.actionPencil.isChecked():
            itemWidget.showCheckBox()
            item.setFlags(Qt.ItemIsEnabled)
        self.listWidget.addItem(item)
        self.listWidget.setItemWidget(item, itemWidget)
        title = itemWidget.titleLabel.text()
        author = itemWidget.authorLabel.text()
        if not title.contains(self.lineFilter.text(), Qt.CaseInsensitive) and not author.contains(self.lineFilter.text(), Qt.CaseInsensitive):
            self.listWidget.setItemHidden(item, True)
        if not self.info:
            self.info = True
                
    def addVideoThumbnail(self, videoData):
        row, thumbnail = videoData
        item = self.listWidget.item(row)
        thumbLabel = self.listWidget.itemWidget(item).thumbLabel
        try:
            thumbLabel.setPixmap(thumbnail)
            thumbLabel.mouseReleaseEvent = self.playingVideo
        except:
            thumbLabel.setPixmap(QPixmap(":/images/ui-images/thumbnail.png"))

    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        if self.actionPencil.isChecked():
            checkBox = self.listWidget.itemWidget(item).checkBox
            checkBox.toggle()
            if checkBox.isChecked():
                self.pencilList.append(self.listWidget.row(item))
                self.actionPencilQueue.setVisible(True)
                self.actionPencilDownloads.setVisible(True)
                if youtubeservice.YouTubeDataService.currentUser != "":
                    self.actionPencilPlaylist.setVisible(True)
                    self.actionPencilFavourites.setVisible(True)
            else:
                self.pencilList.remove(self.listWidget.row(item))
                if len(self.pencilList) == 0:
                    self.actionPencilQueue.setVisible(False)
                    self.actionPencilDownloads.setVisible(False)
                    self.actionPencilPlaylist.setVisible(False)
                    self.actionPencilFavourites.setVisible(False)           
        else:
            row = self.listWidget.row(item)
            self.videoinfo = self.yt.videoList[row]
            videoInfoWindow = VideoInfoWindow(self, self.videoinfo)
            self.connect(videoInfoWindow, SIGNAL("playingVideo"), self.playingVideo1)
            self.connect(videoInfoWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
            self.connect(videoInfoWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
            self.listWidget.setCurrentRow(-1)
            self.actionPencil.setChecked(False)
            self.on_actionPencil_toggled(False)
            self.closeFilter()
            self.pencilList = []            
        
    @pyqtSignature("")
    def on_actionSubscribe_triggered(self):
        try:
            subscribed = youtubeservice.YouTubeDataService.addSubscription(self.username)
            if subscribed == True:
                QMaemo5InformationBox.information(self, "You have subscribed to \'%s\'!" % unicode(self.username, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, subscribed)
        except:
            QMaemo5InformationBox.information(self, "Unable to add subscription")
        
    @pyqtSignature("")
    def on_actionSearch_triggered(self):
        searchDialog = youtubedialogs.SearchDialog(self)

    @pyqtSignature("")
    def on_actionNewSubscriptionVideos_triggered(self):
        newSubscriptionVideosWindow = YoutubeWindow(self, subscribed=True)

    @pyqtSignature("")
    def on_actionAddComment_triggered(self):
        addCommentDialog = youtubedialogs.AddCommentDialog(self, self.video)
        self.connect(addCommentDialog, SIGNAL("accepted()"), self.reloadData)

    @pyqtSignature("")
    def on_actionGoToQueue_triggered(self):
        playbackQueueWindow = PlaybackQueueWindow(self)
        self.connect(playbackQueueWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(playbackQueueWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.actionPencil.setChecked(False)
        self.on_actionPencil_toggled(False)
        
    @pyqtSignature("")
    def on_actionDownloads_triggered(self):
        downloadsWindow = DownloadsWindow(self)
        self.connect(downloadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.connect(downloadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.actionPencil.setChecked(False)
        self.on_actionPencil_toggled(False)

    @pyqtSignature("bool")
    def on_actionPencil_toggled(self, isChecked):
        if isChecked:
            for row in range(self.listWidget.count()):
                item = self.listWidget.item(row)
                item.setFlags(Qt.ItemIsEnabled)
                widget = self.listWidget.itemWidget(item)
                widget.showCheckBox()
        else:
            self.actionPencilQueue.setVisible(False)
            self.actionPencilDownloads.setVisible(False)
            self.actionPencilPlaylist.setVisible(False)
            self.actionPencilFavourites.setVisible(False)
            for row in range(self.listWidget.count()):
                item = self.listWidget.item(row)
                item.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
                widget = self.listWidget.itemWidget(item)
                widget.hideCheckBox()
            self.listWidget.setCurrentRow(-1)

    @pyqtSignature("")
    def on_actionPencilQueue_triggered(self):
        try:
            for row in self.pencilList:  
                video = self.yt.videoList[row]              
                youtubeservice.YouTubeQueueFeed.playlist.append(video)
            QMaemo5InformationBox.information(self, "Your chosen videos have been added to your playback queue")
            queueLength = len(youtubeservice.YouTubeQueueFeed.playlist)
            self.queueChanged(queueLength)
        except:
            QMaemo5InformationBox.information(self, "Unable to add videos to your playback queue")
        self.actionPencil.toggle()
            
    @pyqtSignature("")
    def on_actionPencilDownloads_triggered(self):
        try:
            for row in self.pencilList:  
                video = self.yt.videoList[row]              
                youtubeservice.YouTubeVideoDownloader.addTask(video)
            QMaemo5InformationBox.information(self, "Your chosen videos have been added to your download queue")
            taskQueueLength = len(youtubeservice.YouTubeVideoDownloader.taskQueue)
            self.downloadsChanged(taskQueueLength)
        except:
            QMaemo5InformationBox.information(self, "Unable to add videos to your download queue")
        self.actionPencil.toggle()

    @pyqtSignature("")
    def on_actionPencilPlaylist_triggered(self):
        videoList = []
        for row in self.pencilList:          
            videoList.append(self.yt.videoList[row])
        addToPlaylistDialog = youtubedialogs.AddToPlaylistDialog(self, videoList)
        self.actionPencil.toggle()

    @pyqtSignature("")
    def on_actionPencilFavourites_triggered(self):
        try:
            self.toggleBusy(True)
            for row in self.pencilList:
                videoId = self.yt.videoList[row].media.video_id.text
                youtubeservice.YouTubeDataService.addVideoToFavourites(videoId)
            QMaemo5InformationBox.information(self, "Your chosen videos have been added to your favourites")
        except:
            QMaemo5InformationBox.information(self, "Unable to add videos to your favourites")
        self.toggleBusy()
        self.actionPencil.toggle()

    def queueChanged(self, queueLength):
        if queueLength > 0:
            self.actionGoToQueue.setVisible(True)
            self.actionGoToQueue.setText("Queue (%d videos)" % queueLength)
        else:
            self.actionGoToQueue.setVisible(False)
        self.emit(SIGNAL("queueChanged(int)"), queueLength)
        
    def downloadsChanged(self,  taskQueueLength):
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%d videos)" % taskQueueLength)
        else:
            self.actionDownloads.setVisible(False)
        self.emit(SIGNAL("downloadsChanged(int)"), taskQueueLength)
 

class YoutubeWindow(YoutubeWindows):
    def __init__(self, parent,  searchString="", searchOrder="relevance", username=None, subscribed = False):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("Most Recent")
        self.actionPlaying.setVisible(True)
        self.actionAddToQueue.setVisible(True)
        if youtubeservice.YouTubeDataService.currentUser != "":
            self.actionAddToFavourites.setVisible(True)
            self.actionAddToPlaylist.setVisible(True)
        self.actionPencil.setVisible(True)
        self.pencilList = []
        self.tline = "?time=today"
        self.feedType = "most_viewed"
        self.show()
        self.showfeedMenus(True)
        self.showtimePushbutton()
        self.showsearchPushbutton()
        self.searchOrderList= ["relevance", "published", "viewCount", "rating"]
        self.timePushButtonToggled(0)
        self.searchPushButtonToggled(self.searchOrderList.index(searchOrder))

        if not searchString == "":
            self.searchQuery(searchString, searchOrder, username)
        elif subscribed:
            self.showLatest()
        else:                        
            self.switchFT()
            self.showtimePushbutton(True)

    def showLatest(self):
        self.setWindowTitle("Latest Subscription Videos")
        try:
            QMaemo5InformationBox.information(self, "Showing latest videos from your subscriptions")
        except:
            pass
        self.videoFeed = "http://gdata.youtube.com/feeds/api/users/default/newsubscriptionvideos"        
        self.connectyt()

    def searchQuery(self, searchString="", searchOrder="relevance", username=None):
        if not searchString == "":
            self.searchPushButtonToggled(self.searchOrderList.index(searchOrder))
            self.showsearchPushbutton(True)
            self.setWindowTitle("Search Results")
            self.showtimePushbutton()
            self.searchString = searchString
            self.info = False
            searchTerms = self.searchString.replace(" ", "+")
            if username == None:
                self.videoFeed = "http://gdata.youtube.com/feeds/api/videos?q=%s&safeSearch=none&orderby=%s" % (searchTerms, searchOrder)
            else:
                self.videoFeed = "http://gdata.youtube.com/feeds/api/videos?author=%s&q=%s&safeSearch=none&orderby=%s" % (username, searchTerms, searchOrder)
            self.connectyt()

    def showsearchPushbutton(self, a=False):        
        for b in (self.searchPushButton, self.searchPushButton1, self.searchPushButton2, self.searchPushButton3):
            b.setVisible(a)
            
    def searchPushButtonToggled(self, a):
        i = 0
        for button in (self.searchPushButton, self.searchPushButton1, self.searchPushButton2, self.searchPushButton3):
            if i == a:    
                button.setStyleSheet("margin: 8px 0 0 0; border-radius: 3px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4ABEFF, stop: 0.8 #000000);")
            else:
                button.setStyleSheet("border: 1px solid rgb(120, 120, 120); margin: 8px 0 0 0; border-radius: 3px;")
            i += 1        

    def showfeedMenus(self, a=False):        
        for b in (self.switchFeed, self.switchFeed1, self.switchFeed2, self.switchFeed3,
                  self.switchFeed4, self.switchFeed5, self.switchFeed6, self.switchFeed7, self.switchFeed8):
            b.setVisible(a)        

    def showtimePushbutton(self, a=False):        
        for b in (self.timePushButton, self.timePushButton1, self.timePushButton2, self.timePushButton3):
            b.setVisible(a)

    def timePushButtonToggled(self, a):
        i = 0
        for button in (self.timePushButton, self.timePushButton1, self.timePushButton2, self.timePushButton3):
            if i == a:    
                button.setStyleSheet("margin: 8px 0 0 0; border-radius: 3px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4ABEFF, stop: 0.8 #000000);")
            else:
                button.setStyleSheet("border: 1px solid rgb(120, 120, 120); margin: 8px 0 0 0; border-radius: 3px;")
            i += 1

    @pyqtSignature("")
    def on_searchPushButton_clicked(self):
        self.searchQuery(self.searchString, "relevance")
        self.searchPushButtonToggled(0)

    @pyqtSignature("")   
    def on_searchPushButton1_clicked(self):
        self.searchQuery(self.searchString, "published")
        self.searchPushButtonToggled(1)

    @pyqtSignature("")   
    def on_searchPushButton2_clicked(self):
        self.searchQuery(self.searchString, "viewCount")
        self.searchPushButtonToggled(2)

    @pyqtSignature("")   
    def on_searchPushButton3_clicked(self):
        self.searchQuery(self.searchString, "rating")
        self.searchPushButtonToggled(3)
            
    @pyqtSignature("")
    def on_timePushButton_clicked(self):
        self.tline = "?time=today"
        self.switchFT()
        self.timePushButtonToggled(0)

    @pyqtSignature("")   
    def on_timePushButton1_clicked(self):
        self.tline = "?time=this_week"
        self.switchFT()
        self.timePushButtonToggled(1)

    @pyqtSignature("")   
    def on_timePushButton2_clicked(self):
        self.tline = "?time=this_month"
        self.switchFT()
        self.timePushButtonToggled(2)

    @pyqtSignature("")   
    def on_timePushButton3_clicked(self):
        self.tline = "?time=all_time"
        self.switchFT()
        self.timePushButtonToggled(3)

    @pyqtSignature("")
    def on_switchFeed_triggered(self):
        self.feedType = "top_rated"
        self.switchFT()
        self.showtimePushbutton(True)

    @pyqtSignature("")
    def on_switchFeed1_triggered(self):
        self.showtimePushbutton()
        self.tlinerecord = self.tline
        self.tline = ""
        self.feedType = "recently_featured"
        self.switchFT()
        self.tline = self.tlinerecord

    @pyqtSignature("")
    def on_switchFeed2_triggered(self):
        self.feedType = "most_discussed"
        self.switchFT()
        self.showtimePushbutton(True)

    @pyqtSignature("")
    def on_switchFeed3_triggered(self):
        self.feedType = "top_favorites"
        self.switchFT()
        self.showtimePushbutton(True)
        
    @pyqtSignature("")
    def on_switchFeed4_triggered(self):
        self.feedType = "most_responded"
        self.switchFT()
        self.showtimePushbutton(True)

    @pyqtSignature("")
    def on_switchFeed5_triggered(self):
        self.feedType = "most_recent"
        self.showtimePushbutton()
        self.tlinerecord = self.tline
        self.tline = ""
        self.switchFT()
        self.tline = self.tlinerecord
        
    @pyqtSignature("")
    def on_switchFeed6_triggered(self):
        self.feedType = "most_viewed"
        self.switchFT()
        self.showtimePushbutton(True)

    @pyqtSignature("")
    def on_switchFeed7_triggered(self):
        self.feedType = "most_shared"
        self.showtimePushbutton()
        self.tlinerecord = self.tline
        self.tline = ""
        self.switchFT()
        self.tline = self.tlinerecord

    @pyqtSignature("")
    def on_switchFeed8_triggered(self):
        self.feedType = "on_the_web"
        self.showtimePushbutton()
        self.tlinerecord = self.tline
        self.tline = ""
        self.switchFT()
        self.tline = self.tlinerecord

    def switchFT(self):
        feedTypes = { "most_viewed": "Most Viewed", "top_rated": "Top Rated",
                      "recently_featured": "Recently Featured", "most_discussed": "Most Discussed",
                      "top_favorites": "Top Favorites", "most_responded": "Most Responded",
                      "most_recent": "Most Recent", "most_shared": "Most Shared", "on_the_web": "Trending Videos" }
        self.showsearchPushbutton()
        self.setWindowTitle(feedTypes[self.feedType])
        location = YouTubeAPISettings.locationFilter
        category = YouTubeAPISettings.categoryFilter
        self.videoFeed = "http://gdata.youtube.com/feeds/api/standardfeeds/%s%s%s%s" % (location, self.feedType, category, self.tline)
        self.connectyt()

    def connectyt(self):
        self.yt = youtubeservice.YouTubeVideoFeed(self, self.videoFeed)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)
        self.connect(self.listWidget.verticalScrollBar(), SIGNAL("valueChanged(int)"), self.getMoreResults)
        self.reloadData()
        # QTimer.singleShot(9000, self.takeScreenShot)

class UploadsWindow(YoutubeWindows):
    def __init__(self, parent):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("My Uploads")
        self.actionSearch.setVisible(True)
        self.actionSearch.setText("Search my uploads")
        self.actionPlaying.setVisible(True)
        self.actionAddToQueue.setVisible(True)
        self.actionAddToFavourites.setVisible(True)
        self.actionAddToPlaylist.setVisible(True)
        self.actionDeleteVideo.setVisible(True)
        self.actionPencil.setVisible(True)
        self.pencilList = []
        self.show()
        self.videoFeed = "http://gdata.youtube.com/feeds/api/users/default/uploads"
        self.yt = youtubeservice.YouTubeVideoFeed(self, self.videoFeed)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)  
        self.connect(self.listWidget.verticalScrollBar(), SIGNAL("valueChanged(int)"), self.getMoreResults)      
        self.loadData()
        
    @pyqtSignature("")
    def on_actionSearch_triggered(self):
        currentUser = unicode(youtubeservice.YouTubeDataService.currentUser) # currentUser is a QString - YouTube API requires unicode.
        searchDialog = youtubedialogs.SearchDialog(self,  currentUser)

class UserWindow(YoutubeWindows):
    def __init__(self, parent, username, subscribed = False):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("%s\'s Videos" % username)
        self.username = username
        if not subscribed:
            self.actionSubscribe.setVisible(True)
            self.actionSubscribe.setText("Subscribe to \'%s\'" % unicode(self.username, "utf-8"))
        self.actionSearch.setVisible(True)
        self.actionSearch.setText("Search user's videos")
        self.actionPlaying.setVisible(True)
        self.actionAddToQueue.setVisible(True)
        if youtubeservice.YouTubeDataService.currentUser != "":
            self.actionAddToFavourites.setVisible(True)
            self.actionAddToPlaylist.setVisible(True)
        self.actionPencil.setVisible(True)
        self.pencilList = []
        self.show()
        self.videoFeed = "http://gdata.youtube.com/feeds/api/users/%s/uploads" % self.username
        self.yt = youtubeservice.YouTubeVideoFeed(self, self.videoFeed)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)
        self.connect(self.listWidget.verticalScrollBar(), SIGNAL("valueChanged(int)"), self.getMoreResults)
        self.loadData()
        
    @pyqtSignature("")
    def on_actionSearch_triggered(self):
        searchDialog = youtubedialogs.SearchDialog(self,  self.username)

class RelatedVideosWindow(YoutubeWindows):
    def __init__(self, parent, video):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("Related Videos")
        self.actionPlaying.setVisible(True)
        self.actionAddToQueue.setVisible(True)
        if youtubeservice.YouTubeDataService.currentUser != "":
            self.actionAddToFavourites.setVisible(True)
            self.actionAddToPlaylist.setVisible(True)
        self.actionPencil.setVisible(True)
        self.video = video
        self.pencilList = []
        self.show()
        for link in video.link:
            if link.rel.split("#")[-1] == "video.related":
                self.videoFeed = link.href
        self.yt = youtubeservice.YouTubeVideoFeed(self, self.videoFeed)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)        
        self.connect(self.listWidget.verticalScrollBar(), SIGNAL("valueChanged(int)"), self.getMoreResults)
        self.loadData()

class FavouritesWindow(YoutubeWindows):
    def __init__(self, parent):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("My Favourites")
        self.actionPlaying.setVisible(True)
        self.actionAddToQueue.setVisible(True)
        self.actionAddToPlaylist.setVisible(True)
        self.actionRemoveFromFavourites.setVisible(True)
        self.actionPencil.setVisible(True)
        self.actionPencilFavourites.setVisible(False)
        self.connect(self.actionRemoveFromFavourites, SIGNAL("triggered()"), self.removeFromFavourites)        
        self.pencilList = []
        self.show()
        self.videoFeed = "http://gdata.youtube.com/feeds/api/users/default/favorites"
        self.yt = youtubeservice.YouTubeVideoFeed(self, self.videoFeed)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy) 
        self.connect(self.listWidget.verticalScrollBar(), SIGNAL("valueChanged(int)"), self.getMoreResults)
        self.loadData()

    def removeFromFavourites(self):
        row = self.listWidget.currentRow()
        video = self.yt.videoList[row]
        videoId = video.media.video_id.text
        try:
            removedFromFavourites = youtubeservice.YouTubeDataService.removeVideoFromFavourites(videoId)
            if removedFromFavourites == True:
                self.reloadData()
                QMaemo5InformationBox.information(self, "\'%s\' has been removed from your favourites" % unicode(video.media.title.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, removedFromFavourites)
        except:
            QMaemo5InformationBox.information(self, "Unable to remove video from your favourites")
        self.listWidget.setCurrentRow(-1)

class PlaylistsWindow(YoutubeWindows):
    def __init__(self, parent):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("My Playlists")
        self.actionNewPlaylist.setVisible(True)
        self.actionEditPlaylist.setVisible(True)
        self.actionDeletePlaylist.setVisible(True)
        self.connect(self.actionEditPlaylist, SIGNAL("triggered()"), self.editPlaylist)
        self.connect(self.actionDeletePlaylist, SIGNAL("triggered()"), self.deletePlaylist)        
        self.show()
        self.yt = youtubeservice.YouTubePlaylistFeed(self)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.loadPlaylists)
        self.loadData()
        self.toggleBusy(True)

    def filterList(self, event):
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control):
            self.toolBar.setVisible(True)
            self.lineFilter.insert(event.text())
        if event.key() == Qt.Key_Backspace:
            self.lineFilter.backspace()
        for row in range(self.listWidget.count()):
            if not self.listWidget.item(row).text().contains(self.lineFilter.text(), Qt.CaseInsensitive):
                self.listWidget.setRowHidden(row, True)
            else:
                self.listWidget.setRowHidden(row, False)
        if self.lineFilter.text() == "":
            self.toolBar.setVisible(False)

    def loadPlaylists(self, playlists):
        for playlist in playlists:
            item = QListWidgetItem("%s" % unicode(playlist.title.text, "utf-8"))
            item.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.listWidget.addItem(item)
        self.toggleBusy()

    def editPlaylist(self):
        row = self.listWidget.currentRow()
        playlist = self.yt.playlistFeed.entry[row]
        editPlaylistDialog = youtubedialogs.EditPlaylistDialog(self, playlist)
        self.listWidget.setCurrentRow(-1)
        self.connect(editPlaylistDialog, SIGNAL("accepted()"), self.reloadData)

    def deletePlaylist(self):
        row = self.listWidget.currentRow()
        playlist = self.yt.playlistFeed.entry[row]
        playlistId = playlist.playlist_id.text
        try:
            playlistDeleted = youtubeservice.YouTubeDataService.deletePlaylist(playlistId)
            if playlistDeleted == True:
                self.listWidget.setRowHidden(row, True)
                QMaemo5InformationBox.information(self, "Your playlist: \'%s\' has been deleted" % unicode(playlist.title.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, playlistDeleted)
        except:
            QMaemo5InformationBox.information(self, "Unable to delete your playlist")
        self.listWidget.setCurrentRow(-1)
        
    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        row = self.listWidget.row(item)
        playlistName = self.yt.playlistFeed.entry[row].title.text
        playlistId = self.yt.playlistFeed.entry[row].playlist_id.text
        playlistVideosWindow = PlaylistVideosWindow(self, playlistName, playlistId)
        self.connect(playlistVideosWindow,  SIGNAL("queueChanged(int)"),  self.queueChanged)
        self.connect(playlistVideosWindow,  SIGNAL("downloadsChanged(int)"),  self.downloadsChanged)
        self.listWidget.setCurrentRow(-1) 
        self.closeFilter()

    @pyqtSignature("")
    def on_actionNewPlaylist_triggered(self):
        newPlaylistDialog = youtubedialogs.NewPlaylistDialog(self)
        self.connect(newPlaylistDialog, SIGNAL("accepted()"), self.reloadData)
        
    @pyqtSignature("")
    def on_actionGoToQueue_triggered(self):
        playbackQueueWindow = PlaybackQueueWindow(self)
        self.connect(playbackQueueWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(playbackQueueWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        
    @pyqtSignature("")
    def on_actionDownloads_triggered(self):
        downloadsWindow = DownloadsWindow(self)
        self.connect(downloadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.connect(downloadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)

class PlaylistVideosWindow(YoutubeWindows):
    def __init__(self, parent, playlistName, playlistId):
        YoutubeWindows.__init__(self, parent)
        self.playlistName = playlistName
        self.playlistId = playlistId
        self.setWindowTitle(self.playlistName)
        self.actionPlayPlaylist.setVisible(True)
        self.actionSearch.setVisible(True)
        self.actionSearch.setText("Find more of \'%s\'" % self.playlistName)
        self.actionPlaying.setVisible(True)
        self.actionAddToQueue.setVisible(True)
        self.actionAddToFavourites.setVisible(True)
        self.actionAddToPlaylist.setVisible(True)
        self.actionRemoveFromPlaylist.setVisible(True)
        self.actionPencil.setVisible(True)
        self.connect(self.actionRemoveFromPlaylist, SIGNAL("triggered()"), self.removeFromPlaylist)
        self.pencilList = []
        self.show()
        self.videoFeed = "http://gdata.youtube.com/feeds/api/playlists/%s" % playlistId
        self.yt = youtubeservice.YouTubeVideoFeed(self, self.videoFeed)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)
        self.connect(self.listWidget.verticalScrollBar(), SIGNAL("valueChanged(int)"), self.getMoreResults)
        self.loadData()

    def addToPlaylist(self):
        row = self.listWidget.currentRow()
        video = self.yt.videoList[row]
        addToPlaylistDialog = youtubedialogs.AddToPlaylistDialog(self, video)
        self.listWidget.setCurrentRow(-1)

    def removeFromPlaylist(self):
        row = self.listWidget.currentRow()
        video = self.yt.videoList[row]
        videoId = self.yt.videoList[row].id.text.split(":")[-1]
        try:
            removedFromPlaylist = youtubeservice.YouTubeDataService.removeVideoFromPlaylist(self.playlistId, videoId)
            if removedFromPlaylist == True:
                self.reloadData()
                QMaemo5InformationBox.information(self, "\'%s\' has been removed from your playlist" % unicode(video.media.title.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, removedFromPlaylist)
        except:
            QMaemo5InformationBox.information(self, "Unable to remove video from your playlist")
        self.listWidget.setCurrentRow(-1)

    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        if self.actionPencil.isChecked():
            checkBox = self.listWidget.itemWidget(item).checkBox
            checkBox.toggle()
            if checkBox.isChecked():
                self.pencilList.append(self.listWidget.row(item))
                self.actionPencilQueue.setVisible(True)
                self.actionPencilDownloads.setVisible(True)
                self.actionPencilPlaylist.setVisible(True)
                self.actionPencilFavourites.setVisible(True)
            else:
                self.pencilList.remove(self.listWidget.row(item))
                if len(self.pencilList) == 0:
                    self.actionPencilQueue.setVisible(False)
                    self.actionPencilDownloads.setVisible(False)
                    self.actionPencilPlaylist.setVisible(False)
                    self.actionPencilFavourites.setVisible(False)           
        else:
            row = self.listWidget.currentRow()
            self.videoinfo = self.yt.videoList[row]
            position = row + 1
            count = len(self.yt.videoList)
            videoInfoWindow = VideoInfoWindow(self, self.videoinfo, self.playlistId, position, count)
            self.connect(videoInfoWindow, SIGNAL("playingVideo"), self.playingVideo1)
            self.connect(videoInfoWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
            self.connect(videoInfoWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
            self.listWidget.setCurrentRow(-1)
            self.actionPencil.setChecked(False)
            self.on_actionPencil_toggled(False)
            self.pencilList = []
            self.closeFilter()

    @pyqtSignature("")
    def on_actionSearch_triggered(self):
        searchOrder = "published"
        findMoreWindow = YoutubeWindow(self, self.playlistName,  searchOrder)
        
    @pyqtSignature("")
    def on_actionPlayPlaylist_triggered(self):
        try:
            if self.videoPlaybackWindow.isPlaying():
                self.videoPlaybackWindow.close()
        except:
            pass
        
        try:
            self.videoPlaybackWindow = VideoPlaybackWindow(self, playlist = self.yt.videoList)
            self.connect(self.videoPlaybackWindow, SIGNAL("destroyed"), self.videoinfWindow)
        except:
            QMaemo5InformationBox.information(self, "Unable to play playlist")

class PlaybackQueueWindow(YoutubeWindows):
    def __init__(self, parent):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("My Playback Queue")
        self.actionPlayQueue.setVisible(True)
        self.actionClearQueue.setVisible(True)
        if youtubeservice.YouTubeDataService.currentUser != "":
            self.actionSaveQueue.setVisible(True)
            self.actionAddToFavourites.setVisible(True)
            self.actionAddToPlaylist.setVisible(True)
        self.actionRemoveFromQueue.setVisible(True)
        self.actionGoToQueue.setVisible(False)
        self.connect(self.actionRemoveFromQueue, SIGNAL("triggered()"), self.removeFromQueue)
        self.show()
        self.yt = youtubeservice.YouTubeQueueFeed(self)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)
        self.loadData()
        
    def addVideo(self, videoData):
        size = QSize()
        size.setHeight(140)
        item = QListWidgetItem()
        item.setSizeHint(size)
        itemWidget = delegatewidgets.VideoItemWidget(self.listWidget, videoData)
        self.listWidget.addItem(item)
        self.listWidget.setItemWidget(item, itemWidget)
        title = itemWidget.titleLabel.text()
        author = itemWidget.authorLabel.text()
        if not title.contains(self.lineFilter.text(), Qt.CaseInsensitive) and not author.contains(self.lineFilter.text(), Qt.CaseInsensitive):
                self.listWidget.setItemHidden(item, True)
        
    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        row = self.listWidget.row(item)
        self.videoinfo = youtubeservice.YouTubeQueueFeed.playlist[row]
        videoInfoWindow = VideoInfoWindow(self, self.videoinfo)
        self.connect(videoInfoWindow, SIGNAL("playingVideo"), self.playingVideo1)
        self.connect(videoInfoWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.listWidget.setCurrentRow(-1)
        self.closeFilter()            

    def queueChanged(self, queueLength):
        pass

    def addToPlaylist(self):
        row = self.listWidget.currentRow()
        video = youtubeservice.YouTubeQueueFeed.playlist[row]
        addToPlaylistDialog = youtubedialogs.AddToPlaylistDialog(self, [video])
        self.listWidget.setCurrentRow(-1)

    def addToFavourites(self):
        row = self.listWidget.currentRow()
        video = youtubeservice.YouTubeQueueFeed.playlist[row]
        videoId = video.media.video_id.text
        try:
            addedToFavourites = youtubeservice.YouTubeDataService.addVideoToFavourites(videoId)
            if addedToFavourites == True:
                QMaemo5InformationBox.information(self, "\'%s\' has been added to your favourites" % unicode(video.title.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, addedToFavourites)
        except:
            QMaemo5InformationBox.information(self, "Unable to add video to your favourites")
        self.listWidget.setCurrentRow(-1)

    def removeFromQueue(self):
        row = self.listWidget.currentRow()
        video = youtubeservice.YouTubeQueueFeed.playlist[row]
        videoTitle = video.media.title.text
        try:
            youtubeservice.YouTubeQueueFeed.playlist.remove(video)
            self.listWidget.setRowHidden(row, True)
            QMaemo5InformationBox.information(self, "\'%s\' has been removed from your playback queue" % unicode(videoTitle, "utf-8"))
            queueLength = len(youtubeservice.YouTubeQueueFeed.playlist)
            if queueLength == 0:
                self.actionClearQueue.setVisible(False)
                self.actionSaveQueue.setVisible(False)
                self.actionPlayQueue.setVisible(False)
            self.emit(SIGNAL("queueChanged(int)"), queueLength)
        except:
            QMaemo5InformationBox.information(self, "Unable to remove video from your playback queue")
        self.listWidget.setCurrentRow(-1)
        
    @pyqtSignature("")
    def on_actionPlayQueue_triggered(self):
        try:
            if self.videoPlaybackWindow.isPlaying():
                self.videoPlaybackWindow.close()
        except:
            pass
        
        try:
            playlist = youtubeservice.YouTubeQueueFeed.playlist
            self.videoPlaybackWindow = VideoPlaybackWindow(self, playlist = playlist)
            self.connect(self.videoPlaybackWindow, SIGNAL("destroyed"), self.videoinfWindow)
        except:
            QMaemo5InformationBox.information(self, "Unable to play your playback queue")

    @pyqtSignature("")
    def on_actionClearQueue_triggered(self):
        try:
            youtubeservice.YouTubeQueueFeed.playlist = []
            self.listWidget.clear()
            QMaemo5InformationBox.information(self, "Your playback queue has been cleared")
            self.actionClearQueue.setVisible(False)
            self.actionSaveQueue.setVisible(False)
            self.actionPlayQueue.setVisible(False)
            queueLength = len(youtubeservice.YouTubeQueueFeed.playlist)
            self.emit(SIGNAL("queueChanged(int)"), queueLength)
        except:
            QMaemo5InformationBox.information(self, "Unable to clear your playback queue")

    @pyqtSignature("")
    def on_actionSaveQueue_triggered(self):
        videoQueue = youtubeservice.YouTubeQueueFeed.playlist
        saveQueueAsPlaylistDialog = youtubedialogs.NewPlaylistDialog(self, videoQueue)


class SubscriptionsWindow(YoutubeWindows):
    def __init__(self, parent):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("My Subscriptions")
        self.actionUnsubscribe.setVisible(True)
        self.actionNewSubscriptionVideos.setVisible(True)
        self.connect(self.actionUnsubscribe, SIGNAL("triggered()"), self.removeSubscription)
        self.show()
        self.yt = youtubeservice.YouTubeSubscriptionsFeed(self)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.loadSubscriptions)
        self.loadData()    
        self.toggleBusy(True)

    def removeSubscription(self):
        row = self.listWidget.currentRow()
        subscription = self.yt.subscriptionsFeed.entry[row]
        for link in subscription.link:
            if link.rel == "self":
                subscription_uri = link.href
        try:
            unsubscribed = youtubeservice.YouTubeDataService.removeSubscription(subscription_uri)
            if unsubscribed == True:
                self.listWidget.setRowHidden(row, True)
                QMaemo5InformationBox.information(self, "You have unsubscribed to \'%s\'" % unicode(subscription.username.text, "utf-8"))
            else:
                QMaemo5InformationBox.information(self, unsubscribed) 
        except:
            QMaemo5InformationBox.information(self, "Unable to remove your subscription")    
        self.listWidget.setCurrentRow(-1)

    def filterList(self, event):
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control):
            self.toolBar.setVisible(True)
            self.lineFilter.insert(event.text())
        if event.key() == Qt.Key_Backspace:
            self.lineFilter.backspace()
        for row in range(self.listWidget.count()):
            if not self.listWidget.item(row).text().contains(self.lineFilter.text(), Qt.CaseInsensitive):
                self.listWidget.setRowHidden(row, True)
            else:
                self.listWidget.setRowHidden(row, False)
        if self.lineFilter.text() == "":
            self.toolBar.setVisible(False) 

    def loadSubscriptions(self, subscriptionsList):
        for subscription in subscriptionsList:
            item = QListWidgetItem(subscription.username.text)
            item.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.listWidget.addItem(item)
        self.toggleBusy()

    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        row = self.listWidget.row(item)
        subscriptionName = self.yt.subscriptionsFeed.entry[row].username.text
        subscriptionVideosWindow = UserWindow(self, subscriptionName, True)
        self.connect(subscriptionVideosWindow,  SIGNAL("queueChanged(int)"),  self.queueChanged)
        self.connect(subscriptionVideosWindow,  SIGNAL("downloadsChanged(int)"),  self.downloadsChanged)
        self.listWidget.setCurrentRow(-1) 
        self.closeFilter()
        
    @pyqtSignature("")
    def on_actionGoToQueue_triggered(self):
        playbackQueueWindow = PlaybackQueueWindow(self)
        self.connect(playbackQueueWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(playbackQueueWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        
    @pyqtSignature("")
    def on_actionDownloads_triggered(self):
        downloadsWindow = DownloadsWindow(self)
        self.connect(downloadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        self.connect(downloadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)

class DownloadsWindow(YoutubeWindows):
    def __init__(self, parent):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("Downloads")
        self.actionRemoveFromQueue.setVisible(True)
        self.actionRemoveFromQueue.setText("Cancel download")
        self.actionClearQueue.setVisible(True)
        self.actionClearQueue.setText("Clear downloads")
        self.actionPauseDownload.setVisible(True)
        self.actionResumeDownload.setVisible(True)
        self.actionDownloads.setVisible(False)
        self.actionGoToQueue.setVisible(False)
        self.actionResumeDownloads.setVisible(True)
        self.actionPauseDownloads.setVisible(True)
        self.filterGroup = QActionGroup(self)
        self.filterGroup.setExclusive(True)
        self.actionQueued = QAction("Current", self.filterGroup)
        self.actionQueued.setCheckable(True)
        self.actionQueued.setChecked(False)
        self.actionAll = QAction("All", self.filterGroup)
        self.actionAll.setCheckable(True)
        self.actionAll.setChecked(True)
        self.actionCompleted = QAction("Completed", self.filterGroup)
        self.actionCompleted.setCheckable(True)
        self.actionCompleted.setChecked(False)
        self.menuMenu.addActions(self.filterGroup.actions())
        self.connect(self.filterGroup, SIGNAL("selected(QAction*)"), self.filterDownloads)
        self.connect(self.actionRemoveFromQueue,  SIGNAL("triggered()"),  self.cancelDownload)
        self.connect(self.actionPauseDownload,  SIGNAL("triggered()"),  self.pauseDownload)
        self.connect(self.actionResumeDownload,  SIGNAL("triggered()"),  self.resumeDownload)
        self.show()
        self.yt = youtubeservice.YouTubeDownloadQueueFeed(self)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.addVideo)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.addVideoThumbnail)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.toggleBusy)
        self.loadData()
        for task in youtubeservice.YouTubeVideoDownloader.taskQueue:
            self.connect(task, SIGNAL("downloadUpdated()"), self.updateDownloadStatus)
            self.connect(task, SIGNAL("statusChanged()"), self.updateTaskStatus)
            
    def filterDownloads(self, filter):
        if filter is self.actionAll:
            for row in range(self.listWidget.count()):
                self.listWidget.setRowHidden(row, False)
        elif filter is self.actionQueued:
            for row in range(self.listWidget.count()):
                task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
                if task.getStatus() == "completed":
                    self.listWidget.setRowHidden(row, True)
                else:
                    self.listWidget.setRowHidden(row, False)
        else:
            for row in range(self.listWidget.count()):
                task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
                if task.getStatus() == "completed":
                    self.listWidget.setRowHidden(row, False)
                else:
                    self.listWidget.setRowHidden(row, True)
        self.filterMenu(filter)
        self.listWidget.setCurrentRow(-1)
        
    def filterMenu(self, filter):
        if filter is self.actionAll:
            for action in (self.actionPauseDownload, self.actionResumeDownload, self.actionRemoveFromQueue, self.actionResumeDownloads, self.actionPauseDownloads, self.actionClearQueue):
                action.setVisible(True)
        elif filter is self.actionQueued:
            for action in (self.actionPauseDownload, self.actionResumeDownload, self.actionRemoveFromQueue, self.actionResumeDownloads, self.actionPauseDownloads):
                action.setVisible(True)
            self.actionClearQueue.setVisible(False)
        else:
            for action in (self.actionPauseDownload, self.actionResumeDownload, self.actionRemoveFromQueue, self.actionResumeDownloads, self.actionPauseDownloads, self.actionClearQueue):
                action.setVisible(False)
        

    def addVideo(self, videoData):
        size = QSize()
        size.setHeight(140) # 94
        item = QListWidgetItem()
        item.setSizeHint(size)
        self.itemWidget = delegatewidgets.VideoDownloadItemWidget(self.listWidget, videoData)
        self.listWidget.addItem(item)
        self.listWidget.setItemWidget(item, self.itemWidget)
        row = self.listWidget.row(item)
        task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
        self.updateTaskStatus(task)
        
    def filterList(self, event):
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control):
            self.toolBar.setVisible(True)
            self.lineFilter.insert(event.text())
        if event.key() == Qt.Key_Backspace:
            self.lineFilter.backspace()
        for row in range(self.listWidget.count()):
            item = self.listWidget.item(row)
            itemWidget = self.listWidget.itemWidget(item)
            title = itemWidget.titleLabel.text()
            if not title.contains(self.lineFilter.text(), Qt.CaseInsensitive):
                self.listWidget.setRowHidden(row, True)
            else:
                self.listWidget.setRowHidden(row, False)
            if self.lineFilter.text() == "":
                self.toolBar.setVisible(False) 
                
        
    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        row = self.listWidget.row(item)
        self.videoinfo = youtubeservice.YouTubeVideoDownloader.taskQueue[row].video
        self.connect(videoInfoWindow, SIGNAL("playingVideo"), self.playingVideo1)
        videoInfoWindow = VideoInfoWindow(self, self.videoinfo)
        self.connect(videoInfoWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.listWidget.setCurrentRow(-1)
        self.closeFilter()
            
    @pyqtSignature("")
    def on_actionClearQueue_triggered(self):
        if youtubeservice.YouTubeVideoDownloader.currentStatus == "active":
            QMaemo5InformationBox.information(self,  "Downloads are still in progress")
        else:
            try:
                youtubeservice.YouTubeVideoDownloader.clearTasks()
                self.listWidget.clear()
                QMaemo5InformationBox.information(self, "Your downloads have been cleared")
                self.actionClearQueue.setVisible(False)
                self.actionPlayQueue.setVisible(False)
                self.emit(SIGNAL("downloadsChanged(int)"), 0)
            except:
                QMaemo5InformationBox.information(self, "Unable to clear your downloads")
            
    def cancelDownload(self):
        row = self.listWidget.currentRow()
        youtubeservice.YouTubeVideoDownloader.cancelTask(row)
        task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
        if task.getStatus() != "completed":
            self.updateTaskStatus(task)
        self.listWidget.setCurrentRow(-1)
        
    def pauseDownload(self):
        row = self.listWidget.currentRow()
        youtubeservice.YouTubeVideoDownloader.pauseTask(row)
        task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
        if task.getStatus() != "completed":
            self.updateTaskStatus(task)
        self.listWidget.setCurrentRow(-1)
        
    def resumeDownload(self):
        row = self.listWidget.currentRow()
        youtubeservice.YouTubeVideoDownloader.resumeTask(row)
        task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
        if task.getStatus() != "completed":
            self.updateTaskStatus(task)
        self.listWidget.setCurrentRow(-1)
        
    @pyqtSignature("")
    def on_actionResumeDownloads_triggered(self):
        for row in range(self.listWidget.count()):
            youtubeservice.YouTubeVideoDownloader.resumeTask(row)
            task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
            if task.getStatus() != "completed":
                self.updateTaskStatus(task)
            
    @pyqtSignature("")
    def on_actionPauseDownloads_triggered(self):
        for row in range(self.listWidget.count()):
            youtubeservice.YouTubeVideoDownloader.pauseTask(row)
            task = youtubeservice.YouTubeVideoDownloader.taskQueue[row]
            if task.getStatus() != "completed":
                self.updateTaskStatus(task)

    def updateDownloadStatus(self):
        currentTask = youtubeservice.YouTubeVideoDownloader.currentTask
        row = youtubeservice.YouTubeVideoDownloader.taskQueue.index(currentTask)
        item = self.listWidget.item(row)
        widget = self.listWidget.itemWidget(item)
        try:
            if widget.speedLabel.text() != "completed":
                widget.progressBar.setValue(int(currentTask.progress*100))
                widget.speedLabel.setText("d/l speed: %.2f KB/s" % currentTask.speed)
                if currentTask.progress  == 1.0:
                    QMaemo5InformationBox.information(self,  "Download of \'%s\' is completed" % unicode(currentTask.getTitle(), "utf-8"))
                    widget.speedLabel.setText("completed")
                    self.filterDownloads(self.filterGroup.checkedAction())
        except AttributeError:
            pass
            
    def updateTaskStatus(self,  task = youtubeservice.YouTubeVideoDownloader.currentTask):
        try:
            row = youtubeservice.YouTubeVideoDownloader.taskQueue.index(task)
            item = self.listWidget.item(row)
            widget = self.listWidget.itemWidget(item)
            for status in ("queued",  "paused",  "completed",  "cancelled",  "failed"):
                if task.getStatus() == status:
                    widget.speedLabel.setText(status)
                widget.progressBar.setValue(int(task.progress*100))
        except ValueError:
            pass

class CommentsWindow(YoutubeWindows):
    def __init__(self, parent, video):
        YoutubeWindows.__init__(self, parent)
        self.setWindowTitle("Comments")
        if youtubeservice.YouTubeDataService.currentUser != "":
            self.actionAddComment.setVisible(True)
        self.actionGoToQueue.setVisible(False)
        self.show()
        self.video = video
        videoId = self.video.media.video_id.text
        self.yt = youtubeservice.YouTubeCommentsFeed(self, videoId)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.loadComments)
        self.loadData()
        self.toggleBusy(True)

    def filterList(self, event):
        pass

    def loadComments(self, comments):
        if len(comments) < 1:
            item = QListWidgetItem("No comments")
            self.listWidget.addItem(item)  
        else:
            try:
                commentsNumber = unicode(len(comments))
                videoTitle = self.video.title.text
                for comment in comments:
                    item = QListWidgetItem()
                    item.setFlags(Qt.ItemIsEnabled)
                    self.listWidget.addItem(item)
                    commentWidget = delegatewidgets.CommentWidget(self.listWidget, comment.author[0].name.text, comment.content.text)
                    size = QSize()
                    size.setHeight(commentWidget.height())
                    item.setSizeHint(size)
                    self.listWidget.setItemWidget(item, commentWidget)
            except AttributeError:
                pass
        self.toggleBusy()

    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        pass

    def queueChanged(self, queueLength):
        pass
        
    def downloadsChanged(self,  taskQueueLength):
        pass
