# -*- coding: utf-8 -*-
from PyQt4.QtGui import *
from PyQt4.QtCore import *
try:
    from PyQt4.QtMaemo5 import QMaemo5InformationBox
except:
    pass
from Ui_myaccountwindow import Ui_MyAccountWindow
import youtubewindows
import youtubedialogs
import youtubeservice
from youtubeconfig import YouTubeAPISettings

class MyAccountWindow(QMainWindow, Ui_MyAccountWindow):
    def __init__(self, parent = None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5StackedWindow) 
        self.setWindowTitle("My Channel")
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged) 
        self.orientationChanged()
        for button in (self.uploadsButton, self.favouritesButton, self.playlistsButton, self.subscriptionsButton):            
            button.setStyleSheet("border-radius: 10px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4ABEFF, stop: 0.6 #000000);")
            self.connect(button,  SIGNAL("pressed()"), self.changeButtonStyleSheet)
            self.connect(button,  SIGNAL("released()"), self.changeButtonStyleSheet)
        self.keyPressEvent = self.showSearchDialog
        self.searchDialogRaised = False
        queueLength = len(youtubeservice.YouTubeQueueFeed.playlist)
        if queueLength > 0:
            self.actionGoToQueue.setVisible(True)
            self.actionGoToQueue.setText("Queue (%d videos)" % queueLength)
        taskQueueLength = len(youtubeservice.YouTubeVideoDownloader.taskQueue)
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%d videos)" % taskQueueLength)
        if len(YouTubeAPISettings.userDict) <= 1:
            self.actionSwitchAccount.setVisible(False)
        self.show()
        
    def changeButtonStyleSheet(self):
        button = self.sender()
        if button.isDown():
            button.setStyleSheet("border-radius: 10px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #000000, stop: 0.6 #4ABEFF);")
        else:
            button.setStyleSheet("border-radius: 10px; background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4ABEFF, stop: 0.6 #000000);")
        
    def showSearchDialog(self,  event):
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control, Qt.Key_Shift, Qt.Key_Space) and not self.searchDialogRaised:
            self.setSearchDialogRaised(True)
            searchDialog = youtubedialogs.SearchDialog(self)
            self.connect(searchDialog, SIGNAL("queueChanged(int)"), self.queueChanged)
            self.connect(searchDialog, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
            searchDialog.lineEdit.insert(event.text())
            QTimer.singleShot(1000,  lambda isRaised = False: self.setSearchDialogRaised(isRaised))
        else:
            pass
            
    def setSearchDialogRaised(self,  isRaised):
        self.searchDialogRaised = isRaised

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 800)
            self.uploadsLabel.setGeometry(QRect(97, 278, 88, 26))
            self.uploadsButton.setGeometry(QRect(80, 150 , 120, 120))
            self.playlistsLabel.setGeometry(QRect(97, 527, 88, 26))
            self.playlistsButton.setGeometry(QRect(80, 400, 120, 120))
            self.subscriptionsLabel.setGeometry(QRect(268, 527, 147, 26))
            self.favouritesLabel.setGeometry(QRect(285, 278, 111, 26))
            self.subscriptionsButton.setGeometry(QRect(280, 400, 120, 120))
            self.favouritesButton.setGeometry(QRect(280, 150, 120, 120))
        else:
            self.resize(800, 480)
            self.uploadsLabel.setGeometry(QRect(82, 250, 88, 26))
            self.uploadsButton.setGeometry(QRect(66, 123, 120, 120))
            self.playlistsLabel.setGeometry(QRect(451, 250, 88, 26))
            self.playlistsButton.setGeometry(QRect(434, 123, 120, 120))
            self.subscriptionsLabel.setGeometry(QRect(603, 250, 147, 26))
            self.favouritesLabel.setGeometry(QRect(256, 250, 111, 26))
            self.subscriptionsButton.setGeometry(QRect(616, 123, 120, 120))
            self.favouritesButton.setGeometry(QRect(251, 123, 120, 120))

    def queueChanged(self, queueLength):
        if queueLength > 0:
            self.actionGoToQueue.setVisible(True)
            self.actionGoToQueue.setText("Queue (%d videos)" % queueLength)
        else:
            self.actionGoToQueue.setVisible(False)
        self.emit(SIGNAL("queueChanged(int)"), queueLength)
        
    def downloadsChanged(self,  taskQueueLength):
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%d videos)" % taskQueueLength)
        else:
            self.actionDownloads.setVisible(False)
        self.emit(SIGNAL("downloadsChanged(int)"), taskQueueLength)

    @pyqtSignature("")
    def on_actionGoToQueue_triggered(self):
        playbackQueueWindow = youtubewindows.PlaybackQueueWindow(self)
        self.connect(playbackQueueWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        
    @pyqtSignature("")
    def on_actionDownloads_triggered(self):
        downloadsWindow = youtubewindows.DownloadsWindow(self)
        self.connect(downloadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(downloadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
            
    @pyqtSignature("")
    def on_uploadsButton_clicked(self):
        uploadsWindow = youtubewindows.UploadsWindow(self)
        self.connect(uploadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(uploadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_favouritesButton_clicked(self):
        favouritesWindow = youtubewindows.FavouritesWindow(self)
        self.connect(favouritesWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(favouritesWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_playlistsButton_clicked(self):
        playlistsWindow = youtubewindows.PlaylistsWindow(self)
        self.connect(playlistsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(playlistsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_subscriptionsButton_clicked(self):
        subscriptionsWindow = youtubewindows.SubscriptionsWindow(self)
        self.connect(subscriptionsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(subscriptionsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_actionSwitchAccount_triggered(self):
        switchAccountDialog = youtubedialogs.SwitchAccountDialog(self)
        


        
        
