import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import math
import osmgpsmap
import gobject
import md5

from h_UI_helper import *

class results_view(h_UI_helper):

    def __init__(self,osmMapa,CONFIG):
        self.osmMapa = osmMapa
        self.CONFIG = CONFIG

        self.ico = "ico_profile_32_32.png"
        self.ui_menu_main = 0
        self.ui_menu_left = 1
        self.ui_stackable = 1
        self.ui_search = 0
        self.limit_start = 0
        self.limit_count = 20
        

        self.scroll_at = [0,0]

        print "__init__ results_view"

    def killIt(self):
        return None

    def makeInit(self):
        return None
 

    def get_menu_widgets(self, dialog):
        vbox = gtk.VBox()

        if len(self.osmMapa.show_find_results)>0:
            make_from = self.osmMapa.show_find_results
        else:
            make_from = self.osmMapa.markers


        t = []
        for m in make_from:
            if m[3]:
                dis = self.osmMapa.distance( m[0], m[1])
                t.append( [dis,m] )
        t.sort()

        make_from = []
        for m in t:
            make_from.append( m[1] )
        
                
        

        self.mvbox = gtk.VBox()
        self.panel = hildon.PannableArea()
        self.panel.add_with_viewport(self.mvbox )
        vbox.pack_start( self.panel, True)
        self.add_items_to_list( make_from,dialog )

        self.mvbox .show_all()

        return vbox

    def add_items_to_list(self, make_from,dialog):
        more = 0
        added = 0
        for nr,m in enumerate(make_from):
            #print m
            if m[3] and added < self.limit_count and nr >= self.limit_start:
                added+=1
                
                osm = osmgpsmap.GpsMap()
                osm.set_center_and_zoom( m[0], m[1], 16 )
                osm.set_size_request(140, 140)
                osm.image_add( m[0], m[1], m[4] )
                osm.connect('button_release_event', self.on_map_clicked, m[0], m[1],dialog)
                osm.connect('button_press_event', self.on_map_clicked, m[0], m[1],dialog)
                
                
                dbox = gtk.VBox()
                l = self.get_label("<b>%s</b>"%m[3])
                dbox.pack_start( l, False)
                dis = self.osmMapa.distance_to_string( self.osmMapa.distance( m[0], m[1]) )
                info = "<small><u>%s</u>\t\t<i>%s</i></small>"% (dis, m[2])
                l1 = self.get_label( info )
                dbox.pack_start( l1, False)

                ibox = gtk.HBox(spacing=5)
                ibox.pack_start( osm, False)
                ibox.pack_start( dbox, False)

                ebox = gtk.EventBox()
                ebox.add( ibox )
                ebox.connect("button-press-event", self.on_ebox_click)
                ebox.connect("button-release-event", self.on_ebox_release_click, m,dialog)

                self.mvbox .pack_start( gtk.HSeparator(), False)
                self.mvbox .pack_start( ebox, False)
            else:
                more = 1
        
        if more:
            self.mvbox.pack_start( self.bt("More", self.on_bt_more, make_from,dialog), True)
    
    def on_bt_more(self,w, make_from,dialog):
        self.panel.hide()
        w.destroy()
        self.limit_start+=self.limit_count
        self.add_items_to_list( make_from,dialog)
        self.panel.show_all()
    
    def on_ebox_click(self,w,a):
        self.scroll_at = [ self.panel.get_vadjustment().get_value(), self.panel.get_hadjustment().get_value() ]

    def on_ebox_release_click(self,w,a,point,dialog):
        print "re ebox"
        scroll_tmp = [ self.panel.get_vadjustment().get_value(), self.panel.get_hadjustment().get_value() ]
        if self.scroll_at == scroll_tmp:
            dialog.destroy()
            self.osmMapa.build_details( point )

    def on_map_clicked(self,osm,event, lat, lon,dialog):
        dialog.destroy()
        self.osmMapa.set_gpslock(False)
        self.osmMapa.osm.set_center_and_zoom( lat, lon, 16 )

    def get_name(self):
        return "Results view"

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass