import gtk
import hildon
import osmgpsmap
import gobject
import os


from h_UI_selectContact import *
from h_UI_helper import *

class DetailsWindow(hildon.StackableWindow, h_UI_helper):

    def __init__(self, osmMapa, point, config):
        hildon.StackableWindow.__init__(self)


        self.point = point
        self.osmMapa = osmMapa
        self.CONFIG = config

        self.osmMapa.set_autorotate_for_object(self)

        self.menu = None
        self.address = ""
        
        tlldbox = gtk.VBox()

        self.download_geonams = 0

        if len(point) == 2:
            print "point only LL use geonames to build it"
            ll = point
            point = [
                     ll[0],
                     ll[1],
                     "What's here?",
                     "-",
                     gtk.gdk.pixbuf_new_from_file("./maps/ico_igla_32_32.png"),
                     None,
                     7  ]
            
            

        
        
        


        self.details_share = ""

        #self.set_default_size(500, 500)
        self.set_title("Details")

        print "----[ details for ]-----------\n",point,"\n--------------------------"


        vbox = gtk.VBox()
        vbox0 = gtk.VBox()



        lrbox = gtk.HBox()

        tlldbox.pack_start( self.get_label("<big>%s</big>" % point[3]) , False)
        self.details_share = "%s " % point[3]


        tlldbox.pack_start( self.get_label(
            "<small>%s</small>" %  self.osmMapa.distance_to_string( self.osmMapa.distance( point[0], point[1]) )
            )
            , False)

        if len( point) == 8:
            d = point [7]
            try:
                tlldbox.pack_start( self.get_label("<small>%s</small>" % d['desc']), False)
            except:
                pass
            
            try:
                if d['url']:
                    tlldbox.pack_start(self.bt("Open web page", self.on_url, d['url']), False)
            except:
                pass

            try:
                if d['reference']:
                    for plugin in self.osmMapa.plugins_list:
                        if plugin[1] == "Google - places":
                            ref_downloader = plugin[0]
                            ref_downloader.get_reference( d['reference'] )
                            self.ref_downloader_loop(ref_downloader, tlldbox, point)
                            self.download_geonams = 1
                            break
            except:
                pass

        self.details_share = "%slat/lon: %f,%f " % (self.details_share, point[0], point[1])


        tlldbox.pack_start( self.get_label("Latitude: <small>%f</small>" % point[0]), False)
        tlldbox.pack_start( self.get_label("Longitude: <small>%f</small>" % point[1]), False)
        tlldbox.pack_start( self.get_label("Point from : <small>%s</small>" % point[2]), False)

        try:
            if point[7]['address']:
                tlldbox.pack_start( self.get_label("Addres: <small>%s</small>" % point[7]['address']), False)
                self.details_share = "%s %s" % ( point[7]['address'], self.details_share )
                self.address = point[7]['address']
                
                
        except Exception, e:
                print "add reference error [7] address",e
        try:
            if point[7]['tel']:
                self.details_share = "%stel: %s" % (self.details_share, point[7]['tel'])

                hbox0 = gtk.HBox()
                l = gtk.Label("Phone: ")
                hbox0.pack_start(l, False)

                hbox0.pack_start(self.bt("%s" % point[7]['tel'], self.on_call_clicked, point[7]['tel']), False)

                tlldbox.pack_start( hbox0, True)
        except Exception, e:
                print "add reference error [7] tel",e

        self.bt_hbox = gtk.HBox()

        if point[2] == "Google - places":
            powerBy = gtk.Image()
            powerBy.set_from_file("./plugins/powered-by-google-on-black.png")
            tlldbox.pack_start( powerBy, False)
        else:
            if self.osmMapa.send_to_contact_present():
                self.bt_hbox.pack_end(self.osmMapa.send_to_contact_dialog(self.details_share), False)


        lrbox.pack_start( tlldbox, True)

        osm = osmgpsmap.GpsMap()
        osm.set_center_and_zoom( point[0], point[1], 16 )
        osm.set_size_request(240, 240)
        osm.image_add( point[0], point[1], point[4]  )
        osm.connect('button_release_event', self.on_map_clicked, point[0], point[1])
        osm.connect('button_press_event', self.on_map_clicked, point[0], point[1])
        lrbox.pack_start( osm, True)

        vbox.pack_start(lrbox, False)

        panel = hildon.PannableArea()
        panel.add_with_viewport(vbox)
        panel.set_size_request(640, 640)
        vbox0.pack_start( panel, True)



        self.bt_hbox.pack_start( self.bt("Mapa", self.on_mapa, point[0], point[1]), True)




        if self.CONFIG['POI']:
            self.bt_hbox.pack_start( self.bt("POI",self.on_add_as_poi,point[0],point[1]), True)

        if self.CONFIG['Google - routesearch']:
            self.bt_hbox.pack_start( self.bt("Route",self.on_route_to_it,point[0],point[1]), True)




        vbox.pack_start(self.bt_hbox,False)

        self.vbox = gtk.VBox()
        self.add(self.vbox)

        self.vbox.pack_start(vbox0, True)


        self.build_menu()

        self.show_all()

        p = self.osmMapa.get_plugin("Google - geonames")
        if p and self.download_geonams == 0 and self.address == "":
            p.ref_dawnload( point[0], point[1])
            self.download_geonams = 1
            self.geonames_downloader_loop(p, tlldbox, point[0],point[1])


        #self.run()
        #self.destroy()
    
    def on_url(self,w,url):
        os.system("dbus-send --system --type=method_call --dest=\"com.nokia.osso_browser\" --print-reply /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:\"%s\"" % url)
    
    def build_menu(self):
        if self.menu == None:
            self.menu = hildon.AppMenu()
            self.set_app_menu(self.menu)
            
        add = 0
        if self.address:
            add = 1
            m_add_atc = gtk.Button("Add address to contact")
            m_add_atc.connect("clicked", self.on_m_add_atc, self.address)
            self.menu.append(m_add_atc)
            
        
        if add:
            print "add address menu "
            self.menu.show_all()
    def on_m_add_atc(self, w,address):
        print "-- add address to contact start --[%s]" %address
        sc = SelectContact( self.osmMapa, None, "add address", address )
        sc.start_dialog()

    def geonames_downloader_loop(self,ref_downloader, tlldbox, lat,lon):
        if ref_downloader.ref_result == []:
            gobject.timeout_add( 1000, self.geonames_downloader_loop, ref_downloader, tlldbox, lat,lon )
        else:
            try:
                tlldbox.pack_start( self.get_label("Addres: <small>%s</small>" % ref_downloader.ref_result[1]), False)
                self.details_share = "%s %s" % ( ref_downloader.ref_result[1], self.details_share )
                self.address = ref_downloader.ref_result[1]
                self.build_menu()
                tlldbox.show_all()
            except Exception, e:
                print "add reference error",e

    def ref_downloader_loop(self, ref_downloader, tlldbox, point):
        if ref_downloader.ref_result == []:
            gobject.timeout_add( 1000, self.ref_downloader_loop, ref_downloader, tlldbox, point )
        else:
            try:
                tlldbox.pack_start( self.get_label("Addres: <small>%s</small>" % ref_downloader.ref_result[1]), False)
                self.address = ref_downloader.ref_result[1]
                self.build_menu()
                hbox = gtk.HBox()
                l = gtk.Label("Phone: ")
                hbox.pack_start(l, False)

                self.details_share = "%stel: %s; %s" % (self.details_share, ref_downloader.ref_result[2], ref_downloader.ref_result[1])
                hbox.pack_start( self.bt( "%s" % ref_downloader.ref_result[2], self.on_call_clicked, ref_downloader.ref_result[2] ), True)

                tlldbox.pack_start( hbox, False)

                tlldbox.show_all()


                if self.osmMapa.send_to_contact_present():
                    self.bt_hbox.pack_start(self.osmMapa.send_to_contact_dialog(self.details_share), False)

                self.bt_hbox.pack_start( self.bt("Add Contact",self.on_bt_addContact,ref_downloader.ref_result, point), True)
                bt_addContact.show_all()


            except Exception, e:
                print "add reference error",e

    def on_call_clicked(self,w,tel):
        #os.system(  "dbus-send --system --dest=com.nokia.csd.Call --type=method_call --print-reply /com/nokia/csd/call com.nokia.csd.Call.CreateWith string:\"%s\" uint32:0 &" % tel )
        os.system(  "dbus-send --system --type=method_call --print-reply --dest=com.nokia.csd.Call /com/nokia/csd/call com.nokia.csd.Call.CreateWith string:\"%s\" uint32:0" % tel.replace(" ", "") )

    def on_bt_addContact(self,w, store, point):
        print "--- add concat --- "
        sc = SelectContact()
        sc.add_new_concat(
                          store[0],
                          store[2],
                          store[1],
                          point[4]
                          )
        
        print "--- add concat DONE --- "

    def on_route_to_it(self, w, lat, lon):
        p = None
        for plugin in self.osmMapa.plugins_list:
            if plugin[1] == "Google - routesearch":
                p = plugin[0]
                break
        print "p:",p
        if p <> None:
            self.CONFIG['google_routesearch_from'] = "my current location"
            self.CONFIG['google_routesearch_to'] = "loc:%f+%f" %( lat, lon)
            p.search_action()
            self.destroy()

    def on_add_as_poi(self, w, lat, lon):
        poi = None
        for plugin in self.osmMapa.plugins_list:
            if plugin[1] == "POI":
                poi = plugin[0]
                break
        if poi <> None:
            self.osmMapa.osm.set_center( lat,lon)
            poi.on_add( None,None )
            self.destroy()

    def on_map_clicked(self,osm,event, lat, lon):
        osm.set_center_and_zoom( lat, lon, 16 )

    def on_mapa(self,w,lat,lon):
        self.osmMapa.osm.set_center_and_zoom( lat, lon, 16 )
        self.destroy()


    