/*
 * yellownotes-applet: a maemo home applet for yellow notes
 * Copyright (C) 2007-2010 Gabriel Nava <gabriel.nava@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option); any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef YELLOWNOTES_H
#define YELLOWNOTES_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define APPLET_X_SIZE 300
#define APPLET_Y_SIZE 200
#define TOOLBAR_Y_SIZE 22

#define MIN_X_SIZE 140
#define MAX_X_SIZE 680
#define MIN_Y_SIZE 140
#define MAX_Y_SIZE 400

#define SETTINGS_PATH	".yellownotes"
#define EXISTING_NOTE	"note"
#define PREFS_FILE	"yellownotes.conf"

#define DEFAULT_COLOR		"#ffff00"
#define DEFAULT_FONT_COLOR	"#000000"
#define DEFAULT_FONT		"Sans 12"
#define DEFAULT_BG_ALPHA	50



typedef struct _YellowNotesPlugin YellowNotesPlugin;
typedef struct _YellowNotesPluginClass YellowNotesPluginClass;

#define YELLOWNOTES_TYPE_HOME_PLUGIN   (yellownotes_home_plugin_get_type ())

#define YELLOWNOTES_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN, YellowNotesHomePlugin))

#define YELLOWNOTES_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN,  YellowNotesPluginClass))

#define YELLOWNOTES_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN))
 
#define YELLOWNOTES_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN))

#define YELLOWNOTES_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN,  YellowNotesHomePluginClass))
 
struct _YellowNotesPlugin
{
	    HDHomePluginItem hitem;
};
 
struct _YellowNotesPluginClass
{
	    HDHomePluginItemClass parent_class;
};
 
GType yellownotes_plugin_get_type(void);

HD_DEFINE_PLUGIN_MODULE (YellowNotesPlugin, yellownotes_plugin, HD_TYPE_HOME_PLUGIN_ITEM);

static void yellownotes_plugin_realize (GtkWidget *widget);
static gboolean yellownotes_plugin_expose_event(GtkWidget *widget, GdkEventExpose *event);


typedef struct
{
	YellowNotesPlugin *parent;
	
	GtkWidget *frame;
	GtkWidget *align;
	GtkWidget *vbox;
	GtkWidget *hbox;

	GtkWidget *save_image;
	GtkWidget *conf_image;
	GtkWidget *delete_image;
	GtkWidget *next_image;
	GtkWidget *previous_image;
	
	GtkWidget *top;
	GtkWidget *conf_evbox;
	GtkWidget *delete_evbox;
	GtkWidget *save_evbox;
	GtkWidget *next_evbox;
	GtkWidget *previous_evbox;
	GtkWidget *label;

	GtkWidget *textview;
	GdkWindow *textwindow;
	GtkTextBuffer *buffer;
	GtkScrolledWindow *scrolledwindow;
	GtkWidget *vscroll;
	GtkWidget *hscroll;
	
	GtkWidget *entry_width;
	GtkWidget *entry_height;
	GtkWidget *entry_bg_alpha;
	GdkColor color;
	GdkColor fontcolor;
	gchar *fontname;
	gfloat bg_alpha;
	
	gchar *prefs_dir;
	gchar *conf_file;
	gchar *note_file;
	
	gint applet_x_size;
	gint applet_y_size;

	gint *note_number;
	gint *locked;

} YNCtx;

/*save applet preferences to disk*/
void save_applet_prefs(YNCtx *app);

/*adjusting width and height not to exceed max size allowed*/
void adjust_settings(YNCtx *app);

/*read preferences from config file and load into object*/
void load_applet_prefs(YNCtx *app);

/*write text form buffer to disk*/
int write_buffer_to_file(gchar *buffer,gchar *fn);

/*read note text from file and load into buffer*/
void load_note_text(YNCtx *app);

/*callback used to save note when swhitching beteween notes.  --needs to be removed-- */
gboolean save_note_text(YNCtx *app,GtkTextBuffer *buffer);

/*callback used to edit note content in dialog*/
gboolean edit_note(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to switch to next note (right arrow)*/
gboolean next_note(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to switch to previous note (left arrow)*/
gboolean previous_note(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to erase note content (trashcan button)*/
gboolean erase_note(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to get background color selection*/
void select_bg_color(GObject *o, YNCtx *app);

/*callback to get text font selection*/
void select_font(GObject *o, YNCtx *app);

/*callback to get font color selection*/
void select_font_color(GObject *o, YNCtx *app);

/*function to apply color and alpha value to widget using cairo*/
void set_cairo_transparency(GdkDrawable *drawable, GdkEventExpose *event, GdkColor color, gfloat alpha);

/*callback to apply preferences once user changes values in settings dialog*/
void apply_preferences(YNCtx *app);

/*callback to show settings dialog (settings button) --not used in fremantle*/
gboolean configure_applet_button(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to show settings dialog in Desktop editing mode (fremantle)*/
gboolean configure_applet(GtkWidget *o,YNCtx *app);

/*create desktop widget applet and build UI*/
void mkplugin_create_home_applet(YNCtx *app);
void build_ui(void);

/*widget style to unset sapwood engine for scrollbar.
RGBA colormap has conflict with default theme's PNGs*/
gchar *scroll_style="style \"my-style\" \
{ \
	bg[NORMAL] = \"#666666\" \
	bg[ACTIVE] = \"#000000\" \
        GtkRange::stepper_size = 26 \
        GtkRange::stepper_spacing = 0 \
        GtkRange::trough_border = 0 \
        GtkRange::slider_width = 20 \
        GtkRange::draw_trough_under_steppers = 0 \
        GtkRange::draw_trough = 0 \
        GtkRange::arrow_displacement_x = 0 \
        GtkRange::arrow_displacement_y = 0 \
        GtkRange::autodimmed_steppers = 1 \
        GtkScrollbar::min-slider-length = 32 \
	GtkScrollbar::scrollbar-spacing = 0 \
        GtkRange::activate-slider = 1 \
	engine \"\" { } \
} \
class \"GtkScrollbar\" style \"my-style\"";

G_END_DECLS

#endif

