#include "targetlist.h"

#include <QString>
#include <QFile>
#include <QTextStream>
#include <QList>

Target::Target(QObject *parent) :
    QObject(parent)
{
}

TargetList::TargetList(QObject *parent) :
    QObject(parent)
{
}

void TargetList::getFromFile(QString sFilename)
{
    Target *tg;


    QFile file(sFilename);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QString sVersion;
        QTextStream in(&file);
        sVersion =in.readLine();
        tg=new Target;
        if(sVersion=="1.0")  //Assuming first config file
        {
            tg->sIP=in.readLine();
            tg->sMAC=in.readLine();
            tg->iPort=in.readLine().toInt();
            tg->itcpPort=in.readLine().toInt();
            tg->iTimeOut=in.readLine().toInt();
            //tg->append("Hello");
            lstTarget.append(*tg);
        }
    }
    file.close();
}

void TargetList::saveToFile(QString sFilename)
{
    int i;
    QFile file(sFilename);
    if (file.open(QIODevice::WriteOnly | QIODevice::Truncate | QIODevice::Text))
    {

        QTextStream out(&file);

        out << "1.0\n"; // Version 1.0of the config file
        for (i=0;i< lstTarget.size();++i)
        {
            out << lstTarget.at(i).sIP << "\n";
            out << lstTarget.at(i).sMAC << "\n";
            out << lstTarget.at(i).iPort << "\n";
            out << lstTarget.at(i).itcpPort << "\n";
            out << lstTarget.at(i).iTimeOut << "\n";
        }
    }
    file.close();
}
