#ifndef STATUS_H
#define STATUS_H

/*
  WifiInfo - Show current Wifi sttaus
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <list>
#include <string>

#include <Lum/Model/Action.h>

#include <Lum/OS/Thread.h>

class Status
{
public:
  enum Type {
    typeNone,            //! Not connected
    typeAuto,            //! Automatic
    typeAdHoc,           //! Ad hoc network between individual cells
    typeInfrastructure,  //! Multi cell network
    typeMaster,          //! Synchronisation mater or AP
    typeRepeater,        //! Repeater
    typeSecond,          //! Second master/ repeater (backup)
    typeMonitor,         //! Passive monitor
    typeMesh             //! Mesh network
  };

  enum PowerSaving {
    powerSavingOn,
    powerSavingOff,
    powerSavingUnknown
  };

  enum Encryption {
    cryptNone    = 1 << 0,
    cryptWEP     = 1 << 1,
    cryptWPA_PSK = 1 << 2,
    cryptWPA_EAP = 1 << 3,
    cryptWPA2    = 1 << 4
  };

  class Network
  {
  public:
    std::wstring  essid;
    Type          type;
    unsigned      bitrate;
    unsigned long encryption;
    int           channel;
    int           quality;

    Network()
    {
      Clear();
    }

    void Clear()
    {
      type=typeNone;
      bitrate=0;
      encryption=0;
      quality=-1;
      channel=-1;
    }
  };

public:
  std::string        defaultInterface;

  Lum::OS::Mutex     mutex;
  std::wstring       typeName;
  Type               type;
  std::wstring       essid;
  unsigned           bitrate;
  int                channel;
  int                quality; // [0..100%]
  int                signal;  // dBm
  int                noise;   // dBm
  std::wstring       accesspoint;
  std::wstring       ip;
  std::wstring       mac;
  PowerSaving        powerSaving;

  std::list<Network> networks;

  Lum::Model::ActionRef statusChangedAction;
  Lum::Model::ActionRef networksChangedAction;

public:
  Status();
  virtual ~Status();

  void SetDefaultInterface(const std::string& defaultInterface);

  virtual std::string GetDefaultInterface() const;

  void ClearStatus();
  int GetQualityFromSignalNoiseDbm(int signal, int noise);

  virtual bool UpdateStatus();

  virtual bool SupportsNetworkRetrieval() const = 0;

  virtual bool UpdateNetworks();

  virtual bool CanChangePowerSaving() const;
  virtual bool SetPowerSaving(bool savePower);
};

#endif
