from gnome import gconf
from wifi_assistant.settings.application_settings import ApplicationSettings

import unittest

class ApplicationSettingsTest(unittest.TestCase):

    def setUp(self):
        self.gc = gconf.client_get_default()
        self.root = '/apps/maemo/wifi/unit_tests'
        self._clearGConf(self.root)
        self._setupDefaultValues(self.root)
        self._firstCallbackCalled = None
        self._secondCallbackCalled = None
        self.testee = ApplicationSettings(self.gc, self.root)
        
    def _setupDefaultValues(self, dir):
        self.gc.set_bool(dir + '/daemon', True)

    # FIXME: inherit
    def _clearGConf(self, dir):
        # there's no recursive_unset available
        all_entries = self.gc.all_entries(dir)
        for entry in all_entries:
            self.gc.unset(entry.get_key())
        for sub_dir in self.gc.all_dirs(dir):
            self._clearGConf(sub_dir)
        self.gc.suggest_sync()
        

    def test_default_is_to_use_popup(self):
        assert self.testee.getUsePopup() is True
    
    
    def test_setting_use_popup_works(self):
        assert self.testee.getUsePopup() is True

        self.testee.setUsePopup(False)
        assert self.testee.getUsePopup() is False

        self.testee.setUsePopup(True)
        assert self.testee.getUsePopup() is True
        
    
    def test_bug_11210_popupDialogIsEnabledByDefault(self):
        def empty(*args):
            pass
        
        # run test without any default values - gconf should be empty
        self._clearGConf(self.root)
        
        assert self.testee.getUsePopup() is True
    
    
    def dont_test_adding_two_listeners_removing_one_still_notifies_first_listener(self):
        firstSignal = False
        secondSignal = True
        
        self.testee.registerUsePopupListener(self._firstCallback)
        self.testee.registerUsePopupListener(self._secondCallback)
        
        # TODO: start thread to have signalling work properly ... 
        
        self.testee.setUsePopup(firstSignal)
        
        assert self._firstCallbackCalled == firstSignal
        assert self._secondCallbackCalled == firstSignal
    
        self.testee.unregisterUsePopupListener(self._secondCallback)
        self.testee.setUsePopup(secondSignal)
        
        assert self._firstCallbackCalled == secondSignal
        assert self._secondCallbackCalled == firstSignal
        
    
    def _firstCallback(self, value):
        self._firstCallbackCalled = value
        
    def _secondCallback(self, value):
        self._secondCallbackCalled = value
    
    
if __name__ == '__main__':
    unittest.main()

