#!/usr/bin/python2.5
from gnome import gconf

class ApplicationSettings():
    
    def __init__(self, gconf_client, gconf_root_dir):
        self._gc = gconf_client
        self._gconfRootDir = gconf_root_dir
        self._gconfPopupKey = gconf_root_dir + '/daemon'
        self._listeners = {}
    
    # ---- public API __________________________________________________________
        
    def registerUsePopupListener(self, callback):
        """Registers a listener/callback to changes on Use Daemon setting"""
        
        if len(self._listeners) == 0:
            self._gc.add_dir(self._gconfRootDir, gconf.CLIENT_PRELOAD_NONE)
        ref_id = self._gc.notify_add(self._gconfPopupKey, callback)
        self._listeners[callback] = ref_id
        
    
    def unregisterUsePopupListener(self, callback):
        """Unregisters the listener/callback"""
        
        if (self._listeners.has_key(callback)):
            ref_id = self._listeners.pop(callback)
            self._gc.notify_remove(ref_id)
            
            if len(self._listeners) == 0:
                self._gc.remove_dir(self._gconfRootDir)
    
            
    def getUsePopup(self):
        """Tells whether to use the daemon or not."""
        
        value = self._gc.get_without_default(self._gconfPopupKey)
        if value is None:
            self.setUsePopup(True)
            return True
        return value.get_bool() is not False


    def setUsePopup(self, mode):
        """mode is either True or False."""
        
        self._gc.set_bool(self._gconfPopupKey, mode)
