#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class ConfigGui():
    
    def __init__(self, launcher, application_settings, network_settings, hildon_program, hildon_window, list_store):
        self._launcher = launcher
        self._application_settings = application_settings
        self._network_settings = network_settings
        self._program = hildon_program
        self._win = hildon_window
        self._model = list_store


    def main(self):
        self._win.set_title(_("Wifi Assistant"))
        pannable_area = hildon.PannableArea()
        from wifi_assistant.gui.network_settings_view import NetworkSettingsView
        view = NetworkSettingsView(self._model, pannable_area, self._editNetworkSetting)
        self._win.add(pannable_area)
        self._win.set_app_menu(self._createMenu())
        self._win.connect("destroy", gtk.main_quit, None)

        view.update()
        self._win.show_all()

    
    def _createMenu(self):
        menu = hildon.AppMenu()
        
        about = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        about.set_label(_("About"))
        about.connect("clicked", self._showAboutDialog)
        menu.append(about)
     
        settings = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        settings.set_label(_("Settings"))
        settings.connect("clicked", self._editApplicationSettings)
        menu.append(settings)
        
        add = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        add.set_label(_("Add network"))
        add.connect("clicked", self._addNetworkSetting)
        menu.append(add)
        
        delete = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        delete.set_label(_("Delete networks"))
        delete.connect("clicked", self._deleteNetworkSetting)
        menu.append(delete)
        
        menu.show_all()
        return menu
    

    def _showAboutDialog(self, x):
        from wifi_assistant.gui.about_dialog import AboutDialog
        AboutDialog(self._launcher, self._win).show()
    
        
    def _editApplicationSettings(self, x):
        from wifi_assistant.gui.application_settings_dialog import ApplicationSettingsDialog
        use_popup = self._application_settings.getUsePopup()
        url_to_open = self._network_settings.getDefaultSettings().getBrowserOptions()['url']
        ApplicationSettingsDialog(self._win, self._editApplicationSettingsCallback).show(use_popup, url_to_open)
    
    def _editApplicationSettingsCallback(self, popup, url):
        self._application_settings.setUsePopup(popup)
        settings = self._network_settings.getDefaultSettings()
        settings.getBrowserOptions()['url'] = url
        self._network_settings.save(settings)
    

    def _editNetworkSetting(self, ssid, model, iter):
        from wifi_assistant.gui.edit_network_dialog import EditNetworkDialog
        network_name, x = model.get(iter, 0, 1)  
        EditNetworkDialog(self._win, self._editNetworkSettingCallback).show(iter, network_name)

    def _editNetworkSettingCallback(self, iter, ssid, launch_browser):
        # TODO: REMOVE ssid from arg list, extract like delete networks do? 
        #self._settings.setLaunchSetting(ssid, launch_browser)    
        settings = self._network_settings.get(ssid)
        settings.setLaunchingOfBrowserEnabled(launch_browser)
        self._network_settings.save(settings)
        self._model.set(iter, 1, launch_browser)
    
    
    def _addNetworkSetting(self, x):
        from wifi_assistant.gui.add_network_dialog import AddNetworkDialog
        AddNetworkDialog(self._win, self._addNetworkSettingCallback).show()
        
    def _addNetworkSettingCallback(self, network_name, launch_browser):
        settings = self._network_settings.getDefaultSettings()
        settings.setNetworkName(network_name)
        settings.setLaunchingOfBrowserEnabled(launch_browser)
        self._network_settings.save(settings)
        self._model.append([network_name, launch_browser])
        
        # FIXME: on append, if len == 1, change main view from label to tree view
        # but do this with the model


    def _deleteNetworkSetting(self, x):
        from wifi_assistant.gui.delete_networks_dialog import DeleteNetworksDialog
        DeleteNetworksDialog(self._model, self._deleteNetworkSettingCallback).show()
    
    def _deleteNetworkSettingCallback(self, model, row_references):
        for ref in row_references:
            path = ref.get_path()
            iter = model.get_iter(path)
            ssid, x = model.get(iter, 0, 1)  
            settings = self._network_settings.get(ssid)
            self._network_settings.delete(settings)
            model.remove(iter)
