#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class AboutDialog():
    
    BUG_BUTTON = gtk.RESPONSE_YES
    DONATE_BUTTON = gtk.RESPONSE_ACCEPT
    CLOSE_BUTTON = gtk.RESPONSE_HELP
    
    # this field is updated from the Makefile's compile target
    VERSION = "0.9.1"
    
    BUG_URL = 'http://wifi-assistant.garage.maemo.org/bugs/'
    DONATE_URL = 'http://wifi-assistant.garage.maemo.org/donate/'

    def __init__(self, launcher, parent_window):
        self._launcher = launcher
        self._parent_window = parent_window


    def show(self):
        dialog = gtk.Dialog(_('About Wifi Assistant') + ' ' + AboutDialog.VERSION, self._parent_window)
        text = "I got tired of not being able to connect easily to networks guarded by a login page, " + \
            "so I created this app to scratch that itch. It's free to use, inspect, adapt and share, " + \
            "licensed under a BSD type license.\nI hope you enjoy it!"

        about_label = gtk.Label(_(text))
        about_label.set_line_wrap(True)
        dialog.vbox.add(about_label)
        
        dialog.add_button(_('File a bug'), AboutDialog.BUG_BUTTON)
        dialog.add_button(_('Donate'), AboutDialog.DONATE_BUTTON)
        dialog.add_button(_('Close'), AboutDialog.CLOSE_BUTTON)
        
        self._runDialog(dialog)
    
        
    def _responseCallback(self, dialog, result):
        dialog.hide()
        
        if result == AboutDialog.BUG_BUTTON:
            self._launcher.openUrl(_(AboutDialog.BUG_URL))
        if result == AboutDialog.DONATE_BUTTON:
            self._launcher.openUrl(_(AboutDialog.DONATE_URL))
    

    def _runDialog(self, dialog):
        dialog.connect("response", self._responseCallback)
        dialog.show_all()
