from gnome import gconf
from wifi_assistant.settings import Settings
import unittest

ssid = 'MyFoneraNetwork'

callback_value = None

class TestSettings(unittest.TestCase):
    
    def setUp(self):
        self.gconf_dir = "/apps/unit_tests"
        self.testee = Settings(self.gconf_dir)
        self.gc = gconf.client_get_default()
        
        
        # clear gconf
        all_entries = self.gc.all_entries(self.gconf_dir)
        for entry in all_entries:
            self.gc.unset(entry.get_key())
        self.gc.suggest_sync()
        all_entries = self.gc.all_entries(self.gconf_dir)
        # TODO: missing from python bindnings: self.gc.recursive_unset(self.gconf_dir)
        assert len(all_entries) == 0
    
    
    def test_normal_cycle(self):
        #empty to start with - ssid unknown
        assert self.testee.getLaunchSetting(ssid) == None
        
        # set to True - launch browser
        self.testee.setLaunchSetting(ssid, True)
        assert self.testee.getLaunchSetting(ssid) == True

        # changes to False
        self.testee.setLaunchSetting(ssid, False)
        assert self.testee.getLaunchSetting(ssid) == False

        # removes - neighbour with open WLAN moves out
        self.testee.deleteLaunchSetting(ssid)
        assert self.testee.getLaunchSetting(ssid) == None
    
    
    def test_auto_popup_cycle(self):
        self.testee.setUseDaemon(True)
        assert self.testee.getUseDaemon() == True
        
        self.testee.setUseDaemon(False)
        assert self.testee.getUseDaemon() == False
        
        
    def test_url_to_open_cycle(self):
        google = "http://www.google.com/"
        yahoo = "http://www.yahoo.com/"
        
        self.testee.setUrlToOpen(google)
        value = self.testee.getUrlToOpen()
        assert google == value
        
        self.testee.setUrlToOpen(yahoo)
        value = self.testee.getUrlToOpen()
        assert yahoo == value
    
    def test_default_url_points_to_maemo_org(self):
        self.gc.unset(self.testee._gconfUrlToOpen)
        value = self.testee.getUrlToOpen()
        assert "maemo.org" in value
        

if __name__ == '__main__':
    unittest.main()
