#!/usr/bin/python2.5
import gtk, hildon
import conic
import gobject

from launcher import Launcher
from settings import Settings

def _(str):
    return str

class Daemon():
    
    def __init__(self, launcher, settings, parent_window):
        self._settings = settings
        self._parent = parent_window
        self._launcher = launcher
        self._popup = self._settings.getUsePopup()


    def launch_browser(self):
        url = self._settings.getUrlToOpen()
        self._launcher.openUrl(url)
    
    
    def show_decision_dialog(self, ssid):
        if not self._popup:
            return
        
        dialog = gtk.Dialog(ssid, self._parent)
        dialog.vbox.set_homogeneous(False)
        
        dialog.add_button(_('No'), gtk.RESPONSE_NO)
        dialog.add_button(_('Yes'), gtk.RESPONSE_YES)
        
        label = gtk.Label(_('New network connection established - do you wish to launch a browser?'))
        label.set_line_wrap(True)
        #label.set_justify(gtk.JUSTIFY_LEFT)
        #label.set_alignment(0, 0.5)
        dialog.vbox.add(label)
    
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Remember this decision'))
        checkbox.set_active(True)
        dialog.vbox.add(checkbox)
        
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        
        launchBrowser = (result == gtk.RESPONSE_YES)
        if checkbox.get_active():
            self._settings.setLaunchSetting(ssid, launchBrowser)
        
        return launchBrowser
    
    
    def connection_established(self, ssid):
        value = self._settings.getLaunchSetting(ssid)
        if value is None:
            if self.show_decision_dialog(ssid):
                self.launch_browser()
            return
    
        if value:
            self.launch_browser()
    

    def _connection_cb(self, connection, event):
        status = event.get_status()
        if status == conic.STATUS_CONNECTED:
            # assemble id > name dict
            iap_id_to_name = {}
            iaps = connection.get_all_iaps()
            for iap in iaps:
                iap_id = iap.get_id()
                iap_name = iap.get_name()
                iap_id_to_name[iap_id] = iap_name
            
            # get name of network
            iap_id = event.get_iap_id()
            iap_name = None
            if (iap_id_to_name.has_key(iap_id)):
                iap_name = iap_id_to_name[iap_id]
            self.connection_established(iap_name)
    

    def start(self):
        self._connection = conic.Connection()
        self._connection.connect("connection-event", self._connection_cb)
        self._connection.set_property("automatic-connection-events", True)
        self._settings.addUsePopupListener(self._activateCallback)
        gtk.main()
     
    
    def stop(self):
        self._settings.removeUsePopupListener(self._activateCallback)
        self._connection.set_property("automatic-connection-events", False)
        
    
    def _activateCallback(self, gconfClient, id, gconfEntry, x):
        self._popup = gconfEntry.get_value().get_bool()


if __name__ == "__main__":
    d = Daemon(Launcher(), Settings(), gtk.Window())
 
    d.start()
    d.stop()
