/*
 * authdbusadaptor.h - dbus auth manager class.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#ifndef AUTHDBUSADAPTOR_H_
#define AUTHDBUSADAPTOR_H_


#include <QtDBus>
#include <QtDBus/QtDBus>
#include <QtCore/QObject>


/*
 * Adaptor class for interface org.lomalan.AuthManager
 */
class AuthDBusAdaptor: public QDBusAbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.lomalan.AuthManager")
    Q_CLASSINFO("D-Bus Introspection", ""
        "  <interface name=\"org.lomalan.AuthManager\" >\n"
        "    <method name=\"SetProxy\" >\n"
        "      <arg direction=\"in\" type=\"s\" name=\"proxyIP\" />\n"
        "      <arg direction=\"in\" type=\"s\" name=\"proxyPort\" />\n"
        "      <arg direction=\"in\" type=\"s\" name=\"username\" />\n"
        "      <arg direction=\"in\" type=\"s\" name=\"password\" />\n"
        "    </method>\n"
        "    <method name=\"Auth\" >\n"
        "      <arg direction=\"in\" type=\"s\" name=\"url\" />\n"
        "      <arg direction=\"in\" type=\"as\" name=\"params\" />\n"
        "      <arg direction=\"out\" type=\"s\" name=\"authResult\" />\n"
        "    </method>\n"
        "    <method name=\"Auth\" >\n"
        "      <arg direction=\"in\" type=\"s\" name=\"url\" />\n"
        "      <arg direction=\"out\" type=\"s\" name=\"authResult\" />\n"
        "    </method>\n"
        "    <method name=\"Login\" >\n"
        "      <arg direction=\"in\" type=\"s\" name=\"clientID\" />\n"
        "      <arg direction=\"out\" type=\"s\" name=\"loginResult\" />\n"
        "    </method>\n"
        "    <method name=\"Captcha\" >\n"
        "      <arg direction=\"in\" type=\"s\" name=\"strBase64\" />\n"
        "      <arg direction=\"in\" type=\"s\" name=\"clientdID\" />\n"
        "      <arg direction=\"out\" type=\"s\" name=\"captchaResult\" />\n"
        "    </method>\n"
        "   <signal name=\"message\">\n"
        "            <arg direction=\"out\" type=\"as\" name=\"authResult\" />\n"
        "    </signal>\n"
        "   <signal name=\"captchamsg\">\n"
        "            <arg direction=\"out\" type=\"as\" name=\"captchaResult\" />\n"
        "    </signal>\n"
        "  </interface>\n"
        "")

    private:
        static const char* connectionName;
        static const char* serviceName;
        static const char* objectName;
        static const char* messageSignalName;
        static const char* captchamsgSignalName;
        static const char* loginmsgSignalName;
        static const char* shutdownSignalName;

        QDBusConnection connection;

    public:
        AuthDBusAdaptor(QObject *parent);
        virtual ~AuthDBusAdaptor();

        bool InitDBusService();
        static bool sendSignal(const QString &signalName, const QList<QVariant> &signalParams, bool auth);
        static bool sendLoginSignal(const QString &signalName, const QList<QVariant> &signalParams);

        const char* getConnectionName();
        const char* getShutdownSignalName();

    public Q_SLOTS: // METHODS
        void SetProxy(const QString &proxyIP, const QString &proxyPort,
                const QString &username, const QString &password);

        QString Auth(const QString &url, const QStringList &params);
        QString Auth(const QString &url);
        QString Captcha(const QString &strBase64, const QString clientID);
        QString Login(const QString &clientID);
        void Shutdown();

    Q_SIGNALS: //           SIGNALS
        void setProxy(const QString &proxyIP, const QString &proxyPort,
                const QString &username, const QString &password);

        void auth(const QString &url);
        void auth(const QString &url, const QStringList &params);
        void captcha(const QString &strBase64, const QString clientID);
        void login(const QString &clientID);
        void shutdown();
};

#endif
