/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "settingsdialog.hpp"
#include "ui_settingsdialog.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class SettingsDialogPrivate
{
public:
  SettingsDialog* self;

  // Properties
  Ui_SettingsDialog ui;

  // Functions
  void init();
};

//////////////////////////////////////////////////////////////////////////

void SettingsDialogPrivate::init()
{
  // Setup the ui
  ui.setupUi(self);

  // Maemo5 has some stupid bug with the margins of the QGroupBox, so we'll
  // fix this here manually
#ifdef Q_WS_MAEMO_5
  foreach(QGroupBox* groupBox, self->findChildren<QGroupBox*>())
  {
    QMargins margins = groupBox->contentsMargins();
    margins.setTop( margins.top() + 20 );
    groupBox->setContentsMargins(margins);
  }
#endif // Q_WS_MAEMO_5
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

SettingsDialog::SettingsDialog(QWidget* parent /* = 0 */, Qt::WindowFlags f /* = 0 */)
: QDialog(parent, f)
, d(new SettingsDialogPrivate)
{
  d->self = this;
  d->init();
}

//////////////////////////////////////////////////////////////////////////

SettingsDialog::~SettingsDialog()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

void SettingsDialog::setSettings(const Settings& settings)
{
  d->ui.prefixNumbersCheckBox->setChecked( settings.prefixNumbers() );
  d->ui.countryCodePrefixLineEdit->setText( settings.prefix() );
  d->ui.notifyPrefixedCheckBox->setChecked( settings.notifyOnPrefix() );
  d->ui.hideReceiversNumbersCheckBox->setChecked( settings.hideReceiverNumbers() );
  d->ui.messageInputPlatformModeCheckBox->setChecked( settings.usePlatformDisplayMode() );
}

//////////////////////////////////////////////////////////////////////////

Settings SettingsDialog::settings() const
{
  Settings settings;
  settings.setPrefixNumbers( d->ui.prefixNumbersCheckBox->isChecked() );
  settings.setPrefix( d->ui.countryCodePrefixLineEdit->text() );
  settings.setNotifyOnPrefix( d->ui.notifyPrefixedCheckBox->isChecked() );
  settings.setHideReceiverNumbers( d->ui.hideReceiversNumbersCheckBox->isChecked() );
  settings.setUsePlatformDisplayMode( d->ui.messageInputPlatformModeCheckBox->isChecked() );
  return settings;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
