/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "providerinfo.hpp"

// Global includes
#include <QtCore/QSharedData>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class ProviderInfoData : public QSharedData
{
public:
  ProviderInfoData() : QSharedData()
  {
  }

  ProviderInfoData(const ProviderInfoData& other)
  : QSharedData(other)
  , visibleName(other.visibleName)
  , providerId(other.providerId)
  , icon(other.icon)
  , country(other.country)
  , providerType(other.providerType)
  {
  }

  QString visibleName;
  QUuid providerId;
  QIcon icon;
  QLocale::Country country;
  ProviderType providerType;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

ProviderInfo::ProviderInfo()
: data(new ProviderInfoData)
{
}

//////////////////////////////////////////////////////////////////////////

ProviderInfo::ProviderInfo(const ProviderInfo& cpy)
: data(cpy.data)
{
}

//////////////////////////////////////////////////////////////////////////

ProviderInfo::ProviderInfo(const QString& visibleName,
                           const QString& providerId,
                           const QIcon& icon,
                           QLocale::Country country,
                           ProviderType type)
: data(new ProviderInfoData)
{
  data->visibleName  = visibleName;
  data->providerId   = providerId;
  data->icon         = icon;
  data->country      = country;
  data->providerType = type;
}

//////////////////////////////////////////////////////////////////////////

ProviderInfo::~ProviderInfo()
{
}

//////////////////////////////////////////////////////////////////////////

ProviderInfo& ProviderInfo::operator=(const ProviderInfo& other)
{
  if ( this != &other )
    data.operator=(other.data);

  return *this;
}

//////////////////////////////////////////////////////////////////////////

void ProviderInfo::setVisibleName(const QString& visibleName)
{
  data->visibleName = visibleName;
}

//////////////////////////////////////////////////////////////////////////

QString ProviderInfo::visibleName() const
{
  return data->visibleName;
}

//////////////////////////////////////////////////////////////////////////

void ProviderInfo::setProviderId(const QUuid& providerId)
{
  data->providerId = providerId;
}

//////////////////////////////////////////////////////////////////////////

QUuid ProviderInfo::providerId() const
{
  return data->providerId;
}

//////////////////////////////////////////////////////////////////////////

void ProviderInfo::setIcon(const QIcon& icon)
{
  data->icon = icon;
}

//////////////////////////////////////////////////////////////////////////

QIcon ProviderInfo::icon() const
{
  return data->icon;
}

//////////////////////////////////////////////////////////////////////////

void ProviderInfo::setCountry(const QLocale::Country& country)
{
  data->country = country;
}

//////////////////////////////////////////////////////////////////////////

QLocale::Country ProviderInfo::country() const
{
  return data->country;
}

//////////////////////////////////////////////////////////////////////////

void ProviderInfo::setProviderType(const ProviderType& providerType)
{
  data->providerType = providerType;
}

//////////////////////////////////////////////////////////////////////////

ProviderType ProviderInfo::providerType() const
{
  return data->providerType;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
