/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef SETTINGS_HPP
#define SETTINGS_HPP

// Global includes
#include <QtCore/QSharedDataPointer>
#include <QtCore/QSettings>
#include <QtCore/QSharedData>
#include <QtCore/QString>
#include <QtCore/QLocale>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class SettingsPrivate : public QSharedData
{
public:
  SettingsPrivate()
    : prefixNumbers(false)
    , notifyOnPrefix(true) // We're better notifying by default
    , hideReceiverNumbers(true)
    , usePlatformDisplayMode(true)
  {
    // German number prefix
    if ( QLocale::system().country() == QLocale::Germany )
    {
      prefixNumbers = true;
      prefix = "+49";
    }
    else
      prefix = "+XX";
  }

  SettingsPrivate(const SettingsPrivate& cpy)
    : QSharedData(cpy)
    , prefixNumbers(cpy.prefixNumbers)
    , prefix(cpy.prefix)
    , notifyOnPrefix(cpy.notifyOnPrefix)
    , hideReceiverNumbers(cpy.hideReceiverNumbers)
    , usePlatformDisplayMode(cpy.usePlatformDisplayMode)
  {}

  bool prefixNumbers;
  QString prefix;
  bool notifyOnPrefix;
  bool hideReceiverNumbers;
  bool usePlatformDisplayMode;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class Settings
{
public:
  Settings();
  Settings(const Settings& cpy);
  ~Settings();

  /// Functions for loading and saving
  void load(QSettings& settings);
  void save(QSettings& settings);

  /// Should numbers be prefixed?
  void setPrefixNumbers(bool prefixNumbers);
  bool prefixNumbers() const;

  /// Get/Set the number prefix
  void setPrefix(const QString& prefix);
  QString prefix() const;

  /// Does the user want to be notified when a number is prefixed?
  void setNotifyOnPrefix(bool notifyOnPrefix);
  bool notifyOnPrefix() const;

  /// Should receiver numbers be hidden?
  void setHideReceiverNumbers(bool hideReceiverNumbers);
  bool hideReceiverNumbers() const;

  /// Should we use the platform display mode?
  void setUsePlatformDisplayMode(bool usePlatformDisplayMode);
  bool usePlatformDisplayMode() const;

private:
  QSharedDataPointer<SettingsPrivate> d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // SETTINGS_HPP
